/*
 * Copyright 2013-2018 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.support;

import java.text.ParseException;

import javax.swing.text.PlainDocument;

/**
 * Superclass for <code>Document</code> models with output formats.
 */
public class G9Document extends PlainDocument implements G9FieldValue {
    private Object value;
    private int datatype;
    private String inputFormat;
    private String outputFormat;
    private int maxLength;
    private boolean inputMode = false;
    private String name;

    /**
     * @return the name
     */
    public String getName() {
        return name;
    }

    /**
     * @param name the name to set
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * @param datatype (missing javadoc)
     * @param inputFormat (missing javadoc)
     * @param outputFormat (missing javadoc)
     * @param maxLength (missing javadoc)
     */
    public G9Document(int datatype, String inputFormat, String outputFormat, int maxLength) {
        super();
        this.datatype = datatype;
        this.inputFormat = inputFormat;
        this.outputFormat = outputFormat;
        this.maxLength = maxLength;
    }

    /**
     * (missing javadoc)
     */
    public G9Document() {
        super();
    }

    /**
     * Access method for the datatype property.
     *
     * @return the current value of the datatype property
     */
    public int getDatatype() {
        return datatype;
    }

    /**
     * Access method for the inputFormat property.
     *
     * @return the current value of the inputFormat property
     */
    public String getInputFormat() {
        return inputFormat;
    }

    /**
     * Sets the value of the inputFormat property.
     *
     * @param aInputFormat the new value of the inputFormat property
     */
    public void setInputFormat(String aInputFormat) {
        inputFormat = aInputFormat;
    }

    /**
     * Access method for the outputFormat property.
     *
     * @return the current value of the outputFormat property
     */
    public String getOutputFormat() {
        return outputFormat;
    }

    /**
     * Sets the value of the outputFormat property.
     *
     * @param aOutputFormat the new value of the outputFormat property
     */
    public void setOutputFormat(String aOutputFormat) {
        outputFormat = aOutputFormat;
    }

    /**
     * Access method for the maxLength property.
     *
     * @return the current value of the maxLength property
     */
    public int getMaxLength() {
        return maxLength;
    }

    /**
     * Sets the value of the maxLength property.
     *
     * @param aMaxLength the new value of the maxLength property
     */
    public void setMaxLength(int aMaxLength) {
        maxLength = aMaxLength;
    }

    /**
     * Determines if the inputMode property is true.
     *
     * @return <code>true</code> if the inputMode property is true
     */
    public synchronized boolean getInputMode() {
        return inputMode;
    }

    /**
     * Sets the value of the inputMode property.
     *
     * @param aInputMode the new value of the inputMode property
     */
    public synchronized void setInputMode(boolean aInputMode) {
        if (aInputMode != inputMode) {
            value = getValue();
            inputMode = aInputMode;
            setValue(value);
        }
    }

    /**
     * @param value (missing javadoc)
     */
    @Override
    public synchronized void setValue(Object value) {
        this.value = value;
    }

    /**
     * @return (missing javadoc)
     */
    @Override
    public synchronized Object getValue() {
        return value;
    }

    /**
     * Default implementation is to return <code>getValue().toString</code>
     *
     * @see no.g9.client.support.G9FieldValue#format()
     */
    @Override
    public synchronized String format() {
        String str = "";
        if (getValue() != null) {
            str = getValue().toString();
        }
        return str;
    }

    /**
     * Formats the specified object to the string representation of that object.
     * Default implementation is to invoke o.toString.
     *
     * @param o the object to format
     * @return the string representation of the specified object
     */
    public synchronized String format(Object o) {
        return o != null ? o.toString() : "";
    }

    /**
     * Default implementation is to return the input string.
     *
     * @see no.g9.client.support.G9FieldValue#parse(java.lang.String)
     */
    @Override
    public synchronized Object parse(String str) throws ParseException {
        return str;
    }

    /**
     * Returns the output text representation of the value object when display
     * rules are applied. Default implementation is to return
     * getValue().toString().
     *
     * @return the output text representation of the value object.
     */
    public synchronized String getOutputText() {
        return getValue() != null ? format() : null;
    }

    /**
     * Internal use! Transform an object to the text version and back. This
     * ensures that when comparing to objects they are equally formatted.
     *
     * @param o the object to transform
     * @return the transformed object
     */
    public synchronized Object transform(Object o) {
        Object retVal;
        try {
            retVal = o != null ? parse(o.toString()) : null;
        } catch (ParseException e) {
            retVal = null;
        }
        return retVal;
    }

    /* (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        return super.toString() + ", Name: " + getName();
    }



}
