/*
 * Copyright 2013-2018 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.support;

import java.io.File;
import java.net.URL;

import no.esito.util.BeanID;
import no.esito.util.G9PropertyName;

/**
 * The launcher interface contains the methods for opening a file in the
 * associated application or opening an URL in the system default browser.
 * 
 */
@BeanID("fileLauncher")
@G9PropertyName("FileLauncher")
public interface Launcher {
    
    /**
     * Opens a file in the system's associated application. 
     * @param file the file to be opened.
     */
    public void open(File file);
    
    /**
     * Opens an URL in the system default browser.
     * @param url the URL to browse.
     */
    public void open(URL url);

}
