/*
 * Copyright 2013-2018 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.support;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import no.g9.domain.DomainUtil;

/**
 * Various helper methods used to manipulate object selections.
 *
 * @deprecated this class is now obsolete and is likely to be removed in future
 *             releases.
 */
@Deprecated
@SuppressWarnings("rawtypes")
public class ObjectSelectionTool {

    /**
     * Reuturns the role object associated with the specified role name.
     *
     * @param roleName the name of the role object
     * @param roleObjects the map containing all role objects
     * @return a role object with the specified role name.
     * @deprecated use {@link G9DialogController#getRoleObjects()}.
     */
    @Deprecated
    public static RoleObject getRoleObject(String roleName, Map roleObjects) {
        Iterator valueIterator = roleObjects.values().iterator();
        while (valueIterator.hasNext()) {
            Iterator roleObjectsIterator = ((Set) valueIterator.next())
                    .iterator();
            while (roleObjectsIterator.hasNext()) {
                RoleObject ro = (RoleObject) roleObjectsIterator.next();
                if (ro.getRoleName().equals(roleName)) {
                    return ro;
                }
            }
        }
        return null;
    }

    /**
     * Returns a collection of role objects representing the specified object
     *
     * @param o the (domain) object
     * @param roleObjects the map of role objects
     * @return a collection of role objects
     * @deprecated use {@link G9DialogController#getRoleObjects(Object)}.
     */
    @Deprecated
    public static Collection getRoleObjects(Object o, Map roleObjects) {
        return (Collection) roleObjects.get(DomainUtil.getDomainClass(o));
    }


    /**
     * Returns a list of role objects wich represents the path from the root
     * node to the specified target role object.
     *
     * @param dialogController the dialog controller which controlls the dialog
     *            window displaying the object selection.
     * @param roleObjects a Map of role objects
     * @param targetRoleName the name of the target role object.
     * @return a list representing the path to the target role object.
     * @deprecated use {@link AbstractNode#getPathToNode()}
     */
    @Deprecated
    public static List getPathToTarget(
            ObjectSelectionNode dialogController, Map roleObjects,
            String targetRoleName) {
        ObjectSelectionNode rootNode = dialogController.getRootNode();
        Set rootRoleObjects = (Set) roleObjects.get(rootNode
                .getRepresentingClass());
        List pathToTarget = null;
        Iterator rootRoleIterator = rootRoleObjects.iterator();
        while (rootRoleIterator.hasNext() && pathToTarget == null) {
            RoleObject currentRootRoleObject = (RoleObject) rootRoleIterator
                    .next();
            pathToTarget = currentRootRoleObject
                    .getPathToRole(targetRoleName);
        }

        return pathToTarget;

    }

}
