/*
 * Decompiled with CFR 0.152.
 */
package no.g9.client.component;

import java.awt.AWTEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import no.g9.client.component.G9RadioButton;
import no.g9.client.event.G9ValueChangedEvent;
import no.g9.client.event.G9ValueChangedListener;
import no.g9.client.event.G9ValueState;

public class G9ButtonGroup
extends ButtonGroup
implements FocusListener,
G9ValueState,
ActionListener {
    private Object oldVal;
    private Object initialVal;
    private G9RadioButton clearButtonValue = new G9RadioButton();
    protected EventListenerList vcListeners = new EventListenerList();
    protected EventListenerList listenerList = new EventListenerList();
    private boolean isInFocus = false;
    private JComponent componentGroup = new ComponentGroup(this);

    public G9ButtonGroup() {
        super.add(this.clearButtonValue);
    }

    public JComponent asComponent() {
        return this.componentGroup;
    }

    @Override
    public void add(AbstractButton b) {
        super.add(b);
        if (b instanceof G9RadioButton) {
            ((G9RadioButton)b).setGroup(this);
        }
        b.addFocusListener(this);
        b.addActionListener(this);
        this.updateSelection();
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (this.isInFocus) {
            return;
        }
        this.isInFocus = true;
        this.oldVal = this.getSelection();
        this.fireFocusEvent(e);
    }

    public void clear() {
        this.clearButtonValue.setSelected(true);
        this.initialVal = this.getSelection();
        this.oldVal = this.getSelection();
    }

    @Override
    public void focusLost(final FocusEvent e) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Iterator it = G9ButtonGroup.this.buttons.iterator();
                boolean otherFocus = false;
                while (!otherFocus && it.hasNext()) {
                    AbstractButton b = (AbstractButton)it.next();
                    otherFocus = b.isFocusOwner();
                }
                if (!otherFocus) {
                    G9ButtonGroup.this.isInFocus = false;
                    G9ButtonGroup.this.fireFocusEvent(e);
                    if (G9ButtonGroup.this.oldVal != null && !G9ButtonGroup.this.oldVal.equals(G9ButtonGroup.this.getSelection()) || G9ButtonGroup.this.oldVal == null && G9ButtonGroup.this.getSelection() != null) {
                        G9ButtonGroup.this.fireG9ValueChangedEvent(2000, G9ButtonGroup.this.oldVal, G9ButtonGroup.this.getSelection());
                    }
                }
            }
        });
    }

    @Override
    public void addValueChangedListener(G9ValueChangedListener listener) {
        this.vcListeners.add(G9ValueChangedListener.class, listener);
    }

    public void addActionListener(ActionListener listener) {
        this.listenerList.add(ActionListener.class, listener);
    }

    public void addFocusListener(FocusListener listener) {
        this.listenerList.add(FocusListener.class, listener);
    }

    public void fireActionEvent(ActionEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        ActionEvent event = new ActionEvent(this, e.getID(), e.getActionCommand());
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ActionListener.class) continue;
            ((ActionListener)listeners[i + 1]).actionPerformed(event);
        }
    }

    public void fireFocusEvent(FocusEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        block4: for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != FocusListener.class) continue;
            switch (e.getID()) {
                case 1004: {
                    ((FocusListener)listeners[i + 1]).focusGained(e);
                    continue block4;
                }
                case 1005: {
                    ((FocusListener)listeners[i + 1]).focusLost(e);
                    continue block4;
                }
            }
        }
    }

    protected void fireG9ValueChangedEvent(int id, Object oldValue, Object newValue) {
        Object[] listeners = this.vcListeners.getListenerList();
        AWTEvent e = null;
        block3: for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (e == null) {
                e = new G9ValueChangedEvent(this, id, oldValue, newValue);
            }
            if (listeners[i] != G9ValueChangedListener.class) continue;
            switch (e.getID()) {
                case 2000: {
                    ((G9ValueChangedListener)listeners[i + 1]).valueChanged((G9ValueChangedEvent)e);
                    continue block3;
                }
            }
        }
    }

    @Override
    public void resetState() {
        this.initialVal = this.oldVal = this.getSelection();
    }

    @Override
    public boolean isChanged() {
        ButtonModel cur = this.getSelection();
        if (cur == null) {
            return this.initialVal != null;
        }
        return !cur.equals(this.initialVal);
    }

    public boolean isClear() {
        return this.getSelection() == this.clearButtonValue.getModel() || this.getSelection() == null;
    }

    public void updateSelection() {
        this.initialVal = this.getSelection();
    }

    @Override
    public void display(Object o) {
        ButtonModel m = (ButtonModel)o;
        this.setSelected(m, m.isSelected());
    }

    @Override
    public Object getInitialValue() {
        return this.initialVal;
    }

    @Override
    public void setInitialValue(Object value) {
        this.oldVal = this.initialVal = value;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.fireActionEvent(e);
    }

    public static class ComponentGroup
    extends JComponent
    implements G9ValueState {
        private G9ButtonGroup group;

        ComponentGroup(G9ButtonGroup group) {
            this.group = group;
        }

        @Override
        public void addValueChangedListener(G9ValueChangedListener listener) {
            this.group.addValueChangedListener(listener);
        }

        @Override
        public void resetState() {
            this.group.resetState();
        }

        @Override
        public boolean isChanged() {
            return this.group.isChanged();
        }

        @Override
        public void display(Object o) {
            this.group.display(o);
        }

        @Override
        public Object getInitialValue() {
            return this.group.getInitialValue();
        }

        @Override
        public void setInitialValue(Object value) {
            this.group.setInitialValue(value);
        }

        public G9ButtonGroup getGroup() {
            return this.group;
        }
    }
}

