/*
 * Decompiled with CFR 0.152.
 */
package no.g9.client.component;

import java.awt.AWTEvent;
import java.awt.Container;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.RootPaneContainer;
import javax.swing.event.EventListenerList;
import no.g9.client.event.G9ValueChangedEvent;
import no.g9.client.event.G9ValueChangedListener;
import no.g9.client.event.G9ValueState;
import no.g9.client.support.DialogBlocker;

public class G9CheckBox
extends JCheckBox
implements G9ValueState {
    private boolean oldVal;
    private boolean initialVal;
    protected EventListenerList vcListeners = new EventListenerList();

    public G9CheckBox() {
        this(null, null, false);
    }

    public G9CheckBox(String text) {
        this(text, null, false);
    }

    public G9CheckBox(String text, boolean selected) {
        this(text, null, selected);
    }

    public G9CheckBox(Action a) {
        this();
        this.setAction(a);
    }

    public G9CheckBox(Icon icon) {
        this(null, icon, false);
    }

    public G9CheckBox(Icon icon, boolean selected) {
        this(null, icon, selected);
    }

    public G9CheckBox(String text, Icon icon) {
        this(text, icon, false);
    }

    public G9CheckBox(String text, Icon icon, boolean selected) {
        super(text, icon, selected);
        this.initialVal = selected;
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                G9CheckBox.this.oldVal = G9CheckBox.this.isSelected();
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (G9CheckBox.this.oldVal != G9CheckBox.this.isSelected()) {
                    G9CheckBox.this.fireG9ValueChangedEvent(2000, new Boolean(G9CheckBox.this.oldVal), new Boolean(G9CheckBox.this.isSelected()));
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                boolean wantEvent;
                Container parent;
                for (parent = G9CheckBox.this.getParent(); parent != null && !(parent instanceof RootPaneContainer); parent = parent.getParent()) {
                }
                boolean bl = wantEvent = DialogBlocker.isBlocked(parent) && G9CheckBox.this.getModel().isPressed() && G9CheckBox.this.contains(e.getPoint());
                if (wantEvent) {
                    G9CheckBox.this.doClick();
                }
            }
        });
        this.setBorder(BorderFactory.createEmptyBorder());
    }

    @Override
    public void resetState() {
        this.initialVal = this.oldVal = this.isSelected();
    }

    @Override
    public void addValueChangedListener(G9ValueChangedListener listener) {
        this.vcListeners.add(G9ValueChangedListener.class, listener);
    }

    protected void fireG9ValueChangedEvent(int id, Object oldValue, Object newValue) {
        Object[] listeners = this.vcListeners.getListenerList();
        AWTEvent e = null;
        block3: for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (e == null) {
                e = new G9ValueChangedEvent(this, id, oldValue, newValue);
            }
            if (listeners[i] != G9ValueChangedListener.class) continue;
            switch (e.getID()) {
                case 2000: {
                    ((G9ValueChangedListener)listeners[i + 1]).valueChanged((G9ValueChangedEvent)e);
                    continue block3;
                }
            }
        }
    }

    @Override
    public boolean isChanged() {
        return this.initialVal != this.isSelected();
    }

    @Override
    public void setSelected(boolean b) {
        this.initialVal = b;
        super.setSelected(b);
    }

    @Override
    public void display(Object o) {
        super.setSelected((Boolean)o);
    }

    @Override
    public Object getInitialValue() {
        return new Boolean(this.initialVal);
    }

    @Override
    public void setInitialValue(Object value) {
        this.initialVal = value != null ? (Boolean)value : false;
        this.oldVal = this.initialVal;
    }
}

