/*
 * Decompiled with CFR 0.152.
 */
package no.g9.client.component;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.beans.PropertyVetoException;
import java.util.Stack;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.DefaultDesktopManager;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import no.g9.client.component.G9ToolBar;
import no.g9.client.component.menu.G9MenuBar;
import no.g9.client.support.DialogBlocker;
import no.g9.client.support.G9DialogFrame;

public class G9DesktopPane
extends JDesktopPane {
    private Stack<JInternalFrame> frameStack = new Stack();
    private static final int FRAME_OFFSET = 20;
    public static final String cascade = "Cascade";
    public static final String tile = "Tile";
    protected G9MenuBar desktopMenuBar = null;
    protected G9ToolBar desktopToolBar = null;
    private G9DesktopManager desktopManager;
    private Action g9NextAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean visible = false;
            for (int i = 1; i < G9DesktopPane.this.getComponentCount() && !visible; ++i) {
                visible = visible || G9DesktopPane.this.getComponent(i).isVisible();
            }
            if (!visible) {
                return;
            }
            Component cur = G9DesktopPane.this.getComponent(0);
            G9DesktopPane.this.remove(cur);
            G9DesktopPane.this.add(cur);
            for (int i = 0; i < G9DesktopPane.this.getComponentCount(); ++i) {
                Component next = G9DesktopPane.this.getComponent(i);
                if (!next.isVisible()) continue;
                JInternalFrame frame = null;
                if (next instanceof JInternalFrame) {
                    frame = (JInternalFrame)next;
                } else if (next instanceof JInternalFrame.JDesktopIcon) {
                    frame = ((JInternalFrame.JDesktopIcon)next).getInternalFrame();
                }
                if (frame == null) continue;
                try {
                    frame.setSelected(true);
                    if (!frame.isIcon()) break;
                    frame.getDesktopIcon().requestFocus();
                    break;
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }
    };
    private Action g9PreviousAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            int i;
            boolean visible = false;
            for (i = 0; i < G9DesktopPane.this.getComponentCount() && !visible; ++i) {
                visible = visible || G9DesktopPane.this.getComponent(i).isVisible();
            }
            if (!visible) {
                return;
            }
            for (i = G9DesktopPane.this.getComponentCount() - 1; i >= 0; --i) {
                Component previous = G9DesktopPane.this.getComponent(i);
                if (!previous.isVisible()) continue;
                JInternalFrame frame = null;
                if (previous instanceof JInternalFrame) {
                    frame = (JInternalFrame)previous;
                } else if (previous instanceof JInternalFrame.JDesktopIcon) {
                    frame = ((JInternalFrame.JDesktopIcon)previous).getInternalFrame();
                }
                if (frame == null) continue;
                try {
                    Component[] foo = G9DesktopPane.this.getComponents();
                    frame.setSelected(true);
                    if (!frame.isIcon()) break;
                    for (int j = 0; j < i; ++j) {
                        Component tmp = foo[j];
                        G9DesktopPane.this.remove(tmp);
                        G9DesktopPane.this.add(tmp);
                    }
                    frame.getDesktopIcon().requestFocus();
                    break;
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }
    };

    public G9DesktopPane() {
        this.desktopManager = new G9DesktopManager(this);
        this.setDesktopManager(this.desktopManager);
        this.setDragMode(1);
        ActionMap map = this.getActionMap();
        CascadeAction cascadeAction = new CascadeAction(cascade, null, null, null);
        cascadeAction.setEnabled(false);
        map.put(cascadeAction.getValue("Name"), cascadeAction);
        TileAction tileAction = new TileAction(tile, null, null, null);
        tileAction.setEnabled(false);
        map.put(tileAction.getValue("Name"), tileAction);
        String closeActionKey = "close";
        InputMap inputMapWhenAncestor = this.getInputMap(1);
        KeyStroke controlAndW = KeyStroke.getKeyStroke(87, 128);
        inputMapWhenAncestor.put(controlAndW, closeActionKey);
        String nextKey = "g9NavigateNext";
        KeyStroke ctrlF6 = KeyStroke.getKeyStroke(117, 128);
        this.getActionMap().put(nextKey, this.g9NextAction);
        inputMapWhenAncestor.put(ctrlF6, nextKey);
        String previousKey = "g9NavigatePrevious";
        int ctrlShiftMask = 192;
        KeyStroke ctrlShiftF6 = KeyStroke.getKeyStroke(117, ctrlShiftMask);
        this.getActionMap().put(previousKey, this.g9PreviousAction);
        inputMapWhenAncestor.put(ctrlShiftF6, previousKey);
    }

    public void setMenuBar(G9MenuBar menuBar) {
        this.desktopMenuBar = menuBar;
    }

    public G9MenuBar getMenuBar() {
        return this.desktopMenuBar;
    }

    public void setToolBar(G9ToolBar toolBar) {
        this.desktopToolBar = toolBar;
    }

    public G9ToolBar getToolBar() {
        return this.desktopToolBar;
    }

    public void frameShown(JInternalFrame shownFrame) {
        this.frameStack.remove(shownFrame);
        this.frameStack.push(shownFrame);
        this.desktopManager.activateFrame(shownFrame);
        this.desktopManager.updateCascadeAndTileAction();
    }

    public void frameHidden(JInternalFrame hiddenFrame) {
        this.frameStack.remove(hiddenFrame);
        this.desktopManager.updateCascadeAndTileAction();
        this.desktopManager.deactivateFrame(hiddenFrame);
        this.selectNext(hiddenFrame);
    }

    public void frameAdded(JInternalFrame addedFrame) {
        this.frameStack.remove(addedFrame);
        this.frameStack.push(addedFrame);
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        this.checkDesktopSize();
    }

    @Override
    public void remove(Component c) {
        super.remove(c);
        this.checkDesktopSize();
    }

    public void setAllSize(Dimension d) {
        this.setMinimumSize(d);
        this.setMaximumSize(d);
        this.setPreferredSize(d);
    }

    public void setAllSize(int width, int height) {
        this.setAllSize(new Dimension(width, height));
    }

    public void cascade() {
        int xPos = 0;
        int yPos = 0;
        JInternalFrame[] allFrames = this.getAllFrames();
        int frameHeight = this.getBounds().height - (allFrames.length - 1) * 20;
        int frameWidth = this.getBounds().width - (allFrames.length - 1) * 20;
        for (int i = allFrames.length - 1; i >= 0; --i) {
            if (allFrames[i].isIcon()) {
                this.getDesktopManager().deiconifyFrame(allFrames[i]);
            }
            allFrames[i].setBounds(xPos, yPos, frameWidth, frameHeight);
            xPos += 20;
            yPos += 20;
        }
    }

    public void tileHorizontal() {
        JInternalFrame[] allFrames = this.getAllFrames();
        int frameHeight = this.getBounds().height / allFrames.length;
        int frameWidth = this.getBounds().width;
        int xPos = 0;
        int yPos = 0;
        for (int i = 0; i < allFrames.length; ++i) {
            allFrames[i].setBounds(xPos, yPos, frameWidth, frameHeight);
            yPos += frameHeight;
        }
    }

    public void tileVertical() {
        JInternalFrame[] allFrames = this.getAllFrames();
        int frameHeight = this.getBounds().height;
        int frameWidth = this.getBounds().width / allFrames.length;
        int xPos = 0;
        int yPos = 0;
        for (int i = 0; i < allFrames.length; ++i) {
            allFrames[i].setBounds(xPos, yPos, frameWidth, frameHeight);
            xPos += frameWidth;
        }
    }

    public void tile() {
        JInternalFrame[] allFrames = this.getAllFrames();
        int rows = 1;
        int cols = 1;
        while (rows * cols < allFrames.length) {
            if (cols <= rows) {
                ++cols;
                continue;
            }
            ++rows;
        }
        int[] rowsInCol = new int[cols];
        int firstColNumber = allFrames.length % rows;
        if (firstColNumber == 0) {
            firstColNumber = rows;
        }
        rowsInCol[0] = firstColNumber;
        for (int i = 1; i < rowsInCol.length; ++i) {
            rowsInCol[i] = rows;
        }
        int frameCount = allFrames.length - 1;
        int frameWidth = this.getBounds().width / cols;
        int frameHeigth = 0;
        int xPos = 0;
        int yPos = 0;
        for (int colNum = 0; colNum < cols; ++colNum) {
            xPos = frameWidth * colNum;
            for (int row = 0; row < rowsInCol[colNum]; ++row) {
                frameHeigth = this.getBounds().height / rowsInCol[colNum];
                yPos = row * frameHeigth;
                if (allFrames[frameCount].isIcon()) {
                    this.getDesktopManager().deiconifyFrame(allFrames[frameCount]);
                }
                allFrames[frameCount--].setBounds(xPos, yPos, frameWidth, frameHeigth);
            }
        }
    }

    private void checkDesktopSize() {
        if (this.getParent() != null && this.isVisible()) {
            this.desktopManager.resizeDesktop();
        }
    }

    public synchronized void toggleEditMenu(G9DialogFrame dialog) {
        boolean enable = !DialogBlocker.isBlocked(dialog);
        G9MenuBar menuBar = this.getMenuBar();
        if (menuBar == null) {
            return;
        }
        menuBar.toggleEditMenu(enable);
    }

    private void selectNext(JInternalFrame currentFrame) {
        JInternalFrame nextFrame = null;
        for (int i = 0; i < this.getComponentCount(); ++i) {
            if (!(this.getComponent(i) instanceof JInternalFrame) || (nextFrame = (JInternalFrame)this.getComponent(i)) == currentFrame || !nextFrame.isVisible()) continue;
            try {
                nextFrame.setSelected(true);
                break;
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    public class TileAction
    extends AbstractAction {
        public static final String defaultDesc = "Tiles all dialog windows";
        public final Integer defaultMnemonic;

        public TileAction(String text, ImageIcon icon, String desc, Integer mnemonic) {
            super(text, icon);
            this.defaultMnemonic = new Integer(86);
            if (desc == null) {
                desc = defaultDesc;
            }
            if (mnemonic == null) {
                mnemonic = this.defaultMnemonic;
            }
            this.putValue("ShortDescription", desc);
            this.putValue("MnemonicKey", mnemonic);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            G9DesktopPane.this.tile();
        }
    }

    public class CascadeAction
    extends AbstractAction {
        public static final String defaultDesc = "Cascades all dialog windows";
        public final Integer defaultMnemonic;

        public CascadeAction(String text, ImageIcon icon, String desc, Integer mnemonic) {
            super(text, icon);
            this.defaultMnemonic = new Integer(67);
            if (desc == null) {
                desc = defaultDesc;
            }
            if (mnemonic == null) {
                mnemonic = this.defaultMnemonic;
            }
            this.putValue("ShortDescription", desc);
            this.putValue("MnemonicKey", mnemonic);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            G9DesktopPane.this.cascade();
        }
    }

    private class G9DesktopManager
    extends DefaultDesktopManager {
        private G9DesktopPane desktop;

        @Override
        public void activateFrame(JInternalFrame f) {
            super.activateFrame(f);
            if (f instanceof G9DialogFrame) {
                this.updateDesktopMenuAndToolBar((G9DialogFrame)f);
            }
            this.resizeDesktop();
            this.updateCascadeAndTileAction();
        }

        @Override
        public void deactivateFrame(final JInternalFrame f) {
            super.deactivateFrame(f);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (G9DesktopPane.this.getSelectedFrame() == null) {
                        G9DesktopManager.this.updateDesktopMenuAndToolBar(null);
                        if (f instanceof G9DialogFrame) {
                            G9DialogFrame gdf = (G9DialogFrame)f;
                            JFrame appWindow = gdf.getController().getApplication().getApplicationWindow();
                            appWindow.getContentPane().requestFocusInWindow();
                        }
                    }
                }
            });
        }

        @Override
        public void closeFrame(JInternalFrame f) {
            super.closeFrame(f);
            G9DesktopPane.this.frameStack.remove(f);
            this.updateCascadeAndTileAction();
            G9DesktopPane.this.selectNext(f);
        }

        private void updateDesktopMenuAndToolBar(G9DialogFrame gdm) {
            if (G9DesktopPane.this.desktopMenuBar != null) {
                G9DesktopPane.this.desktopMenuBar.mergeMenues(gdm);
            }
            if (G9DesktopPane.this.desktopToolBar != null) {
                G9DesktopPane.this.desktopToolBar.mergeToolBars(gdm);
            }
            G9DesktopPane.this.toggleEditMenu(gdm);
        }

        protected void updateCascadeAndTileAction() {
            G9DesktopPane.this.getActionMap().get(G9DesktopPane.cascade).setEnabled(G9DesktopPane.this.getAllFrames().length != 0);
            G9DesktopPane.this.getActionMap().get(G9DesktopPane.tile).setEnabled(G9DesktopPane.this.getAllFrames().length != 0);
        }

        public G9DesktopManager(G9DesktopPane desktop) {
            this.desktop = desktop;
        }

        @Override
        public void endResizingFrame(JComponent f) {
            super.endResizingFrame(f);
            this.resizeDesktop();
        }

        @Override
        public void endDraggingFrame(JComponent f) {
            super.endDraggingFrame(f);
            this.resizeDesktop();
        }

        private Insets getScrollPaneInsets() {
            JScrollPane scrollPane = this.getScrollPane();
            if (scrollPane == null) {
                return new Insets(0, 0, 0, 0);
            }
            return this.getScrollPane().getBorder().getBorderInsets(scrollPane);
        }

        private JScrollPane getScrollPane() {
            JViewport viewPort;
            if (this.desktop.getParent() instanceof JViewport && (viewPort = (JViewport)this.desktop.getParent()).getParent() instanceof JScrollPane) {
                return (JScrollPane)viewPort.getParent();
            }
            return null;
        }

        protected void resizeDesktop() {
            int x = 0;
            int y = 0;
            JScrollPane scrollPane = this.getScrollPane();
            Insets scrollInsets = this.getScrollPaneInsets();
            if (scrollPane != null) {
                JInternalFrame[] allFrames = this.desktop.getAllFrames();
                for (int i = 0; i < allFrames.length; ++i) {
                    if (allFrames[i].getX() + allFrames[i].getWidth() > x) {
                        x = allFrames[i].getX() + allFrames[i].getWidth();
                    }
                    if (allFrames[i].getY() + allFrames[i].getHeight() <= y) continue;
                    y = allFrames[i].getY() + allFrames[i].getHeight();
                }
                Dimension d = scrollPane.getVisibleRect().getSize();
                if (scrollPane.getBorder() != null) {
                    d.setSize(d.getWidth() - (double)scrollInsets.left - (double)scrollInsets.right, d.getHeight() - (double)scrollInsets.top - (double)scrollInsets.bottom);
                }
                if ((double)x <= d.getWidth()) {
                    x = (int)d.getWidth() - 20;
                }
                if ((double)y <= d.getHeight()) {
                    y = (int)d.getHeight() - 20;
                }
                this.desktop.setAllSize(x, y);
                scrollPane.invalidate();
                scrollPane.validate();
            }
        }
    }
}

