/*
 * Decompiled with CFR 0.152.
 */
package no.g9.client.component;

import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import no.g9.client.component.G9Button;
import no.g9.client.support.G9DialogFrame;

public class G9ToolBar
extends JToolBar {
    private static boolean useOldMerge;
    private static final long serialVersionUID = 1L;
    private G9DialogFrame parentFrame;
    private List<Component> myComponents;
    private boolean removeConsecutiveSeparators = false;
    private boolean isLastAddedSpacer = false;
    private boolean isModal;

    public G9ToolBar(G9DialogFrame parentFrame) {
        if (parentFrame == null) {
            throw new IllegalArgumentException("Parent frame can not be null");
        }
        this.parentFrame = parentFrame;
    }

    public G9ToolBar(G9DialogFrame parentFrame, List<Component> myComponents) {
        if (parentFrame == null) {
            throw new IllegalArgumentException("Parent frame can not be null");
        }
        this.parentFrame = parentFrame;
        this.myComponents = myComponents;
    }

    public synchronized Component[] getG9Components() {
        if (this.myComponents == null) {
            return new Component[0];
        }
        Component[] retVal = new Component[this.myComponents.size()];
        return this.myComponents.toArray(retVal);
    }

    public synchronized void setRemoveConsecutiveSeparators(boolean removeConsecutiveSeparators) {
        this.removeConsecutiveSeparators = removeConsecutiveSeparators;
    }

    public synchronized boolean isRemoveConsecutiveSeparators() {
        return this.removeConsecutiveSeparators;
    }

    public synchronized void setEnabledWholeToolBar(boolean enable) {
        if (this.parentFrame == null || this.parentFrame.getG9ToolBar() == null) {
            return;
        }
        Component[] mainElements = this.getG9Components();
        for (int i = 0; i < mainElements.length; ++i) {
            mainElements[i].setEnabled(enable && this.parentFrame.isEnabledComponent(mainElements[i]));
        }
    }

    public synchronized void setModal(boolean isModal) {
        this.isModal = isModal;
        if (this.parentFrame == null || this.parentFrame.getG9ToolBar() == null) {
            return;
        }
        Component[] mainElements = this.getG9Components();
        for (int i = 0; i < mainElements.length; ++i) {
            mainElements[i].setEnabled(!isModal && this.parentFrame.isEnabledComponent(mainElements[i]));
        }
    }

    public synchronized boolean isModal() {
        return this.isModal;
    }

    public void mergeToolBars(G9DialogFrame activeDialog) {
        this.merge(activeDialog);
        this.validate();
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void merge(G9DialogFrame activeDialog) {
        Object object = this.getTreeLock();
        synchronized (object) {
            Component[] activeElements;
            Component[] bar;
            this.removeAll();
            if (!G9ToolBar.isUseOldMerge() && (bar = this.getMergedComponents(activeDialog)) != null) {
                this.display(bar);
                return;
            }
            Component[] mainElements = this.getG9Components();
            Component[] componentArray = activeElements = activeDialog != null && activeDialog.getG9ToolBar() != null ? activeDialog.getG9ToolBar().getG9Components() : new Component[]{};
            if (mainElements.length == 0) {
                this.display(activeElements);
                return;
            }
            if (activeElements.length == 0) {
                this.display(mainElements);
                return;
            }
            for (int i = 0; i < mainElements.length; ++i) {
                String appElemName = this.getName(mainElements[i], this.parentFrame);
                if (appElemName != null) {
                    for (int j = 0; j < activeElements.length; ++j) {
                        String diaElemName = this.getName(activeElements[j], activeDialog);
                        if (!appElemName.equals(diaElemName)) continue;
                        mainElements[i] = activeElements[j];
                    }
                }
                this.display(mainElements[i]);
            }
            this.display(activeElements);
        }
    }

    private Component[] getMergedComponents(G9DialogFrame frame) {
        Component[] tmp = this.getG9Components();
        ArrayList<Component> merged = new ArrayList<Component>();
        for (int i = 0; i < tmp.length; ++i) {
            merged.add(tmp[i]);
        }
        Component[] dialogElems = new Component[]{};
        if (frame != null && frame.getG9ToolBar() != null) {
            dialogElems = frame.getG9ToolBar().getG9Components();
        }
        int mergePos = merged.size();
        for (int i = 0; i < dialogElems.length; ++i) {
            String elemName = this.getName(dialogElems[i], frame);
            int matchPos = this.elemPos(elemName, merged);
            if (matchPos > -1) {
                mergePos = matchPos;
                merged.remove(mergePos);
            }
            merged.add(mergePos, dialogElems[i]);
            ++mergePos;
        }
        Component[] mergedComponents = new Component[merged.size()];
        for (int i = 0; i < merged.size(); ++i) {
            mergedComponents[i] = (Component)merged.get(i);
        }
        return mergedComponents;
    }

    private int elemPos(String name, List<Component> merged) {
        int pos = -1;
        for (int i = 0; i < merged.size() && pos == -1; ++i) {
            JComponent comp = (JComponent)merged.get(i);
            if (!name.equals(this.parentFrame.fromComponentToName(comp))) continue;
            pos = i;
        }
        return pos;
    }

    @Override
    public synchronized Component add(Component c) {
        if (this.myComponents == null) {
            this.myComponents = new Vector<Component>();
        }
        this.myComponents.add(c);
        if (c instanceof G9Button) {
            G9Button gb = (G9Button)c;
            gb.setInToolbar(true);
        }
        return this.display(c);
    }

    private Component display(Component c) {
        if (c instanceof JToolBar.Separator) {
            if (this.getOrientation() == 1) {
                ((JToolBar.Separator)c).setOrientation(0);
            } else {
                ((JToolBar.Separator)c).setOrientation(1);
            }
            if (!this.isLastAddedSpacer) {
                this.isLastAddedSpacer = this.removeConsecutiveSeparators;
                return super.add(c);
            }
            return c;
        }
        this.isLastAddedSpacer = false;
        return super.add(c);
    }

    private void display(Component[] components) {
        if (components == null) {
            return;
        }
        int maxComponentHeight = 0;
        for (int i = 0; i < components.length; ++i) {
            if (components[i] == null) continue;
            int cHeight = components[i].getPreferredSize().height;
            if (cHeight > maxComponentHeight) {
                maxComponentHeight = cHeight;
            }
            this.display(components[i]);
        }
        if (maxComponentHeight > 0) {
            Dimension preferredToolbarSize = this.getPreferredSize();
            preferredToolbarSize.setSize(preferredToolbarSize.width + 1, preferredToolbarSize.height);
            this.setPreferredSize(preferredToolbarSize);
        }
    }

    private String getName(Object elem, G9DialogFrame dialog) {
        if (elem instanceof JComponent) {
            return dialog.fromComponentToName((JComponent)elem);
        }
        return null;
    }

    public static boolean isUseOldMerge() {
        return useOldMerge;
    }

    public static void setUseOldMerge(boolean useOldMerge) {
        G9ToolBar.useOldMerge = useOldMerge;
    }
}

