/*
 * Decompiled with CFR 0.152.
 */
package no.g9.client.component;

import java.awt.AWTEvent;
import javax.swing.DefaultCellEditor;
import javax.swing.event.EventListenerList;
import no.g9.client.component.G9CheckBox;
import no.g9.client.component.G9ComboBox;
import no.g9.client.component.G9TextField;
import no.g9.client.event.G9ValueChangedEvent;
import no.g9.client.event.G9ValueChangedListener;
import no.g9.support.TypeTool;

public class GDefaultCellEditor
extends DefaultCellEditor {
    protected EventListenerList vcListeners = new EventListenerList();

    public GDefaultCellEditor(G9CheckBox checkBox) {
        super(checkBox);
    }

    public GDefaultCellEditor(G9ComboBox comboBox) {
        super(comboBox);
    }

    public GDefaultCellEditor(final G9TextField textField) {
        super(textField);
        this.delegate = new DefaultCellEditor.EditorDelegate(){

            @Override
            public Object getCellEditorValue() {
                return textField.getValue();
            }

            @Override
            public void setValue(Object value) {
                textField.setValue(value);
                super.setValue(value);
            }

            @Override
            public boolean stopCellEditing() {
                Object oldValue;
                Object currentValue = textField.getValue();
                if (TypeTool.differ((Object)currentValue, (Object)(oldValue = textField.getInitialValue()))) {
                    textField.resetState();
                    textField.fireG9ValueChangedEvent(2000, oldValue, currentValue);
                }
                return super.stopCellEditing();
            }
        };
        textField.addActionListener(this.delegate);
    }

    protected void fireG9ValueChangedEvent(int id, Object oldValue, Object newValue) {
        Object[] listeners = this.vcListeners.getListenerList();
        AWTEvent e = null;
        block3: for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (e == null) {
                e = new G9ValueChangedEvent(this, id, oldValue, newValue);
            }
            if (listeners[i] != G9ValueChangedListener.class) continue;
            switch (e.getID()) {
                case 2000: {
                    ((G9ValueChangedListener)listeners[i + 1]).valueChanged((G9ValueChangedEvent)e);
                    continue block3;
                }
            }
        }
    }
}

