/*
 * Decompiled with CFR 0.152.
 */
package no.g9.client.component.menu;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import no.g9.client.component.menu.G9MenuBar;
import no.g9.client.component.menu.G9MenuItem;
import no.g9.client.component.menu.G9WindowMenu;
import no.g9.client.support.G9DialogFrame;
import no.g9.client.support.G9Render;
import no.g9.message.Message;
import no.g9.message.MessageSystem;

public class G9Menu
extends JMenu {
    private static final long serialVersionUID = 1L;
    public static final int CUSTOM_MENU = 0;
    public static final int FILE_MENU = 1;
    public static final int EDIT_MENU = 2;
    public static final int VIEW_MENU = 3;
    public static final int WINDOW_MENU = 4;
    public static final int HELP_MENU = 5;
    private int menuType;
    private List<?> defaultItems = new Vector();
    private List<Component> myComponents;
    private G9Menu mergedFromMenu;
    private G9Menu mergedIntoMenu;
    private String defaultTitle;
    private boolean isModal = false;
    private boolean removeConsecutiveSeparators = true;

    public G9Menu(String title, int menuType, String name) {
        this(title, menuType);
        this.setName(name);
    }

    public G9Menu(String title, int menuType) {
        super(title);
        this.defaultTitle = title;
        this.menuType = menuType;
    }

    public G9Menu(String s, boolean b, int menuType) {
        this(s, menuType);
    }

    public G9Menu(Action a, int menuType) {
        this("", menuType);
        this.setAction(a);
    }

    public int getMenuType() {
        return this.menuType;
    }

    public JMenuItem addG9Item(String title) {
        return this.addG9Item(new G9MenuItem(title));
    }

    public JMenuItem addG9Item(String title, String name) {
        return this.addG9Item(new G9MenuItem(title, name));
    }

    public synchronized JMenuItem addG9Item(JMenuItem item) {
        if (this.myComponents == null) {
            this.myComponents = new ArrayList<Component>();
        }
        this.myComponents.add(item);
        return this.add(item);
    }

    public synchronized Component addG9Item(JSeparator separator) {
        if (this.myComponents == null) {
            this.myComponents = new ArrayList<Component>();
        }
        this.myComponents.add(separator);
        return this.add(separator);
    }

    public synchronized Component[] getG9Components() {
        if (this.myComponents == null) {
            return new Component[0];
        }
        Component[] retVal = new Component[this.myComponents.size()];
        for (int i = 0; i < retVal.length; ++i) {
            retVal[i] = this.myComponents.get(i);
        }
        return retVal;
    }

    public synchronized boolean mergeMenu(G9Menu menu) {
        if (this.mergedFromMenu == null && menu == null && !(this instanceof G9WindowMenu)) {
            return true;
        }
        if (menu != null && menu == this.mergedIntoMenu) {
            return false;
        }
        if (menu == null) {
            this.setText(this.defaultTitle);
        } else {
            menu.setMergedIntoMenu(this);
        }
        if (this.mergedFromMenu != null) {
            this.mergedFromMenu.setMergedIntoMenu(null);
        }
        this.mergedFromMenu = menu;
        this.createMenuComponents();
        this.toggleEnabledState(menu);
        return true;
    }

    public synchronized void setEnabledWholeMenu(boolean enable) {
        this.setEnableOwnMenuItems(enable);
    }

    public synchronized void setModal(boolean isModal) {
        if (this.isModal == isModal) {
            return;
        }
        this.isModal = isModal;
        this.setEnableOwnMenuItems(!isModal);
        boolean enable = (this instanceof G9WindowMenu || !isModal) && this.isEnabledInParentFrame(this) || this.mergedFromMenu != null && this.isEnabledInParentFrame(this.mergedFromMenu);
        this.setEnabled(enable);
    }

    private boolean isEnabledInParentFrame(G9Menu menu) {
        if (menu == null || menu.getParentFrame() == null) {
            return true;
        }
        return menu.getParentFrame().isEnabledComponent(menu);
    }

    public synchronized boolean isModal() {
        return this.isModal;
    }

    public synchronized void setRemoveConsecutiveSeparators(boolean remove) {
        if (this.removeConsecutiveSeparators != remove) {
            this.removeConsecutiveSeparators = remove;
            this.createMenuComponents();
        }
    }

    public synchronized boolean isRemoveConsecutiveSeparators() {
        return this.removeConsecutiveSeparators;
    }

    protected synchronized void createMenuComponents() {
        int i;
        this.removeAll();
        Iterator<?> it = this.defaultItems.iterator();
        while (it.hasNext()) {
            this.add((Component)it.next());
        }
        Component[] menuComponents = this.getG9Components();
        if (this.mergedFromMenu == null) {
            for (int i2 = 0; i2 < menuComponents.length; ++i2) {
                this.add(menuComponents[i2]);
            }
            return;
        }
        Component[] result = this.mergedFromMenu.getG9Components();
        for (i = 0; i < menuComponents.length; ++i) {
            int index = this.indexOf(result, menuComponents[i]);
            if (index > -1) {
                this.add(result[index]);
                result = this.remove(result, index);
                while (index < result.length && this.indexOf(menuComponents, result[index]) == -1) {
                    this.add(result[index]);
                    result = this.remove(result, index);
                }
                continue;
            }
            this.add(menuComponents[i]);
        }
        for (i = 0; i < result.length; ++i) {
            this.add(result[i]);
        }
    }

    @Override
    public Component add(Component c) {
        Component lastAdded;
        if (this.removeConsecutiveSeparators && this.getMenuComponentCount() > 0 && (lastAdded = this.getMenuComponent(this.getMenuComponentCount() - 1)) instanceof JSeparator && c instanceof JSeparator) {
            return null;
        }
        return super.add(c);
    }

    private Component[] remove(Component[] items, int index) {
        if (items == null) {
            return null;
        }
        int len = items.length - 1;
        Component[] result = new Component[len];
        if (index == 0) {
            System.arraycopy(items, 1, result, 0, len);
        } else if (index == len) {
            System.arraycopy(items, 0, result, 0, len);
        } else {
            System.arraycopy(items, 0, result, 0, index);
            System.arraycopy(items, index + 1, result, index, len - index);
        }
        return result;
    }

    private int indexOf(Component[] items, Component item) {
        if (items == null || item == null) {
            return -1;
        }
        String thisName = item.getName();
        if (thisName == null) {
            return -1;
        }
        for (int i = 0; i < items.length; ++i) {
            String anotherName = items[i].getName();
            if (!thisName.equals(anotherName)) continue;
            return i;
        }
        return -1;
    }

    private void toggleEnabledState(G9Menu menu) {
        G9DialogFrame parentFrame;
        G9DialogFrame g9DialogFrame = parentFrame = menu == null ? this.getParentFrame() : menu.getParentFrame();
        if (parentFrame != null) {
            G9Menu m = menu == null ? this : menu;
            this.setEnabled(parentFrame.isEnabledComponent(m));
        }
    }

    @Override
    public synchronized void setEnabled(boolean b) {
        super.setEnabled(b);
        if (this.mergedIntoMenu != null) {
            this.mergedIntoMenu.setEnabled(b);
        }
    }

    @Override
    public synchronized void setVisible(boolean b) {
        super.setVisible(b);
        if (this.mergedIntoMenu != null) {
            this.mergedIntoMenu.setVisible(b);
        }
    }

    private void setEnableOwnMenuItems(boolean enable) {
        Component[] appComponents = this.getG9Components();
        for (int i = 0; i < appComponents.length; ++i) {
            boolean enableComp = enable;
            this.setEnableMenuItem(appComponents[i], enableComp &= this.isEnabledMenuItem(appComponents[i]));
        }
    }

    private void setEnableMenuItem(Component comp, boolean enable) {
        Action action;
        if (comp instanceof AbstractButton && (action = ((AbstractButton)comp).getAction()) != null) {
            action.setEnabled(enable);
            return;
        }
        comp.setEnabled(enable);
    }

    private boolean isEnabledMenuItem(Component comp) {
        G9DialogFrame gdm = this.getParentFrame();
        if (gdm == null) {
            return true;
        }
        return gdm.isEnabledComponent(comp);
    }

    protected G9DialogFrame getParentFrame() {
        G9MenuBar parentMenuBar = this.getParentMenuBar(this);
        if (parentMenuBar == null) {
            return null;
        }
        return parentMenuBar.getParentFrame();
    }

    private G9MenuBar getParentMenuBar(Component comp) {
        if (comp == null) {
            return null;
        }
        if (comp.getParent() instanceof G9MenuBar) {
            return (G9MenuBar)comp.getParent();
        }
        return this.getParentMenuBar(comp.getParent());
    }

    protected synchronized void setDefaultItem(List<?> defaultItems) {
        this.defaultItems = defaultItems;
        this.createMenuComponents();
    }

    protected static G9MenuItem createMenuItem(Action action, String accelerator, String title) {
        G9MenuItem menuItem = new G9MenuItem(action);
        if (accelerator != null) {
            menuItem.setAccelerator(G9Render.render(accelerator));
        }
        Message msg = MessageSystem.getMessageFactory().getMessage(title, new Object[0]);
        menuItem.setText(msg.getMessageText());
        return menuItem;
    }

    private synchronized void setMergedIntoMenu(G9Menu mergedIntoMenu) {
        this.mergedIntoMenu = mergedIntoMenu;
    }
}

