/*
 * Decompiled with CFR 0.152.
 */
package no.g9.client.support;

import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import no.g9.client.support.AbstractNode;
import no.g9.client.support.Listblock;
import no.g9.client.support.ObjectSelectionNode;
import no.g9.client.support.RoleObject;
import no.g9.exception.G9ClientFrameworkException;
import no.g9.message.DispatcherContext;
import no.g9.message.Message;
import no.g9.message.MessageSystem;

public class ClearTool {
    Map roleObjects;

    public ClearTool(Map roleObjects) {
        this.roleObjects = roleObjects;
    }

    public void clear(final String roleName) {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                ClearTool.this.clear(ClearTool.this.getRoleObject(roleName));
            }
        };
        this.edt(task, "clear " + roleName);
    }

    public void clearRole(final String roleName) {
        class Task
        implements Runnable {
            Task() {
            }

            @Override
            public void run() {
                Set listBlocks;
                RoleObject role = ClearTool.this.getRoleObject(roleName);
                if (role == null) {
                    return;
                }
                List simpleBlocks = role.getSimpleBlocks();
                if (simpleBlocks != null) {
                    ClearTool.this.clearSimpleBlocks(simpleBlocks, false);
                }
                if ((listBlocks = role.getListBlocks().keySet()) != null) {
                    for (Listblock l : listBlocks) {
                        l.clearSelectedLines();
                    }
                }
                ClearTool.this.clearMembers(roleName);
            }
        }
        this.edt(new Task(), "clearRole " + roleName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void edt(Runnable task, String msgArg) {
        String msgID = null;
        Throwable throwable = null;
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(task);
                if (msgID == null) return;
            }
            catch (InterruptedException e) {
                msgID = "-1801";
                InterruptedException interruptedException = e;
                if (msgID == null) return;
                Object[] msgArgs = new Object[]{this.getClass(), msgArg, interruptedException};
                Message msg = MessageSystem.getMessageFactory().getMessage(msgID, msgArgs);
                MessageSystem.getMessageDispatcher((DispatcherContext)MessageSystem.NO_INTERACTION).dispatch(msg);
                throw new G9ClientFrameworkException((Throwable)interruptedException, msg);
            }
            catch (InvocationTargetException e2) {
                void var4_8;
                msgID = "-1802";
                if (e2.getCause() != null && e2.getCause() instanceof Exception) {
                    Exception exception = (Exception)e2.getCause();
                } else {
                    InvocationTargetException invocationTargetException = e2;
                }
                if (msgID == null) return;
                {
                    catch (Throwable throwable2) {
                        if (msgID == null) throw throwable2;
                        Object[] msgArgs = new Object[]{this.getClass(), msgArg, throwable};
                        Message msg = MessageSystem.getMessageFactory().getMessage(msgID, msgArgs);
                        MessageSystem.getMessageDispatcher((DispatcherContext)MessageSystem.NO_INTERACTION).dispatch(msg);
                        throw new G9ClientFrameworkException(throwable, msg);
                    }
                }
                Object[] msgArgs = new Object[]{this.getClass(), msgArg, var4_8};
                Message msg = MessageSystem.getMessageFactory().getMessage(msgID, msgArgs);
                MessageSystem.getMessageDispatcher((DispatcherContext)MessageSystem.NO_INTERACTION).dispatch(msg);
                throw new G9ClientFrameworkException((Throwable)var4_8, msg);
            }
            Object[] msgArgs = new Object[]{this.getClass(), msgArg, throwable};
            Message msg = MessageSystem.getMessageFactory().getMessage(msgID, msgArgs);
            MessageSystem.getMessageDispatcher((DispatcherContext)MessageSystem.NO_INTERACTION).dispatch(msg);
            throw new G9ClientFrameworkException(throwable, msg);
        }
        task.run();
    }

    public void clearMembers(final String roleName) {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                RoleObject parent = ClearTool.this.getRoleObject(roleName);
                if (parent == null) {
                    return;
                }
                Iterator associations = parent.getAssociationRoles();
                while (associations.hasNext()) {
                    ClearTool.this.clear((RoleObject)associations.next());
                }
            }
        };
        this.edt(task, "clearMembers");
    }

    public void clearKeepKeys(final String roleName) {
        class Task
        implements Runnable {
            Task() {
            }

            @Override
            public void run() {
                RoleObject ro = ClearTool.this.getRoleObject(roleName);
                List simpleBlocks = ro.getSimpleBlocks();
                ClearTool.this.clearSimpleBlocks(simpleBlocks, true);
                ClearTool.this.clearMembers(roleName);
            }
        }
        this.edt(new Task(), "clearKeepKeys, target: " + roleName);
    }

    private void clear(RoleObject currentRoot) {
        List simpleBlocks;
        if (currentRoot == null) {
            return;
        }
        Set listBlocks = currentRoot.getListBlocks().keySet();
        if (listBlocks != null) {
            this.clearListBlocks(listBlocks);
        }
        if ((simpleBlocks = currentRoot.getSimpleBlocks()) != null) {
            this.clearSimpleBlocks(simpleBlocks, false);
        }
        AbstractNode currentNode = currentRoot.getNode();
        currentNode.clearAllAssociation();
        currentNode.setState(0, false);
        Iterator associations = currentRoot.getAssociationRoles();
        if (associations == null) {
            return;
        }
        while (associations.hasNext()) {
            this.clear((RoleObject)associations.next());
        }
    }

    private void clearSimpleBlocks(List simpleBlocks, boolean keepKeys) {
        for (ObjectSelectionNode os : simpleBlocks) {
            if (keepKeys) {
                os.clearKeepKeys();
                continue;
            }
            os.clear();
        }
    }

    public void clearListBlocks(final Set listBlocks) {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                for (Listblock listBlock : listBlocks) {
                    listBlock.purgeAllLines();
                }
            }
        };
        this.edt(task, "clearListBlocks");
    }

    public RoleObject getRoleObject(String roleName) {
        Iterator valueIterator = this.roleObjects.values().iterator();
        while (valueIterator.hasNext()) {
            for (RoleObject ro : (Set)valueIterator.next()) {
                if (!ro.getRoleName().equals(roleName)) continue;
                return ro;
            }
        }
        return null;
    }
}

