/*
 * Decompiled with CFR 0.152.
 */
package no.g9.client.support;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import no.esito.log.Logger;
import no.g9.client.support.G9Document;
import no.g9.support.CustomDate;

public class DateDocument
extends G9Document {
    private DateFormat inputFormatter;
    private DateFormat outputFormatter;

    public DateDocument(int datatype, String inputFormat, String outputFormat, int maxLength) {
        super(datatype, inputFormat, outputFormat, maxLength);
        this.inputFormatter = new SimpleDateFormat(inputFormat);
        this.inputFormatter.setLenient(false);
        this.outputFormatter = new SimpleDateFormat(outputFormat);
    }

    @Override
    public void insertString(int offset, String str, AttributeSet attr) throws BadLocationException {
        if (str == null || str.length() == 0) {
            return;
        }
        if (!this.getInputMode()) {
            super.insertString(offset, str, attr);
            return;
        }
        String format = this.getInputFormat();
        if (str.length() + this.getLength() > format.length()) {
            return;
        }
        char aChar = str.charAt(0);
        char fChar = format.charAt(offset);
        if (Character.isDigit(aChar) == Character.isLetter(fChar) && (Character.isLetterOrDigit(fChar) || !Character.isLetterOrDigit(aChar))) {
            char bChar;
            super.insertString(offset, str, attr);
            if (!(++offset >= format.length() || Character.isLetterOrDigit(bChar = format.charAt(offset)) || this.getLength() != offset && this.getText(offset, 1).charAt(0) == bChar)) {
                super.insertString(offset, "" + bChar, attr);
            }
        }
    }

    private String dateToString(Date date) {
        String retVal = "";
        if (date != null) {
            retVal = this.getInputMode() ? this.inputFormatter.format(date) : this.outputFormatter.format(date);
        }
        return retVal;
    }

    private Date stringToDate(String str) {
        Date date = null;
        if (str != null) {
            try {
                date = this.getInputMode() ? this.inputFormatter.parse(str) : this.outputFormatter.parse(str);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return date;
    }

    @Override
    public synchronized Object transform(Object o) {
        return this.stringToDate(this.dateToString((Date)o));
    }

    @Override
    public synchronized void setValue(Object value) {
        String buf = null;
        super.setValue(value);
        if (value != null) {
            buf = this.getInputMode() ? this.inputFormatter.format((Date)value) : this.outputFormatter.format((Date)value);
        }
        try {
            this.replace(0, this.getLength(), buf, null);
        }
        catch (BadLocationException e) {
            Logger.getLogger(DateDocument.class).warn((Object)"Failed to set value.", (Throwable)e);
        }
    }

    @Override
    public synchronized Object getValue() {
        Object result;
        block6: {
            result = super.getValue();
            if (this.getInputMode()) {
                String strValue = null;
                try {
                    strValue = this.getText(0, this.getLength());
                }
                catch (BadLocationException e) {
                    Logger.getLogger(DateDocument.class).warn((Object)"Failed to get value.", (Throwable)e);
                }
                if (strValue != null && (strValue.length() != 0 || result != null)) {
                    try {
                        result = this.inputFormatter.parse(strValue);
                    }
                    catch (ParseException e) {
                        if (strValue.length() != 0) break block6;
                        result = null;
                    }
                }
            }
        }
        return result;
    }

    @Override
    public synchronized String format() {
        String str = "";
        Object value = this.getValue();
        if (value != null) {
            str = CustomDate.formatInternal((int)this.getDatatype(), (Object)value);
        }
        return str;
    }

    @Override
    public synchronized Object parse(String str) throws ParseException {
        Date value = null;
        if (str != null && str.length() != 0) {
            value = CustomDate.parseInternal((int)this.getDatatype(), (String)str);
        }
        return value;
    }

    @Override
    public synchronized String getOutputText() {
        return this.getValue() != null ? this.outputFormatter.format((Date)this.getValue()) : null;
    }
}

