/*
 * Decompiled with CFR 0.152.
 */
package no.g9.client.support;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Toolkit;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import no.esito.log.Logger;
import no.g9.client.support.DateMidnightDocument;
import no.g9.client.support.DateTimeDocument;
import no.g9.client.support.EnumeratorDocument;
import no.g9.client.support.G9Document;
import no.g9.client.support.LocalDateDocument;
import no.g9.client.support.LocalDateTimeDocument;
import no.g9.client.support.LocalTimeDocument;
import no.g9.client.support.NumberDocument;
import no.g9.client.support.TextDocument;
import no.g9.domain.G9Enums;
import no.g9.support.CustomDate;
import no.g9.support.FormatHelper;

public class FrameworkRepository {
    public static String ListblockLineDeletedColorName;
    private static Color ListblockLineDeletedColor;
    private static final Color ListblockLineNewColor;
    private static Color ListblockLineChangedColor;
    private static final Font ListblockFont;
    public static final int NO_RADIO_GROUP_TOP_INSET = -1;
    private static Logger log;

    private FrameworkRepository() {
    }

    public static void setListblockLineChangedColor(Color color) {
        ListblockLineChangedColor = color;
    }

    public static void setBorder(JComponent comp, int borderType, String title) {
        FrameworkRepository.setBorder(comp, borderType, title, -1);
    }

    public static void setBorder(JComponent comp, int borderType, String title, int radioGroupTopInset) {
        Border border = null;
        if (log.isTraceEnabled()) {
            log.trace((Object)("Setting border on " + comp.getName() + ". Border type: " + borderType + ", title: " + title + ", radioGroupTopInset: " + radioGroupTopInset));
        }
        if (borderType > 1 && !title.equals("")) {
            border = new G9TitleBorder(title, radioGroupTopInset);
            if (borderType == 3) {
                ((TitledBorder)border).setBorder(new BevelBorder(1));
            }
        } else {
            switch (borderType) {
                case 1: {
                    border = BorderFactory.createEmptyBorder();
                    break;
                }
                case 2: {
                    border = BorderFactory.createEtchedBorder();
                    break;
                }
                case 3: {
                    border = BorderFactory.createBevelBorder(1);
                    break;
                }
            }
        }
        comp.setBorder(border);
    }

    public static void setUpperCase(JTextComponent text, int length) {
        text.setDocument(new UpperCaseDocument(length));
    }

    public static void setLowerCase(JTextComponent text, int length) {
        text.setDocument(new LowerCaseDocument(length));
    }

    public void setWholeNumberField(JTextComponent text, int length) {
        text.setDocument(new WholeNumberDocument(length));
    }

    public static void setDatatype(int datatype, JTextComponent text, int caseConvertion, G9Enums enums, Class enumClass, String displayrule, int maxLength, boolean blankWhenZero) {
        boolean useJoda = false;
        boolean useJavaTime = false;
        boolean useG9Numeric = false;
        if (datatype > 3000) {
            useG9Numeric = true;
            datatype -= 3000;
        } else if (datatype > 2000) {
            useJavaTime = true;
            datatype -= 2000;
        } else if (datatype > 1000) {
            useJoda = true;
            datatype -= 1000;
        }
        switch (datatype) {
            case 6: 
            case 7: 
            case 8: {
                text.setDocument(new TextDocument(datatype, null, null, maxLength, caseConvertion));
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 15: {
                String outputFormat = FormatHelper.getNumericFormat((String)displayrule);
                String inputFormat = FormatHelper.getNumericInputFormat((String)outputFormat);
                int sign = FormatHelper.getSign((String)displayrule);
                maxLength = inputFormat.length();
                text.setDocument(new NumberDocument(datatype, inputFormat, outputFormat, maxLength, sign, blankWhenZero, useG9Numeric));
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                String inputFormat = CustomDate.getDatetimeInputFormat((int)datatype);
                String outputFormat = FormatHelper.getDatetimeFormat((String)displayrule);
                if (outputFormat == null) {
                    outputFormat = CustomDate.getDatetimeOutputFormat((int)datatype);
                }
                if (useJoda) {
                    if (datatype == 13) {
                        text.setDocument(new DateTimeDocument(datatype, inputFormat, outputFormat, maxLength));
                        break;
                    }
                    text.setDocument(new DateMidnightDocument(datatype, inputFormat, outputFormat, maxLength));
                    break;
                }
                if (useJavaTime) {
                    if (datatype == 11) {
                        text.setDocument(new LocalDateDocument(datatype, inputFormat, outputFormat, maxLength));
                        break;
                    }
                    if (datatype == 12) {
                        text.setDocument(new LocalTimeDocument(datatype, inputFormat, outputFormat, maxLength));
                        break;
                    }
                    text.setDocument(new LocalDateTimeDocument(datatype, inputFormat, outputFormat, maxLength));
                    break;
                }
                text.setDocument(new no.g9.client.support.DateDocument(datatype, inputFormat, outputFormat, maxLength));
                break;
            }
            case 10: {
                text.setDocument(new EnumeratorDocument(datatype, null, null, maxLength, enums, enumClass));
                break;
            }
            default: {
                text.setDocument(new G9Document(datatype, null, null, maxLength));
            }
        }
    }

    public static G9Document getDocument(int datatype, int caseConvertion, G9Enums enums, Class enumClass, String displayrule, int maxLength, boolean blankWhenZero) {
        JTextField tmp = new JTextField();
        FrameworkRepository.setDatatype(datatype, tmp, caseConvertion, enums, enumClass, displayrule, maxLength, blankWhenZero);
        return (G9Document)tmp.getDocument();
    }

    public static Color getColor(String name) {
        if (name.equals("ListblockLineDeletedColor")) {
            if (ListblockLineDeletedColorName == null) {
                return Color.red;
            }
            if (ListblockLineDeletedColor == null) {
                ListblockLineDeletedColor = Color.getColor(ListblockLineDeletedColorName);
            }
            return ListblockLineDeletedColor;
        }
        if (name.equals("ListblockLineNewColor")) {
            return ListblockLineNewColor;
        }
        if (name.equals("ListblockLineChangedColor")) {
            return ListblockLineChangedColor;
        }
        return null;
    }

    public static Font getFont(String name) {
        if (name.equals("ListblockFont")) {
            return ListblockFont;
        }
        return null;
    }

    static {
        ListblockLineNewColor = new Color(0.33333334f, 0.33333334f, 1.0f);
        ListblockLineChangedColor = Color.blue;
        ListblockFont = new Font("Arial", 0, 12);
        log = Logger.getLogger(FrameworkRepository.class);
    }

    private static final class G9TitleBorder
    extends TitledBorder {
        private final int radioGroupTopInset;

        G9TitleBorder(String title) {
            super(title);
            this.radioGroupTopInset = -1;
        }

        G9TitleBorder(String title, int radioGroupTopInset) {
            super(title);
            this.radioGroupTopInset = radioGroupTopInset;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            super.paintBorder(c, g, x - 2, y - 2, width + 4, height + 4);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            Insets insets = super.getBorderInsets(c);
            if (this.radioGroupTopInset != -1) {
                insets.top = this.radioGroupTopInset;
            }
            if (log.isTraceEnabled()) {
                if (this.radioGroupTopInset != -1) {
                    log.trace((Object)("Using supplied radio group to inset: " + this.radioGroupTopInset));
                } else {
                    log.trace((Object)("Using default top inset " + insets.top));
                }
            }
            return insets;
        }
    }

    static class DecimalNumberDocument
    extends PlainDocument {
        private int maxLength = 0;

        public DecimalNumberDocument(int length) {
            this.maxLength = length;
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (str == null) {
                return;
            }
            if (this.maxLength > 0 && offs + str.length() > this.maxLength) {
                return;
            }
            char[] source = str.toCharArray();
            char[] result = new char[source.length];
            int j = 0;
            boolean foundDot = false;
            for (int i = 0; i < result.length; ++i) {
                if (offs + i == 0 && source[i] == '-' || Character.isDigit(source[i]) || source[i] == '.' && !foundDot) {
                    if (source[i] == '.') {
                        foundDot = true;
                    }
                } else {
                    Toolkit.getDefaultToolkit().beep();
                    return;
                }
                result[j++] = source[i];
            }
            super.insertString(offs, str, a);
        }
    }

    static class LengthDocument
    extends PlainDocument {
        private int maxLength = 0;

        public LengthDocument(int length) {
            this.maxLength = length;
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (str != null && this.maxLength > 0 && offs + str.length() > this.maxLength) {
                return;
            }
            super.insertString(offs, str, a);
        }
    }

    static class WholeNumberDocument
    extends PlainDocument {
        private int maxLength = 0;

        public WholeNumberDocument(int length) {
            this.maxLength = length;
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (str == null) {
                return;
            }
            if (this.maxLength > 0 && offs + str.length() > this.maxLength) {
                return;
            }
            char[] source = str.toCharArray();
            char[] result = new char[source.length];
            int j = 0;
            for (int i = 0; i < result.length; ++i) {
                if (Character.isDigit(source[i]) || i == 0 && source[i] == '-') {
                    result[j++] = source[i];
                    continue;
                }
                if (source[i] == '.') break;
                System.err.println("insertString whole document: " + source[i]);
            }
            super.insertString(offs, new String(result, 0, j), a);
        }
    }

    static class LowerCaseDocument
    extends PlainDocument {
        private int maxLength = 0;

        public LowerCaseDocument(int length) {
            this.maxLength = length;
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (str != null && this.maxLength > 0 && offs + str.length() > this.maxLength) {
                return;
            }
            if (str == null) {
                return;
            }
            char[] lower = str.toCharArray();
            for (int i = 0; i < lower.length; ++i) {
                lower[i] = Character.toLowerCase(lower[i]);
            }
            super.insertString(offs, new String(lower), a);
        }
    }

    static class UpperCaseDocument
    extends PlainDocument {
        private int maxLength = 0;

        public UpperCaseDocument(int length) {
            this.maxLength = length;
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (str != null && this.maxLength > 0 && offs + str.length() > this.maxLength) {
                return;
            }
            if (str == null) {
                return;
            }
            char[] upper = str.toCharArray();
            for (int i = 0; i < upper.length; ++i) {
                upper[i] = Character.toUpperCase(upper[i]);
            }
            super.insertString(offs, new String(upper), a);
        }
    }

    static class DateDocument
    extends PlainDocument {
        protected transient PropertyChangeSupport propertyChange;
        private String fieldFormat = "";
        private Date fieldDate = new Date();

        public DateDocument() {
            this(CustomDate.getDatetimeInputFormat((int)11));
        }

        public DateDocument(String aFormat) {
            this.setFormat(aFormat);
        }

        public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
            this.getPropertyChange().addPropertyChangeListener(listener);
        }

        public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
            this.getPropertyChange().firePropertyChange(propertyName, oldValue, newValue);
        }

        public Date getDate() {
            return this.fieldDate;
        }

        public String getFormat() {
            return this.fieldFormat;
        }

        protected PropertyChangeSupport getPropertyChange() {
            if (this.propertyChange == null) {
                this.propertyChange = new PropertyChangeSupport(this);
            }
            return this.propertyChange;
        }

        @Override
        public void insertString(int offset, String str, AttributeSet attr) throws BadLocationException {
            if (str == null || str.length() == 0) {
                return;
            }
            if (this.getFormat() == null || this.getFormat().length() == 0) {
                System.out.println("-- No  set.");
                return;
            }
            if (offset >= this.getFormat().length()) {
                return;
            }
            char aChar = str.charAt(0);
            char fChar = this.getFormat().charAt(offset);
            if (Character.isDigit(aChar) == Character.isLetter(fChar) && Character.isLetterOrDigit(fChar)) {
                super.insertString(offset, str, attr);
                if (++offset < this.getFormat().length()) {
                    char bChar = this.getFormat().charAt(offset);
                    if (!(Character.isLetterOrDigit(bChar) || this.getLength() != offset && this.getText(offset, 1).charAt(0) == bChar)) {
                        super.insertString(offset, "" + bChar, attr);
                    }
                } else if (offset == this.getFormat().length()) {
                    SimpleDateFormat sdf = new SimpleDateFormat(this.getFormat());
                    ParsePosition pos = new ParsePosition(0);
                    Date visited = sdf.parse(this.getText(0, offset), pos);
                    if (visited == null) {
                        return;
                    }
                    this.setDate(visited);
                }
            }
        }

        @Override
        public void remove(int offset, int length) throws BadLocationException {
            if (this.getFormat() == null || this.getFormat().length() == 0) {
                System.out.println("-- No  set.");
                return;
            }
            super.remove(offset, length);
            char bChar = this.getFormat().charAt(offset);
            if (!Character.isLetterOrDigit(bChar)) {
                super.remove(--offset, 1);
            }
        }

        public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
            this.getPropertyChange().removePropertyChangeListener(listener);
        }

        public void setDate(Date date) {
            Date oldValue = this.fieldDate;
            this.fieldDate = date;
            this.firePropertyChange("date", oldValue, date);
        }

        public void setFormat(String formatString) {
            String oldValue = this.fieldFormat;
            this.fieldFormat = formatString;
            this.firePropertyChange("", oldValue, formatString);
        }
    }
}

