/*
 * Decompiled with CFR 0.152.
 */
package no.g9.client.support;

import java.math.BigDecimal;
import java.text.ParseException;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import no.esito.log.Logger;
import no.g9.client.support.G9Document;
import no.g9.support.FormatHelper;
import no.g9.support.Numeric;

public class NumberDocument
extends G9Document {
    private boolean blankWhenZero;
    private int sign;
    private int intLength;
    private int decimalLength;
    private boolean overflow;
    private boolean isG9Numeric;

    public NumberDocument(int datatype, String inputFormat, String outputFormat, int maxLength, int sign, boolean blankWhenZero, boolean isG9Numeric) {
        super(datatype, inputFormat, outputFormat, maxLength);
        this.intLength = inputFormat.indexOf(46);
        this.overflow = false;
        if (this.intLength == -1) {
            this.intLength = inputFormat.length();
            this.decimalLength = 0;
        } else {
            this.decimalLength = Math.max(inputFormat.length() - this.intLength - 1, 0);
        }
        if (sign != 0) {
            --this.intLength;
        }
        this.setInputFormat(inputFormat);
        this.setOutputFormat(outputFormat);
        this.sign = sign;
        this.blankWhenZero = blankWhenZero;
        this.isG9Numeric = isG9Numeric;
    }

    public synchronized boolean getBlankWhenZero() {
        return this.blankWhenZero;
    }

    public synchronized void setBlankWhenZero(boolean aBlankWhenZero) {
        this.blankWhenZero = aBlankWhenZero;
    }

    @Override
    public void insertString(int offset, String str, AttributeSet attr) throws BadLocationException {
        if (!this.getInputMode()) {
            super.insertString(offset, str, attr);
        } else if (str != null) {
            String currentText = this.getText(0, this.getLength());
            if (currentText == null) {
                currentText = "";
            }
            if (offset < 0) {
                offset = 0;
            }
            if (offset > currentText.length()) {
                offset = currentText.length();
            }
            StringBuffer buffer = offset > 0 ? new StringBuffer(currentText.substring(0, offset)) : new StringBuffer();
            buffer.append(str);
            buffer.append(currentText.substring(offset));
            if (this.overflow || this.checkInputString(this.getInputFormat(), buffer.toString())) {
                super.insertString(offset, str, attr);
            }
        }
    }

    private boolean isZero(Object value) {
        boolean result = true;
        if (value != null) {
            if (value instanceof Numeric) {
                result = ((Numeric)value).compareTo(new Numeric(0L, ((Numeric)value).getScale())) == 0;
            } else if (value instanceof BigDecimal) {
                result = ((BigDecimal)value).compareTo(BigDecimal.ZERO.setScale(((BigDecimal)value).scale())) == 0;
            } else if (value instanceof Short) {
                result = ((Short)value).compareTo((short)0) == 0;
            } else if (value instanceof Integer) {
                result = ((Integer)value).compareTo(0) == 0;
            } else if (value instanceof Long) {
                result = ((Long)value).compareTo(0L) == 0;
            } else if (value instanceof Float) {
                result = ((Float)value).compareTo(new Float(0.0)) == 0;
            } else if (value instanceof Double) {
                result = ((Double)value).compareTo(new Double(0.0)) == 0;
            }
        }
        return result;
    }

    @Override
    public synchronized void setValue(Object value) {
        super.setValue(value);
        String strValue = this.blankWhenZero && this.isZero(value) ? "" : this.format(this.getInputMode() ? this.getInputFormat() : this.getOutputFormat(), value, false);
        try {
            this.replace(0, this.getLength(), strValue, null);
        }
        catch (BadLocationException e) {
            Logger.getLogger(NumberDocument.class).warn((Object)"Failed to set value", (Throwable)e);
        }
    }

    @Override
    public synchronized String getOutputText() {
        String strValue = null;
        Object value = super.getValue();
        if (value != null) {
            strValue = this.blankWhenZero && this.isZero(value) ? "" : this.format(this.getOutputFormat(), value, false);
        }
        return strValue;
    }

    @Override
    public synchronized Object getValue() {
        Object result = super.getValue();
        if (this.getInputMode()) {
            String strValue = null;
            try {
                strValue = this.getText(0, this.getLength());
            }
            catch (BadLocationException e) {
                Logger.getLogger(NumberDocument.class).warn((Object)"Failed to get value", (Throwable)e);
            }
            if (strValue != null && (strValue.length() != 0 || result != null)) {
                try {
                    result = this.parse(strValue, false);
                }
                catch (ParseException e) {
                    Logger.getLogger(NumberDocument.class).warn((Object)"Failed to parse value", (Throwable)e);
                }
            }
        }
        return result;
    }

    private Object stringToValue(String str) {
        Object retVal;
        try {
            retVal = this.parse(str, false);
        }
        catch (ParseException e) {
            retVal = null;
        }
        return retVal;
    }

    @Override
    public synchronized Object transform(Object o) {
        return this.stringToValue(this.valueToString(o));
    }

    @Override
    public synchronized Object parse(String str) throws ParseException {
        return this.parse(str, true);
    }

    private Object parse(String str, boolean internalFormat) throws ParseException {
        Number retVal = null;
        if (str != null && str.length() != 0) {
            char c;
            StringBuffer numBuffer;
            char decimalSeparator = internalFormat ? (char)'.' : (char)FormatHelper.getDecimalSeparator();
            StringBuffer decimalBuffer = numBuffer = new StringBuffer();
            for (int i = 0; i < str.length(); ++i) {
                char c2 = str.charAt(i);
                if (c2 == '-' && internalFormat && i != 0) {
                    throw new ParseException("Illegal character", i);
                }
                if (Character.isDigit(c2) || c2 == '-') {
                    decimalBuffer.append(c2);
                    continue;
                }
                if (c2 == decimalSeparator) {
                    if (this.getDatatype() == 1 || this.getDatatype() == 2 || this.getDatatype() == 15) {
                        if (internalFormat) {
                            throw new ParseException("Illegal character", i);
                        }
                        decimalBuffer = new StringBuffer();
                        continue;
                    }
                    decimalBuffer.append('.');
                    continue;
                }
                if (!internalFormat) continue;
                throw new ParseException("Illegal character", i);
            }
            int round = 0;
            if (decimalBuffer != numBuffer && decimalBuffer.length() > 0 && Character.isDigit(c = decimalBuffer.charAt(0)) && Character.digit(c, 10) >= 5) {
                round = numBuffer.length() > 0 && numBuffer.charAt(0) == '-' ? -1 : 1;
            }
            try {
                switch (this.getDatatype()) {
                    case 1: {
                        retVal = Short.valueOf(numBuffer.toString());
                        if (round == 0) break;
                        short sh = (Short)retVal;
                        retVal = (short)(sh + round);
                        break;
                    }
                    case 2: {
                        retVal = Integer.valueOf(numBuffer.toString());
                        if (round == 0) break;
                        int in = (Integer)retVal;
                        retVal = in + round;
                        break;
                    }
                    case 15: {
                        retVal = Long.valueOf(numBuffer.toString());
                        if (round == 0) break;
                        long lo = (Long)retVal;
                        retVal = lo + (long)round;
                        break;
                    }
                    case 3: {
                        if (this.isG9Numeric) {
                            retVal = new Numeric(numBuffer.toString(), this.decimalLength);
                            break;
                        }
                        retVal = new BigDecimal(numBuffer.toString()).setScale(this.decimalLength);
                        break;
                    }
                    case 4: {
                        retVal = new Float(numBuffer.toString());
                        break;
                    }
                    case 5: {
                        retVal = new Double(numBuffer.toString());
                        break;
                    }
                }
            }
            catch (NumberFormatException e) {
                throw new ParseException(e.getMessage(), 0);
            }
        }
        return retVal;
    }

    public Object getZeroValue() {
        switch (this.getDatatype()) {
            case 1: {
                return (short)0;
            }
            case 2: {
                return 0;
            }
            case 15: {
                return 0L;
            }
            case 3: {
                if (this.isG9Numeric) {
                    return new Numeric(0L, this.decimalLength);
                }
                return BigDecimal.ZERO.setScale(this.decimalLength);
            }
            case 4: {
                return Float.valueOf(0.0f);
            }
            case 5: {
                return 0.0;
            }
        }
        return null;
    }

    @Override
    public synchronized String format() {
        return this.format(this.getInputFormat(), this.getValue(), true);
    }

    private String valueToString(Object value) {
        return this.format(this.getInputFormat(), value, false);
    }

    private String format(String format, Object number, boolean internalFormat) {
        int sign1 = this.sign;
        if (format.equals(this.getInputFormat())) {
            if (sign1 == -1) {
                sign1 = -2;
            }
            if (sign1 == 1) {
                sign1 = 2;
            }
        }
        StringBuffer res = new StringBuffer();
        if (number != null) {
            String bStr = number.toString();
            int intPos = 0;
            boolean negative = false;
            if (bStr.length() > 0) {
                int dot;
                int noDigits;
                if (bStr.length() > 0 && bStr.charAt(intPos) == '-') {
                    negative = true;
                    ++intPos;
                }
                if ((noDigits = bStr.indexOf(dot = 46)) < 0) {
                    noDigits = bStr.length();
                }
                if ((noDigits -= intPos) > this.intLength || negative && sign1 == 0) {
                    for (noDigits = 0; noDigits < this.getMaxLength(); ++noDigits) {
                        res.append('#');
                    }
                    this.overflow = true;
                    return res.toString();
                }
                this.overflow = false;
                int dotPos = format.indexOf(46);
                int signPos = this.addInt(dotPos < 0 ? format : format.substring(0, dotPos + 1), sign1, internalFormat, noDigits < 0 ? "0" : bStr.substring(intPos, noDigits + intPos), this.intLength, res);
                if (dotPos >= 0) {
                    intPos = bStr.indexOf(dot) + 1;
                    if (intPos > 0 && intPos <= bStr.length()) {
                        noDigits = bStr.length() - intPos;
                        bStr = bStr.substring(intPos);
                        while (this.decimalLength > noDigits) {
                            bStr = bStr.concat("0");
                            ++noDigits;
                        }
                    } else {
                        bStr = "";
                    }
                    int tmp = this.addInt(format.substring(dotPos + 1), sign1, internalFormat, bStr, this.decimalLength, res);
                    if (signPos == -1) {
                        signPos = tmp;
                    }
                }
                if (signPos >= 0 && sign1 != 0) {
                    if (negative) {
                        res.insert(signPos, '-');
                    } else if (sign1 == 1 || sign1 == 2) {
                        res.insert(signPos, '+');
                    } else if (sign1 == -1) {
                        res.insert(signPos, ' ');
                    }
                }
                if (format.equals(this.getInputFormat()) || format.charAt(0) == '#' || format.charAt(0) == '+' && sign1 != -1 && sign1 != 1) {
                    int i;
                    for (i = 0; i < res.length() && res.charAt(i) == ' '; ++i) {
                    }
                    if (i > 0) {
                        res.delete(0, i);
                    }
                    for (i = res.length() - 1; i >= 0 && res.charAt(i) == ' '; --i) {
                    }
                    if (++i >= 0) {
                        res.delete(i, res.length());
                    }
                }
            }
        }
        return res.toString();
    }

    private int addInt(String format, int sign1, boolean internalFormat, String number, int maxLength, StringBuffer buffer) {
        int signPos = -1;
        int resPos = 0;
        int intPos = 0;
        int formatPos = -1;
        int noDigits = number.length();
        for (formatPos = 0; formatPos < format.length(); ++formatPos) {
            char c = format.charAt(formatPos);
            switch (c) {
                case '+': {
                    signPos = resPos;
                    break;
                }
                case '#': 
                case '0': {
                    if (noDigits < maxLength) {
                        ++noDigits;
                        if (c == '0') {
                            buffer.append('0');
                            break;
                        }
                        buffer.append(' ');
                        if (signPos < 0 || sign1 != -2 && sign1 != 2) break;
                        signPos = resPos;
                        break;
                    }
                    buffer.append((char)(number.length() == 1 && c == '#' && number.charAt(0) == '0' ? 32 : number.charAt(intPos)));
                    ++intPos;
                    break;
                }
                case ',': {
                    buffer.append(FormatHelper.getGroupingSeparator());
                    break;
                }
                case '.': {
                    buffer.append(internalFormat ? (char)'.' : (char)FormatHelper.getDecimalSeparator());
                    break;
                }
                default: {
                    buffer.append(c);
                }
            }
            ++resPos;
        }
        return signPos;
    }

    private boolean checkInputString(String format, String input) {
        assert (input != null);
        if (this.getMaxLength() > 0 && input.length() > this.getMaxLength()) {
            return false;
        }
        char dot = FormatHelper.getDecimalSeparator();
        int indexOfFirstDot = input.indexOf(dot);
        if (format.indexOf(46) == -1 && indexOfFirstDot != -1) {
            return false;
        }
        if (indexOfFirstDot != input.lastIndexOf(dot)) {
            return false;
        }
        int indexOfMinus = input.indexOf(45);
        int indexOfPlus = input.indexOf(43);
        if (this.sign == 0 && (indexOfMinus >= 0 || indexOfPlus >= 0) || (this.sign == -1 || this.sign == -2) && indexOfPlus >= 0 || indexOfMinus >= 0 && indexOfPlus >= 0 || Math.max(indexOfMinus, indexOfPlus) != Math.max(input.lastIndexOf(45), input.lastIndexOf(43))) {
            return false;
        }
        int noDig = 0;
        int noAllowedDig = this.intLength;
        for (int i = 0; i < input.length(); ++i) {
            if (Character.isDigit(input.charAt(i))) {
                if (++noDig <= noAllowedDig) continue;
                return false;
            }
            if (input.charAt(i) == dot) {
                noDig = 0;
                noAllowedDig = this.decimalLength;
                continue;
            }
            if (input.charAt(i) == '-' || input.charAt(i) == '+') continue;
            return false;
        }
        return true;
    }
}

