/*
 * Copyright 2013-2020 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.component.menu;

import javax.swing.Action;

/**
 * The G9 help menu class
 */
public class G9HelpMenu extends G9Menu {

    /** Reference to the default help menu */
    private static G9HelpMenu defaultHelpMenu;
    
    /**
     * Gets the singleton instance of the default help menu. If the default help
     * menu is already created, the title parameter is ignored, otherwise a new
     * help menu is created using the title
     * 
     * @param title the title of the menu
     * @return the default help menu
     */
    public static G9HelpMenu getDefaultHelpMenu(String title) {
        if (defaultHelpMenu == null) {
            defaultHelpMenu = new G9HelpMenu(title);
        }
        return defaultHelpMenu;
        
    }
    
    
    /**
     * Constructs a new <code>JMenu</code> with no text.
     */
    public G9HelpMenu() {
        this("");
    }

    /**
     * Constructs a new <code>JMenu</code> with the supplied string as its text.
     * 
     * @param s the text for the menu label
     */
    public G9HelpMenu(String s) {
        super(s, G9Menu.HELP_MENU);
    }

    /**
     * Constructs a new <code>JMenu</code> with the supplied string as its text
     * and specified as a tear-off menu or not.
     * 
     * @param s the text for the menu label
     * @param b can the menu be torn off (not yet implemented)
     */
    public G9HelpMenu(String s, boolean b) {
        this(s);
    }

    /**
     * Constructs a new <code>JMenu</code> whose properties are taken from the
     * <code>Action</code> supplied.
     * 
     * @param a the <code>Action</code>
     * @since 1.3
     */
    public G9HelpMenu(Action a) {
        this("");
        setAction(a);
    }
    
}
