/*
 * Copyright 2013-2020 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.event;

import java.awt.event.ComponentEvent;

/** The event holder for component events. */
public class G9ComponentEventHolder extends G9Event {

    /** The component event. */
    ComponentEvent event;


    /**
     * Creates a new instance of this event holder.
     * @param e the component event to hold
     */
    public G9ComponentEventHolder(ComponentEvent e) {
        super(e);
        event = e;
    }

    /**
     * Returns the component event being hold by this event holder.
     * @return the component event.
     */
    public ComponentEvent getEvent() {
        return event;
    }
}
