/*
 * Copyright 2013-2020 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.event;

/** The data event class */
public class G9DataEvent {
    /** Type of data event */
    long id;

    /** String representation of type */
    String type;

    /** The data */
    Object data;

    /** Default empty constructor */
    public G9DataEvent() { /* Not impl. */
    }

    /**
     * Creates a new data event.
     * 
     * @param id the type of event
     * @param type type string
     * @param data the data
     */
    public G9DataEvent(long id, String type, Object data) {
        this.id = id;
        this.type = type;
        this.data = data;
    }

    /**
     * Sets the data for this event.
     * 
     * @param data the data to set.
     */
    public void setData(Object data) {
        this.data = data;
    }

    /**
     * Sets the type of this event
     * 
     * @param type the type to set.
     */
    public void setType(String type) {
        this.type = type;
    }

    /**
     * Sets the id of this event
     * 
     * @param id the id to set.
     */
    public void setId(long id) {
        this.id = id;
    }

    /**
     * Gets the data object of this event.
     * 
     * @return the data object.
     */
    public Object getData() {
        return data;
    }

    /**
     * Gets the event id.
     * 
     * @return the event id.
     */
    public long getId() {
        return id;
    }

    /**
     * Gets the type.
     * 
     * @return the type.
     */
    public String getType() {
        return type;
    }

    /**
     * Check if <code>x</code> is the same as this event's type.
     * 
     * @param x the type to check
     * @return <code>true</code> if <code>x</code> equals this event's type.
     */
    public boolean typeMatch(String x) {
        return x.equals(type);
    }

    /**
     * Check if <code>id</code> is the same as this event's id.
     * 
     * @param x the id to check
     * @return <code>true</code> if <code>x</code> equals this event's id.
     */
    public boolean idMatch(long x) {
        return x == id;
    }

}
