/*
 * Copyright 2013-2020 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.event;

import java.awt.event.MouseEvent;


/** Wraps a mouse - header clicked event */
public class G9HeaderClickedEventHolder extends G9Event {
    /** The wrapped event */
    MouseEvent event;

    /**
     * The column clicked index
     */
    int columnClicked;

    /**
     * Creates a new event holder wrapping the specified event and column
     * 
     * @param e the MouseEvent to wrap
     *            
     * @param clickedColumn the clicked column
     *            
     */
    public G9HeaderClickedEventHolder(MouseEvent e, int clickedColumn) {
        event = e;
        this.columnClicked = clickedColumn;
    }

    /**
     * Returns the index of the clicked colunm
     * 
     * @return the clicked column index
     */
    public int getColumnClicked() {
        return columnClicked;
    }

    /**
     * Returns the wrapped event
     * 
     * @return the wrapped event
     */
    public MouseEvent getEvent() {
        return event;
    }
}
