/*
 * Copyright 2013-2020 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.event;

import java.util.EventListener;

/** The listener interface for the value changed event.
 * Parties interessted in this event should implement this interface and register
 * as a listener on classes capable of fiering a value changed event.
 */
public interface G9ValueChangedListener extends EventListener {
    
    /**
     * Invoked each time a value changed event occurs
     * @param e the value changed event
     */
    public void valueChanged(G9ValueChangedEvent e);

}
