/*
 * Copyright 2013-2020 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.support;


/**
 * General interface for dialog visitors.
 * <p>
 * The {@link Application#visitAll(DialogVisitor)}-method is one possible
 * application of this interface.
 * </p>
 */
public interface DialogVisitor {
    
    /**
     * Visit one dialog.
     *
     * @param app  Current application
     * @param gdc  Dialog to visit
     * @return     The value returned must be specified by each individual
     *             visitor implementation.  Typically, a G9BaseException
     *             will be thrown to abort the loop.
     */
    boolean visit(ApplicationMethods app, G9DialogController gdc);

    /**
     * Callback when all dialogs are visited.
     * <p>
     * If you need to synchronously wait for a visitor running in a different thread,
     * invoke the visit loop like this:
     * <pre>
     *    DialogVisitor myVisitor= ...
     *    synchronized (myVisitor) {
     *        app.visitAll(myVisitor); // Maybe on another thread
     *        myVisitor.wait();
     *    } // Exception handling ommitted
     *    moreStuff...
     * </pre>
     * and implement the <code>done()</code> method simply as follows:
     * <pre>
     *    public synchronized void done() {
     *      notifyAll();
     *    }
     * </pre>
     */
    void done();
}
