/*
 * Copyright 2013-2020 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.support;

import javax.swing.ImageIcon;

/**
 * Proxy class for lazy loading of images.
 */
public class ImageProxy {

    private final String fileName;

    private ImageIcon image;

    /**
     * Create a new image proxy for the given file name.
     * 
     * @param fileName (missing javadoc)
     */
    public ImageProxy(String fileName) {
        this.fileName = fileName;
    }

    /**
     * @return the image for the file name.
     */
    public ImageIcon getImage() {
        if (image == null) {
            image = LoadImageTools.getImage(fileName);
        }
        return image;
    }
}