/*
 * Copyright 2013-2020 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.support;

import java.awt.Color;
import java.awt.Component;

import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

/** Internal class */
public class JComponentCellRenderer implements TableCellRenderer {

    @Override
    public Component getTableCellRendererComponent(JTable table,
            Object value, boolean isSelected, boolean hasFocus, int row,
            int column) {
        if (hasFocus) {
            ((JComponent) value).setBackground(Color.white);
            ((JComponent) value).setForeground(Color.black);
        } else if (isSelected) {
            ((JComponent) value).setBackground(table
                    .getSelectionBackground());
            ((JComponent) value).setForeground(table
                    .getSelectionForeground());
        } else {
            if (value instanceof JCheckBox) {
                ((JComponent) value).setBackground(table.getBackground());
                ((JComponent) value).setForeground(table.getForeground());
            } else {
                ((JComponent) value).setBackground(table.getTableHeader()
                        .getBackground());
                ((JComponent) value).setForeground(table.getTableHeader()
                        .getForeground());
            }
        }
        return (JComponent) value;
    }
}
