/*
 * Copyright 2013-2020 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.support;

import java.util.Collection;

/**
 * Common methods for listblock lines.
 */
@SuppressWarnings("rawtypes")
public interface ListblockLine {

    /**
     * Edits cell in the given listblock line, where the object is 'type' (the
     * related object node) and column is 'fieldName' (named in g9). The
     * type object is not modified, and onlyused to decide which field is to be
     * edited in thelistblock.
     *
     * @param type The object selection node to use.
     * @param fieldName The fieldname to use.
     */
    public void editFieldOS(Object type, String fieldName);

    /**
     * Edits cell in the given listblock line, where the object is 'type' and
     * column is 'fieldName'. The type object is not modified, and only used to
     * decide which field is to be edited in the listblock.
     *
     * @deprecated Use editFieldOS insted.
     * @param type The object selection to use
     * @param fieldName The field name to use.
     */
    @Deprecated
    public void editField(Object type, String fieldName);

    /**
     * Returns true if there is a previous state stored in the dialog
     *
     * @return True if previous state is stored.
     */
    public boolean hasPreviousState();

    /**
     * Copies data from the old set of data (the last reset) to the new
     * "current" set of data. Also copies old flags.
     *
     * @see #hasPreviousState()
     */
    public void previousState();

    /**
     * Updates the UI after modifying a given listblock line.
     */
    public void refresh();

    /**
     * Reset status, and copies values from the new set to the old set of data
     * for this listblock line.
     */
    public void reset();

    /**
     * Disables/enables a given field in the listblock line represented by the
     * object owner.field. Only valid if the listblock has hidden listblock
     * lines.
     *
     * @param owner The object to disable.
     * @param field The field to disable.
     * @param setting True if the field should be disabled, false if not.
     * @deprecated Use setDisabledFieldOS.
     */
    @Deprecated
    public void setDisabledField(Object owner, String field, boolean setting);

    /**
     * Disables/enables a given field in the listblock line represented by the
     * object selection node object owner. The field name is the field name
     * given in g9.
     *
     * @param owner The object selection to use
     * @param field The field name
     * @param setting True if the field should be disabled, false if not.
     */
    public void setDisabledFieldOS(Object owner, String field, boolean setting);

    /**
     * Adds a domain object to this listblock.
     *
     * @param domainObject (missing javadoc)
     */
    public void addDomainObject(Object domainObject);

    /**
     * Gets a <code>Collection</code> of the objects contained in this line.
     *
     * @return a <code>Collection</code> of the objects contained in this line.
     * @deprecated (missing javadoc)
     */
    @Deprecated
    public Collection getDomainObjects();

    /**
     * Displays the domain objects contained in this list block line in the edit
     * fields of the listblock.
     */
    public void displayInEditField();

    /**
     * Returns the listblock that this line is part of
     *
     * @return the listblock
     */
    public Listblock getListblock();

    /**
     * Internal use!
     *
     * @return the line number of this line.
     */
    public int getLineNumber();

    /**
     * Inserts the @@RoleName@@ object into the listblock line.
     *
     * @param roleName the role name of the object
     * @param obj the object to insert.
     */
    public void insertObject(String roleName, Object obj);

    /**
     * Returns the <em>roleName</em> object held by this line. If the object
     * does not exist a new object is created.
     *
     * @param roleName the role name of the object to return
     * @return the object held by this line.
     * @deprecated use {@link #getObject(String, boolean)}
     */
    @Deprecated
    public Object getObject(String roleName);

    /**
     * Returns the <em>roleName</em> object held by this line. If the second
     * parameter is <code>true</code> and the line does not hold a reference to
     * the object, a new instance is created using the default constructor.
     *
     * @param roleName the role name of the object
     * @param createIfNull flag indicating if missing object should be created
     * @return the object held by this line.
     */
    public Object getObject(String roleName, boolean createIfNull);

    /**
     * Returns <code>true</code> if this line contains the specified instance.
     *
     * @param domainObject the domain object possibly present in this line
     * @return <code>true</code> if this line contains the object.
     */
    public boolean contains(Object domainObject);

    /**
     * Selects or unselects this line, depending on the <code>select</code>
     * value.
     * <p>
     * If <code>select</code> is <code>true</code> this line is selected, and
     * displayed in the edit fields.
     * <p>
     * If <code>select</code> is <code>false</code>, the line is unselected. If
     * no other line is selected, the edit fields are cleared, otherwise, the
     * first selected line (starting from the top of the listblock) is displayed
     * in the edit fields.
     * <p>
     * <em>Note</em> that invoking this method does not fire a selected event,
     * nor does it issue a warning if the edit fields are changed prior to
     * selection.
     *
     * @param select if <code>true</code> selects this line, otherwise unselects
     *            this line.
     */
    public void setSelected(boolean select);

    /**
     * Returns the selected state of this line.
     *
     * @return <code>true</code> if the line is selected.
     */
    public boolean isSelected();

    /**
     * Returns <code>true</code> if this line is changed. Only applies to
     * listblocks with inline editing.
     *
     * @return <code>true</code> if this line is changed.
     */
    public boolean isChanged();

    /**
     * Obtains the value specified by <code>identifier</code>. If it is an
     * attribute name (e.g. "foo.bar") the displayed value from the
     * corresponding column is returned. Otherwise, if it is a role name, the
     * domain object (corresponding to the role) is updated with the displayed
     * values, and then returned.
     *
     * @param identifier the name of the role or field name
     * @return the obtained value
     */
    public Object obtain(String identifier);

    /**
     * Obtains all the displayed roles. Each domain instance is updated with the
     * displayed values and the line is returned.
     *
     * @return the obtained listblock line.
     */
    public ListblockLine obtain();

}
