/*
 * Copyright 2013-2020 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.support;

import java.net.URL;

import javax.swing.ImageIcon;

import no.esito.log.Logger;
import no.g9.support.Pathfinder;

/**
 * Helper class for loading images
 */
public class LoadImageTools {

    /** The logger */
    private static final Logger log = Logger.getLogger(LoadImageTools.class);

    /** Property name to lookup in Registry */
    private static final String PROPERTY_NAME = "ImagePrePath";

    /** Only static methods */
    private LoadImageTools() {
        // Empty.
    }

    /**
     * Returns an ImageIcon loaded from the image file: <code>file</code>. The
     * image file is located using {@link Pathfinder#getResourceReference(String, String)}.
     * 
     * @param file a relative or absolute path to an png, gif or jpg file.
     * @return An ImageIcon if the file was located, otherwise null.
     */
    public static ImageIcon getImage(String file) {
        URL url = Pathfinder.getResourceReference(PROPERTY_NAME, file);
        if (url == null) {
            log.warn("Could not load image icon from file: \"" + file + "\"");
        }
        return url != null ? new ImageIcon(url) : null;
    }

}
