/*
 * Copyright 2013-2020 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.support;

import java.awt.Color;
import java.awt.Font;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;

import no.g9.domain.G9Enums;

/**
 * This class proxies methods from dialog to application repository.
 */
@SuppressWarnings("rawtypes")
public class RepositoryProxy {
    private static G9Repository repository;

    /**
     * Initialize the proxy
     *
     * @param repo (missing javadoc)
     */
    public static void init(G9Repository repo) {
        RepositoryProxy.repository = repo;
    }


    /**
     * Tunnels call to repository
     *
     * @param datatype the datatype
     * @param text the text component
     * @param caseConversion boolean flag
     * @param enums the enumeration instance
     * @param enumClass the enumeration class
     * @param displayrule the display rule
     * @param maxLength the max length property
     * @param blankWhenZero the blank when zero flag
     */
    public static void setDatatype(int datatype, JTextComponent text,
            int caseConversion, G9Enums enums, Class enumClass,
            String displayrule, int maxLength, boolean blankWhenZero) {
        FrameworkRepository.setDatatype(datatype, text, caseConversion,
                enums, enumClass, displayrule, maxLength, blankWhenZero);
    }

    /**
     * Internal use only.
     * <p>
     * Tunnels call to framework repository.
     *
     * @param datatype the genova data type
     * @param caseConversion boolean flag
     * @param enums the enumeration instance
     * @param enumClass the enumeration class
     * @param displayrule the display rule converted to a java format String
     * @param maxLength the max length
     * @param blankWhenZero the blank when zero flag
     * @return a g9 document initialized with the supplied parameters.
     */
    public static G9Document getDocument(int datatype,
            int caseConversion, G9Enums enums, Class enumClass,
            String displayrule, int maxLength, boolean blankWhenZero) {
        return FrameworkRepository.getDocument(datatype, caseConversion,
                enums, enumClass, displayrule, maxLength, blankWhenZero);
    }

    /**
     * @param fontName (missing javadoc)
     * @return The font
     */
    public static Font getFontField(String fontName) {
        Font font = FrameworkRepository.getFont(fontName);
        if (font == null) {
            font = repository.getFont(fontName);
        }
        return font;
    }

    /**
     * @param colorName (missing javadoc)
     * @return The color
     */
    public static Color getColorField(String colorName) {
        Color color = FrameworkRepository.getColor(colorName);
        if (color == null) {
            color = repository.getColor(colorName);
        }
        return color;
    }

    /**
     * @param imageName (missing javadoc)
     * @return The ImageIcon
     */
    public static ImageIcon getImageField(String imageName) {
        return repository.getImage(imageName);
    }

    /**
     * @param imageName (missing javadoc)
     */
    public static void setDefaultImage(String imageName) {
        repository.setDefaultImage(imageName);
    }

    /**
     * @param button (missing javadoc)
     * @param imageName (missing javadoc)
     */
    public static void setImage(JButton button, String imageName) {
        if (!imageName.equals("NO_IMAGE"))
            button.setIcon(getImageField(imageName));
    }

    /**
     * @param comp (missing javadoc)
     * @param borderType (missing javadoc)
     * @param title (missing javadoc)
     */
    public static void setBorder(JComponent comp, int borderType, String title) {
        FrameworkRepository.setBorder(comp, borderType, title);
    }

    /**
     * @param comp (missing javadoc)
     * @param borderType (missing javadoc)
     * @param title (missing javadoc)
     * @param radioGroupTopOffset (missing javadoc)
     */
    public static  void setBorder(JComponent comp, int borderType, String title, int radioGroupTopOffset) {
        FrameworkRepository.setBorder(comp, borderType, title, radioGroupTopOffset);
    }

    /**
     * @param comp (missing javadoc)
     * @param fgcolor (missing javadoc)
     */
    public static void setForegroundColor(JComponent comp, String fgcolor) {
        if (!fgcolor.equals("TRANSPARENT"))
            comp.setForeground(getColorField(fgcolor));
    }

    /**
     * @param comp (missing javadoc)
     * @param bgcolor (missing javadoc)
     */
    public static void setBackgroundColor(JComponent comp, String bgcolor) {
        if (!bgcolor.equals("TRANSPARENT"))
            comp.setBackground(getColorField(bgcolor));
    }

    /**
     * Tunnels call to repository
     *
     * @param comp (missing javadoc)
     * @param fontname (missing javadoc)
     */
    public static void setFont(Component comp, String fontname) {
        comp.setFont(getFontField(fontname));
    }

    /**
     * Proxy for call to repository
     *
     * @param text (missing javadoc)
     * @param length (missing javadoc)
     */
    public static void setUpperCase(JTextComponent text, int length) {
        FrameworkRepository.setUpperCase(text, length);
    }

    /**
     * Proxy for call to repository
     *
     * @param text (missing javadoc)
     * @param length (missing javadoc)
     */
    public static void setLowerCase(JTextComponent text, int length) {
        FrameworkRepository.setLowerCase(text, length);
    }

}
