/*
 * Copyright 2013-2020 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.support;


/**
 * Objekt som sendes med når dialog kalles. Kallet dialog kan sette returverdi
 * og gi kontrollen tilbake til kallende dialog.
 */
public class ReturnToDialog {

    /** Reference to the calling dialog */
	private G9DialogController caller;
	
	/** Reference to the dialog being called */
    private G9DialogController callee;
    
    /**
     * OpCode is a local constant that may be utilized by the caller to
     * determine further processing when regaining focus.
     */
    private int opCode;
    
    /** Data returned from callee. */
    private Object returnData;

    /**
     * Gets the caller attribute
     * 
     * @return caller
     */
    public G9DialogController getCaller() {
		return this.caller;
	}

    /**
     * Sets the caller attribute
     * 
     * @param caller (missing javadoc)
     */
	public void setCaller(G9DialogController caller) {
		this.caller = caller;
	}

    /**
     * Gets the dialog being called
     * 
     * @return callee
     */
    public G9DialogController getCallee() {
		return this.callee;
	}

    /**
     * Sets the dialog being called
     * 
     * @param callee (missing javadoc)
     */
    public void setCallee(G9DialogController callee) {
		this.callee = callee;
	}

    /**
     * Gets the <code>opCode</code> for further processing in caller
     * 
     * @return opCode
     */
    public int getOpCode() {
		return this.opCode;
	}

    /**
     * Sets the <code>opCode</code> for further processing in caller
     * 
     * @param opCode (missing javadoc)
     */
    public void setOpCode(int opCode) {
		this.opCode = opCode;
	}

    /**
     * Gets the return data from callee
     * 
     * @return returnData
     */
    public Object getReturnData() {
		return this.returnData;
	}

    /**
     * Sets the return data from callee that may be used in caller
     * 
     * @param returnData (missing javadoc)
     */
    public void setReturnData(Object returnData) {
		this.returnData = returnData;
	}

    /**
     * Used by callee to let caller regain control.
     */
	public void returnToCaller() {
        if (caller != null) {
            this.caller.returnToCaller(this);
        }
	}

}
