/*
 * Copyright 2013-2020 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.support;
import javax.swing.JLabel;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.*;
import javax.swing.UIManager;

/** The renderer used by a row header */
public class RowHeaderRenderer extends JLabel implements TableCellRenderer {

    /** 
     * Creates a new row header instance
     * @param table the table to render for.
     */
    public  RowHeaderRenderer(G9Table table) {
        JTableHeader header = table.getTableHeader();
        setOpaque(true);
        setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        setHorizontalAlignment(CENTER);
        setForeground(header.getForeground());
        setBackground(header.getBackground());
        setFont(header.getFont());
    }


    @Override
    public Component getTableCellRendererComponent( JTable table, 
            Object value, boolean isSelected, boolean cellHasFocus,
            int row, int column) {
        setText((value == null) ? "" : value.toString());
        return this;
    }
}
