/*
 * Copyright 2013-2020 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.support;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.table.TableColumn;

/** Utility class for a table column */
public class TableBlockTools {

    /**
     * Sets the specified component to act as a column editor for the specified table column.
     * @param tableColumn the table column on which to set an editor
     * @param component the editor to set at the specified table column.
     */
    @SuppressWarnings("rawtypes")
    static public void setTableColumnEditor(TableColumn tableColumn, Object component ) {
        if(component instanceof JComboBox) {
            tableColumn.setCellEditor(new DefaultCellEditor(((JComboBox)component)));
        } else if(component instanceof JCheckBox) {
            tableColumn.setCellEditor(new DefaultCellEditor(((JCheckBox)component)));
        } else if(component instanceof JTextField) {
            tableColumn.setCellEditor(new DefaultCellEditor(((JTextField)component)));
        }
    }
}
