/*
 * Copyright 2013-2020 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.support.message;

import java.awt.Component;

import no.g9.client.support.ApplicationMethods;
import no.g9.message.DispatcherContext;

/**
 *  A message context used in JFC. The component is the owner of
 *  the message.
 */
public interface ClientDispatcherContext extends DispatcherContext {

    /**
     * @return the JFC component
     */
    Component getOwner();

    /**
     * @return the application
     */
    ApplicationMethods getApplication();
}
