/*
 * Decompiled with CFR 0.152.
 */
package no.g9.client.component;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.ParseException;
import java.util.Collection;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.MutableComboBoxModel;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import no.esito.util.EnumUtil;
import no.g9.client.component.ComboBoxRenderer;
import no.g9.client.component.G9Button;
import no.g9.client.component.G9ComboBoxEditor;
import no.g9.client.component.G9ComboBoxModel;
import no.g9.client.component.G9TextField;
import no.g9.client.event.G9SelectedEvent;
import no.g9.client.event.G9SelectionListener;
import no.g9.client.event.G9ValueChangedEvent;
import no.g9.client.event.G9ValueChangedListener;
import no.g9.client.event.G9ValueState;
import no.g9.client.support.G9FieldValue;
import no.g9.exception.G9BaseException;
import no.g9.exception.G9ClientFrameworkException;
import no.g9.message.DispatcherContext;
import no.g9.message.Message;
import no.g9.message.MessageSystem;

public class G9ComboBox
extends JComboBox
implements G9FieldValue,
G9ValueState {
    private boolean caseSensitiveSearch = false;
    protected EventListenerList vcListeners = new EventListenerList();
    private Object initialValue = null;
    private Object valueWhenGainedFocus = null;
    private Object selectionReminder = null;
    private boolean isSearchable = false;
    private SearchAgent searchAgent = null;
    private boolean dontFire;
    private boolean customEdit = false;

    public G9ComboBox() {
        G9ComboBoxModel model = new G9ComboBoxModel();
        this.setModel(model);
        model.setComboBox(this);
        SelectionManager selectionManager = new SelectionManager();
        this.setKeySelectionManager(selectionManager);
        this.addKeyListener(selectionManager);
        this.setEditor(new G9ComboBoxEditor(this));
        this.getEditor().getEditorComponent().addFocusListener(new FocusWhenPopupManager());
        this.addFocusListener(new FocusWhenPopupManager());
        this.getEditor().getEditorComponent().addFocusListener(new FocusManager());
        this.addFocusListener(new FocusManager());
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                G9ComboBox.this.maybeFireSelectedEvent();
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    G9ComboBox.this.maybeFireSelectedEvent();
                } else if (e.getKeyCode() == 27) {
                    G9ComboBox.this.setSelectedItem(G9ComboBox.this.selectionReminder);
                }
            }
        });
        this.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    G9ComboBox.this.setSelectedItem(G9ComboBox.this.selectionReminder);
                }
            }
        });
        this.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                if (G9ComboBox.this.isSearchable() && !G9ComboBox.this.isCustomEditable()) {
                    G9ComboBox.this.getEditor().setItem(G9ComboBox.this.getSelectedItem());
                }
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
    }

    protected void fireG9ValueChangedEvent(int id, Object oldValue, Object newValue) {
        Object[] listeners = this.vcListeners.getListenerList();
        AWTEvent e = null;
        block3: for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (e == null) {
                e = new G9ValueChangedEvent(this, id, oldValue, newValue);
            }
            if (listeners[i] != G9ValueChangedListener.class) continue;
            switch (e.getID()) {
                case 2000: {
                    ((G9ValueChangedListener)listeners[i + 1]).valueChanged((G9ValueChangedEvent)e);
                    continue block3;
                }
            }
        }
    }

    public String format(Object anObject) {
        return ((ComboBoxRenderer)this.getRenderer()).format(anObject);
    }

    @Override
    public String format() {
        Object selectedItem = this.getSelectedItem();
        if (selectedItem != null) {
            return ((ComboBoxRenderer)this.getRenderer()).format(selectedItem);
        }
        return null;
    }

    @Override
    public Object getValue() {
        return this.getDisplayValue(this.getSelectedItem());
    }

    @Override
    public Object parse(String formattedString) {
        Object o = null;
        try {
            o = ((ComboBoxRenderer)this.getRenderer()).parse(formattedString);
        }
        catch (ParseException e) {
            Object[] args = new Object[]{this.getClass(), this.getName(), formattedString};
            Message msg = MessageSystem.getMessageFactory().getMessage("-1514", args);
            MessageSystem.getMessageDispatcher((DispatcherContext)MessageSystem.NO_INTERACTION).dispatch(msg);
            throw new G9ClientFrameworkException(msg);
        }
        return o;
    }

    @Override
    public void setValue(Object value) {
        this.display(value);
    }

    @Override
    public void addValueChangedListener(G9ValueChangedListener listener) {
        this.vcListeners.add(G9ValueChangedListener.class, listener);
    }

    @Override
    public void display(Object anObject) {
        if (anObject instanceof String) {
            Object item = this.getItem((String)anObject);
            if (item != null) {
                anObject = item;
            } else if (!this.isCustomEditable() && this.getIndexOfNullValue() < 0) {
                return;
            }
        }
        if (!this.hasItem(anObject) && !this.isCustomEditable()) {
            if (anObject == null) {
                anObject = this.getItemAt(0);
            } else {
                return;
            }
        }
        this.dontFire = true;
        this.setSelectedItem(anObject);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                G9ComboBox.this.dontFire = false;
            }
        });
    }

    private int getItemIndexFromString(String itemAsString) {
        itemAsString = ((ComboBoxRenderer)this.getRenderer()).format(itemAsString);
        int index = -1;
        for (int i = 0; i < this.getItemCount() && index == -1; ++i) {
            String displayString = this.format(this.getItemAt(i));
            if (displayString == null || !displayString.equals(itemAsString)) continue;
            index = i;
        }
        return index;
    }

    private int getIndexOfNullValue() {
        int nullIndex = -1;
        for (int i = 0; i < this.getItemCount() && nullIndex == -1; ++i) {
            Object o = this.getItemAt(i);
            if (o != null) continue;
            nullIndex = i;
        }
        return nullIndex;
    }

    @Override
    public Object getInitialValue() {
        return this.initialValue;
    }

    @Override
    public boolean isChanged() {
        Object currentSelection = this.getSelectedItem();
        if (this.isEditable() && this.getItemCount() == 0) {
            currentSelection = this.editor.getItem();
        }
        if (this.initialValue == null) {
            return currentSelection != null;
        }
        return !currentSelection.equals(this.initialValue);
    }

    @Override
    public Object getSelectedItem() {
        if (!this.isEditable()) {
            return super.getSelectedItem();
        }
        String itemValue = ((G9TextField)this.getEditor().getEditorComponent()).getText();
        Object item = this.getItem(itemValue);
        if (item == null) {
            item = ((G9TextField)this.getEditor().getEditorComponent()).getValue();
        }
        return item;
    }

    public void reset() {
        if (this.getItemCount() > 0) {
            this.valueWhenGainedFocus = this.initialValue = this.getItemAt(0);
            this.selectionReminder = this.initialValue;
            this.setSelectedIndex(0);
        } else if (this.isCustomEditable()) {
            this.valueWhenGainedFocus = this.initialValue = null;
            this.selectionReminder = this.initialValue;
            this.setSelectedItem(null);
        }
    }

    @Override
    public void resetState() {
        this.valueWhenGainedFocus = this.initialValue = this.getSelectedItem();
        this.selectionReminder = this.initialValue;
    }

    @Override
    public void setInitialValue(Object value) {
        if (value instanceof String) {
            Object item = this.getItem((String)value);
            if (item != null) {
                value = item;
            } else if (!this.isCustomEditable() && this.getIndexOfNullValue() < 0) {
                return;
            }
        }
        if (!this.hasItem(value) && !this.isCustomEditable()) {
            if (value == null) {
                value = this.getItemAt(0);
            } else {
                return;
            }
        }
        this.valueWhenGainedFocus = this.initialValue = value;
        this.selectionReminder = value;
    }

    private Object getItem(String stringValue) {
        Object item = this.getItemAt(this.getItemIndexFromString(stringValue));
        if (item == null && !this.isCustomEditable()) {
            item = this.getItemAt(this.getIndexOfNullValue());
        }
        return item;
    }

    public void setSelectAllOnFocus(boolean selectAllOnFocus) {
        if (this.isEditable() && this.getEditor() instanceof G9ComboBoxEditor) {
            ((G9ComboBoxEditor)this.getEditor()).setSelectAllOnFocus(selectAllOnFocus);
        }
    }

    public String getSelectedItemAsString() {
        String selection = null;
        selection = this.isEditable() ? ((JTextField)this.getEditor().getEditorComponent()).getText() : ((ComboBoxRenderer)this.getRenderer()).format(this.getSelectedItem());
        return selection;
    }

    @Deprecated
    public void setSelectedItemG9(Object value) {
        this.setSelectedItem(value);
    }

    public void addItem(Object anObject) {
        this.dontFire = true;
        super.addItem(anObject);
        this.reset();
        this.dontFire = false;
    }

    public void addItem(Collection<? extends Object> items) {
        if (!(this.getModel() instanceof MutableComboBoxModel)) {
            throw new G9BaseException("Cannot use this method with a non-Mutable data model.");
        }
        this.dontFire = true;
        ((G9ComboBoxModel)this.getModel()).addElements(items);
        this.reset();
        this.dontFire = false;
    }

    public void addAllItems(Collection<? extends Object> items) {
        this.addItem(items);
    }

    public void addItem(String enumTitle, Class<?> enumType) {
        String enumName = enumType.getName();
        Object anEnum = EnumUtil.getEnumObject((String)enumName, (String)enumTitle);
        this.addItem(anEnum);
    }

    public void setInputJustification(int justification) {
        ((G9TextField)this.getEditor().getEditorComponent()).setInputJustification(justification);
    }

    public void setOutputJustification(int outputJustification) {
        ((ComboBoxRenderer)this.getRenderer()).setHorizontalAlignment(outputJustification);
    }

    public void setHorizontalAlignment(int alignment) {
        ((ComboBoxRenderer)this.getRenderer()).setHorizontalAlignment(alignment);
    }

    public void setSorted(boolean isSorted) {
        ((G9ComboBoxModel)this.getModel()).setSorted(isSorted);
    }

    protected Object getDisplayValue(Object anObject) {
        return ((ComboBoxRenderer)this.getRenderer()).getDisplayValue(anObject);
    }

    @Override
    public void setEditable(boolean aFlag) {
        if (aFlag) {
            super.setEditable(aFlag);
            this.customEdit = aFlag;
        } else {
            super.setEditable(this.isSearchable);
            this.customEdit = aFlag;
        }
    }

    public int getNumberOfPossibleHits(String searchString, boolean caseSensitive) {
        int hitCount = 0;
        if (!caseSensitive) {
            searchString = searchString.toLowerCase();
        }
        for (int i = 0; i < this.getItemCount(); ++i) {
            String item = this.format(this.getItemAt(i));
            if (!caseSensitive && item != null) {
                item = item.toLowerCase();
            }
            if (item == null || !item.startsWith(searchString)) continue;
            ++hitCount;
        }
        return hitCount;
    }

    public boolean isSearchHit(String searchString) {
        boolean searchHit = false;
        for (int i = 0; i < this.getItemCount() && !searchHit; ++i) {
            String item = this.format(this.getItemAt(i));
            searchHit = item != null && item.equals(searchString) || item == null && (searchString == null || searchString.equals(""));
        }
        return searchHit;
    }

    public void setCaseSensitiveSearch(boolean aFlag) {
        this.caseSensitiveSearch = aFlag;
    }

    public boolean isCaseSenstitiveSearch() {
        return this.caseSensitiveSearch;
    }

    public void setSearchable(boolean searchable) {
        this.isSearchable = searchable;
        if (searchable) {
            super.setEditable(searchable);
        } else {
            this.setEditable(this.isCustomEditable());
        }
        this.isSearchable = searchable;
        JTextField textEditor = (JTextField)this.getEditor().getEditorComponent();
        if (searchable) {
            if (this.searchAgent == null) {
                this.searchAgent = new SearchAgent();
            }
            textEditor.addKeyListener(this.searchAgent);
        } else if (this.searchAgent != null) {
            textEditor.removeKeyListener(this.searchAgent);
        }
    }

    @Override
    public void setSelectedItem(Object anObject) {
        if (this.hasItem(anObject) || this.isCustomEditable()) {
            super.setSelectedItem(anObject);
            this.editor.setItem(anObject);
        }
    }

    private boolean hasItem(Object anObject) {
        if (anObject == null) {
            return this.getIndexOfNullValue() >= 0;
        }
        if (anObject instanceof String) {
            return this.getItemIndexFromString((String)anObject) >= 0;
        }
        return this.getIndexForItem(anObject) >= 0;
    }

    public boolean isSearchable() {
        return this.isSearchable;
    }

    public boolean isCustomEditable() {
        return this.customEdit;
    }

    public void addG9SelectionListener(G9SelectionListener listener) {
        this.listenerList.add(G9SelectionListener.class, listener);
    }

    private void maybeFireSelectedEvent() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int newIndex;
                int oldIndex;
                if (G9ComboBox.this.isPopupVisible() || G9ComboBox.this.dontFire) {
                    return;
                }
                if ((G9ComboBox.this.selectionReminder != null || G9ComboBox.this.getSelectedItem() != null) && (oldIndex = G9ComboBox.this.getIndexForItem(G9ComboBox.this.selectionReminder)) != (newIndex = G9ComboBox.this.getSelectedIndex())) {
                    G9ComboBox.this.fireG9SelectedEvent(oldIndex, newIndex);
                }
            }
        });
    }

    private int getIndexForItem(Object anItem) {
        int index = -1;
        for (int i = 0; i < this.getItemCount() && index == -1; ++i) {
            Object o = this.getItemAt(i);
            if (o == null || !o.equals(anItem)) continue;
            index = i;
        }
        return index;
    }

    public void fireG9SelectedEvent(int oldSelection, int newSelection) {
        this.selectionReminder = this.getSelectedItem();
        Object[] listeners = this.listenerList.getListenerList();
        G9SelectedEvent e = new G9SelectedEvent(this, oldSelection, newSelection);
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != G9SelectionListener.class) continue;
            ((G9SelectionListener)listeners[i + 1]).selectionChanged(e);
        }
    }

    public void setUsedAsListblockEditor(DefaultCellEditor tx) {
    }

    public void editingAboutToBegin() {
    }

    public boolean isDontFire() {
        return this.dontFire || this.isPopupVisible();
    }

    private class FocusManager
    extends FocusAdapter {
        private FocusManager() {
        }

        @Override
        public void focusLost(FocusEvent e) {
            String oldValue;
            if (this.menuOrToolbar(e.getOppositeComponent())) {
                return;
            }
            String currentValue = G9ComboBox.this.getSelectedItemAsString();
            if (!G9ComboBox.this.isCustomEditable() && G9ComboBox.this.isSearchable() && !G9ComboBox.this.isSearchHit(currentValue)) {
                G9ComboBox.this.setSelectedItem(G9ComboBox.this.valueWhenGainedFocus);
                G9ComboBox.this.getEditor().setItem(G9ComboBox.this.valueWhenGainedFocus);
                return;
            }
            if ("".equals(currentValue) && !G9ComboBox.this.isSearchHit(currentValue)) {
                currentValue = null;
            }
            if ((oldValue = G9ComboBox.this.format(G9ComboBox.this.valueWhenGainedFocus)) != null ^ currentValue != null || oldValue != null && !oldValue.equals(currentValue)) {
                G9ComboBox.this.fireG9ValueChangedEvent(2000, G9ComboBox.this.valueWhenGainedFocus, G9ComboBox.this.getSelectedItem());
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (this.menuOrToolbar(e.getOppositeComponent())) {
                return;
            }
            if (G9ComboBox.this.getItemCount() > 0) {
                G9ComboBox.this.valueWhenGainedFocus = G9ComboBox.this.getSelectedItem();
            } else if (G9ComboBox.this.isEditable()) {
                G9ComboBox.this.valueWhenGainedFocus = ((G9TextField)G9ComboBox.this.getEditor().getEditorComponent()).getValue();
            } else {
                G9ComboBox.this.valueWhenGainedFocus = null;
            }
            G9ComboBox.this.selectionReminder = G9ComboBox.this.valueWhenGainedFocus;
        }

        private boolean menuOrToolbar(Component opposite) {
            return opposite == null || opposite instanceof JRootPane || opposite instanceof G9Button && ((G9Button)opposite).isInToolbar();
        }
    }

    private class FocusWhenPopupManager
    extends FocusAdapter {
        private FocusWhenPopupManager() {
        }

        @Override
        public void focusLost(FocusEvent e) {
            int newSelection;
            if (this.menuOrToolbar(e.getOppositeComponent())) {
                return;
            }
            if (!G9ComboBox.this.isPopupVisible()) {
                return;
            }
            String currentValue = G9ComboBox.this.getSelectedItemAsString();
            if (!G9ComboBox.this.isCustomEditable() && G9ComboBox.this.isSearchable() && !G9ComboBox.this.isSearchHit(currentValue)) {
                G9ComboBox.this.setSelectedItem(G9ComboBox.this.selectionReminder);
                G9ComboBox.this.getEditor().setItem(G9ComboBox.this.selectionReminder);
                return;
            }
            int oldSelection = G9ComboBox.this.getIndexForItem(G9ComboBox.this.selectionReminder);
            if (oldSelection != (newSelection = G9ComboBox.this.getSelectedIndex())) {
                G9ComboBox.this.fireG9SelectedEvent(oldSelection, newSelection);
            }
        }

        private boolean menuOrToolbar(Component opposite) {
            return opposite == null || opposite instanceof JRootPane || opposite instanceof G9Button && ((G9Button)opposite).isInToolbar();
        }
    }

    private class SearchAgent
    extends KeyAdapter {
        protected JTextField editor;

        private SearchAgent() {
            this.editor = (JTextField)G9ComboBox.this.getEditor().getEditorComponent();
        }

        @Override
        public void keyPressed(KeyEvent e) {
            char ch = e.getKeyChar();
            if ((ch == '\uffff' || Character.isISOControl(ch) || e.getModifiers() != 0) && !this.isPopupTrigger(ch)) {
                return;
            }
            G9ComboBox.this.showPopup();
        }

        @Override
        public void keyReleased(KeyEvent e) {
            char ch = e.getKeyChar();
            if (ch == '\uffff' || Character.isISOControl(ch) || e.getModifiers() != 0 && this.editor.getText() != null && this.editor.getText().length() > 0) {
                return;
            }
            e.consume();
            this.search();
        }

        private boolean isPopupTrigger(char ch) {
            boolean isPopupTrigger = false;
            switch (ch) {
                case '\b': 
                case '\u007f': {
                    isPopupTrigger = true;
                    break;
                }
                default: {
                    isPopupTrigger = false;
                }
            }
            return isPopupTrigger;
        }

        public void search() {
            int pos = this.editor.getCaretPosition();
            String searchString = this.editor.getText();
            if (!G9ComboBox.this.isCustomEditable()) {
                searchString = this.getFirstHitSearchString(searchString);
            }
            if (searchString.length() == 0) {
                if (!G9ComboBox.this.isCustomEditable()) {
                    this.editor.setText("");
                    if (G9ComboBox.this.getItemIndexFromString(searchString) >= 0) {
                        G9ComboBox.this.setSelectedIndex(G9ComboBox.this.getItemIndexFromString(searchString));
                    }
                }
                return;
            }
            if (pos > searchString.length()) {
                pos = searchString.length();
            }
            for (int itemIndex = 0; itemIndex < G9ComboBox.this.getItemCount(); ++itemIndex) {
                String item = G9ComboBox.this.format(G9ComboBox.this.getItemAt(itemIndex));
                if (item == null || (!G9ComboBox.this.isCaseSenstitiveSearch() ? !item.toLowerCase().startsWith(searchString.toLowerCase()) : !item.startsWith(searchString))) continue;
                int currentSelection = G9ComboBox.this.getSelectedIndex();
                if (itemIndex != currentSelection) {
                    G9ComboBox.this.setSelectedIndex(itemIndex);
                }
                this.editor.setText(item);
                this.editor.setCaretPosition(item.length());
                this.editor.moveCaretPosition(pos);
                break;
            }
        }

        private String getFirstHitSearchString(String searchString) {
            if (!G9ComboBox.this.isCaseSenstitiveSearch()) {
                searchString = searchString.toLowerCase();
            }
            while (searchString.length() > 0) {
                for (int i = 0; i < G9ComboBox.this.getItemCount(); ++i) {
                    String item = G9ComboBox.this.format(G9ComboBox.this.getItemAt(i));
                    if (item == null) continue;
                    if (!G9ComboBox.this.isCaseSenstitiveSearch()) {
                        item = item.toLowerCase();
                    }
                    if (!item.startsWith(searchString)) continue;
                    return searchString;
                }
                searchString = searchString.substring(0, searchString.length() - 1);
            }
            return searchString;
        }
    }

    public class SelectionManager
    extends KeyAdapter
    implements JComboBox.KeySelectionManager {
        public int selectionForKey(char aKey, ComboBoxModel aModel) {
            String element;
            int i;
            if (aKey != '\uffff' && !Character.isISOControl(aKey)) {
                G9ComboBox.this.showPopup();
            }
            aKey = Character.toLowerCase(aKey);
            int currentSelection = -1;
            Object selectedItem = G9ComboBox.this.getModel().getSelectedItem();
            if (selectedItem != null) {
                for (i = 0; i < G9ComboBox.this.getModel().getSize(); ++i) {
                    if (selectedItem != G9ComboBox.this.getModel().getElementAt(i)) continue;
                    currentSelection = i;
                    break;
                }
            }
            for (i = currentSelection + 1; i < G9ComboBox.this.getModel().getSize(); ++i) {
                element = G9ComboBox.this.format(G9ComboBox.this.getModel().getElementAt(i));
                if (element == null || element.length() <= 0 || (element = element.toLowerCase()).charAt(0) != aKey) continue;
                return i;
            }
            for (i = 0; i < currentSelection; ++i) {
                element = G9ComboBox.this.format(G9ComboBox.this.getModel().getElementAt(i));
                if (element == null || element.length() <= 0 || (element = element.toLowerCase()).charAt(0) != aKey) continue;
                return i;
            }
            return -1;
        }
    }
}

