/*
 * Decompiled with CFR 0.152.
 */
package no.g9.client.component;

import java.awt.Container;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ListIterator;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.RootPaneContainer;
import no.g9.client.component.G9ButtonGroup;
import no.g9.client.event.G9ValueChangedListener;
import no.g9.client.event.G9ValueState;
import no.g9.client.support.DialogBlocker;

public class G9RadioButton
extends JRadioButton
implements G9ValueState {
    private G9ButtonGroup group;

    public G9RadioButton() {
        this(null, null, false);
    }

    public G9RadioButton(String text) {
        this(text, null, false);
    }

    public G9RadioButton(String text, boolean selected) {
        this(text, null, selected);
    }

    public G9RadioButton(Action a) {
        this();
        this.setAction(a);
    }

    public G9RadioButton(Icon icon) {
        this(null, icon, false);
    }

    public G9RadioButton(Icon icon, boolean selected) {
        this(null, icon, selected);
    }

    public G9RadioButton(String text, Icon icon) {
        this(text, icon, false);
    }

    public G9RadioButton(String text, Icon icon, boolean selected) {
        super(text, icon, selected);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                boolean wantEvent;
                Container parent;
                for (parent = G9RadioButton.this.getParent(); parent != null && !(parent instanceof RootPaneContainer); parent = parent.getParent()) {
                }
                boolean bl = wantEvent = DialogBlocker.isBlocked(parent) && G9RadioButton.this.getModel().isPressed() && G9RadioButton.this.contains(e.getPoint());
                if (wantEvent) {
                    G9RadioButton.this.doClick();
                }
            }
        });
    }

    public G9ButtonGroup getGroup() {
        return this.group;
    }

    void setGroup(G9ButtonGroup group) {
        this.group = group;
    }

    @Override
    public void setSelected(boolean selected) {
        super.setSelected(selected);
        if (this.group != null) {
            this.group.updateSelection();
        }
    }

    @Override
    public void addValueChangedListener(G9ValueChangedListener listener) {
        if (this.group != null) {
            this.group.addValueChangedListener(listener);
        }
    }

    @Override
    public void resetState() {
        if (this.group != null) {
            this.group.resetState();
        }
    }

    @Override
    public boolean isChanged() {
        if (this.group != null) {
            return this.group.isChanged();
        }
        return false;
    }

    @Override
    public void display(Object o) {
        if (this.group != null) {
            this.group.display(o);
        }
    }

    @Override
    public Object getInitialValue() {
        if (this.group != null) {
            return this.group.getInitialValue();
        }
        return null;
    }

    @Override
    public void setInitialValue(Object value) {
        if (this.group != null) {
            this.group.setInitialValue(value);
        }
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        super.processKeyEvent(e);
        if (e.getID() == 401 && (e.getKeyCode() == 39 || e.getKeyCode() == 40)) {
            this.setFocus(1);
            return;
        }
        if (e.getID() == 401 && (e.getKeyCode() == 37 || e.getKeyCode() == 38)) {
            this.setFocus(-1);
            return;
        }
    }

    private void setFocus(int move) {
        ArrayList<AbstractButton> l = Collections.list(this.group.getElements());
        ListIterator it = l.listIterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (o instanceof JComponent && ((JComponent)o).isShowing()) continue;
            it.remove();
        }
        int index = (l.indexOf(this) + move) % l.size();
        if (index < 0) {
            index += l.size();
        }
        ((JComponent)l.get(index)).requestFocus();
    }
}

