/*
 * Decompiled with CFR 0.152.
 */
package no.g9.client.component;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JTabbedPane;

public class G9TabPaneManager {
    private final JTabbedPane tabPane;
    private final List<String> tabTitles;
    private final List<Component> tabComponents;
    private final List<Icon> tabIcons;
    private final List<String> toolTips;

    public G9TabPaneManager(JTabbedPane tabPane) {
        this.tabPane = tabPane;
        this.tabTitles = Collections.unmodifiableList(this.getShownTitles());
        this.tabComponents = Collections.unmodifiableList(this.getShownTabs());
        this.tabIcons = Collections.unmodifiableList(this.getShownIcons());
        this.toolTips = Collections.unmodifiableList(this.getShownToolTips());
    }

    public void setVisible(Component tabComponent, boolean visible) {
        if (visible) {
            this.showTab(tabComponent);
        } else {
            this.hideTab(tabComponent);
        }
    }

    public void hideTab(Component tabComponent) {
        List<Component> shownTabs;
        int index;
        if (this.absoluteIndex(tabComponent) < 0) {
            this.throwEx(tabComponent);
        }
        if ((index = (shownTabs = this.getShownTabs()).indexOf(tabComponent)) >= 0) {
            this.tabPane.remove(index);
        }
    }

    public void showTab(Component tabComponent) {
        int tabIndex = this.absoluteIndex(tabComponent);
        if (tabIndex < 0) {
            this.throwEx(tabComponent);
        }
        if (this.getShownTabs().contains(tabComponent)) {
            return;
        }
        String title = this.tabTitles.get(tabIndex);
        Icon icon = this.tabIcons.get(tabIndex);
        String tip = this.toolTips.get(tabIndex);
        int insertIndex = this.getInsertIndex(tabComponent);
        this.tabPane.insertTab(title, icon, tabComponent, tip, insertIndex);
    }

    private List<Icon> getShownIcons() {
        int tabCount = this.tabPane.getTabCount();
        ArrayList<Icon> tmp = new ArrayList<Icon>();
        for (int i = 0; i < tabCount; ++i) {
            tmp.add(this.tabPane.getIconAt(i));
        }
        return tmp;
    }

    private List<String> getShownToolTips() {
        int tabCount = this.tabPane.getTabCount();
        ArrayList<String> tmp = new ArrayList<String>();
        for (int i = 0; i < tabCount; ++i) {
            tmp.add(this.tabPane.getToolTipTextAt(i));
        }
        return tmp;
    }

    private int absoluteIndex(Component tabComponent) {
        return tabComponent == null ? -1 : this.tabComponents.indexOf(tabComponent);
    }

    private void throwEx(Component component) {
        String msg = "Managed tab paned does not contain the component " + component;
        throw new RuntimeException(msg);
    }

    private List<String> getShownTitles() {
        int tabCount = this.tabPane.getTabCount();
        ArrayList<String> tmp = new ArrayList<String>();
        for (int i = 0; i < tabCount; ++i) {
            tmp.add(this.tabPane.getTitleAt(i));
        }
        return tmp;
    }

    private List<Component> getShownTabs() {
        return Arrays.asList(this.tabPane.getComponents());
    }

    private int getInsertIndex(Component tabComponent) {
        int absoluteIndex = this.absoluteIndex(tabComponent);
        if (absoluteIndex < 0) {
            this.throwEx(tabComponent);
        }
        Component[] shownTabs = this.getShownTabs().toArray(new Component[0]);
        for (int i = 0; i < shownTabs.length; ++i) {
            int currentShownIndex = this.absoluteIndex(shownTabs[i]);
            if (absoluteIndex >= currentShownIndex) continue;
            return i;
        }
        return shownTabs.length;
    }

    public String toString() {
        return "G9TabPaneManager tabTitles=" + this.tabTitles;
    }
}

