/*
 * Decompiled with CFR 0.152.
 */
package no.g9.client.component;

import java.awt.AWTEvent;
import java.awt.AWTKeyStroke;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.text.ParseException;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.EventListenerList;
import javax.swing.text.Document;
import no.g9.client.component.G9Button;
import no.g9.client.event.G9ValueChangedEvent;
import no.g9.client.event.G9ValueChangedListener;
import no.g9.client.event.G9ValueState;
import no.g9.client.support.EnumeratorDocument;
import no.g9.client.support.G9Document;
import no.g9.client.support.G9FieldValue;
import no.g9.exception.G9ClientFrameworkException;
import no.g9.message.DispatcherContext;
import no.g9.message.Message;
import no.g9.message.MessageSystem;
import no.g9.support.TypeTool;

public class G9TextArea
extends JTextArea
implements G9ValueState,
G9FieldValue {
    private Object oldVal;
    private Object initialValue;
    private boolean bugFix;
    private boolean editable = true;
    private boolean enabled = true;
    private boolean selectAllOnFocus = false;
    protected EventListenerList vcListeners = new EventListenerList();

    public G9TextArea() {
        this(null, null, 0, 0);
    }

    public G9TextArea(int rows, int columns) {
        this(null, null, rows, columns);
    }

    public G9TextArea(String text) {
        this(null, text, 0, 0);
    }

    public G9TextArea(String text, int rows, int columns) {
        this(null, text, rows, columns);
    }

    public G9TextArea(Document doc) {
        this(doc, null, 0, 0);
    }

    public G9TextArea(Document doc, String text, int rows, int columns) {
        super(doc, text, rows, columns);
        this.initialValue = text;
        this.setUpFocusTraversalKeys();
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                ((G9Document)G9TextArea.this.getDocument()).setInputMode(true);
                if (this.menuOrToolbar(e.getOppositeComponent())) {
                    return;
                }
                G9TextArea.this.oldVal = G9TextArea.this.getValue();
                if (G9TextArea.this.isSelectAllOnFocus()) {
                    G9TextArea.this.selectAll();
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (this.menuOrToolbar(e.getOppositeComponent())) {
                    return;
                }
                Object value = G9TextArea.this.getValue();
                if (G9TextArea.this.oldVal != null ^ value != null || G9TextArea.this.oldVal != null && !G9TextArea.this.oldVal.equals(value)) {
                    G9TextArea.this.fireG9ValueChangedEvent(2000, G9TextArea.this.oldVal, value);
                }
                ((G9Document)G9TextArea.this.getDocument()).setInputMode(false);
                G9TextArea.this.setCaretPosition(0);
            }

            private boolean menuOrToolbar(Component opposite) {
                return opposite == null || opposite instanceof JRootPane || opposite instanceof G9Button && ((G9Button)opposite).isInToolbar();
            }
        });
        this.editable = true;
        this.enabled = true;
        this.bugFix = TypeTool.isVmVersion1_4();
    }

    @Override
    public void addValueChangedListener(G9ValueChangedListener listener) {
        this.vcListeners.add(G9ValueChangedListener.class, listener);
    }

    protected void fireG9ValueChangedEvent(int id, Object oldValue, Object newValue) {
        Object[] listeners = this.vcListeners.getListenerList();
        AWTEvent e = null;
        block3: for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (e == null) {
                e = new G9ValueChangedEvent(this, id, oldValue, newValue);
            }
            if (listeners[i] != G9ValueChangedListener.class) continue;
            switch (e.getID()) {
                case 2000: {
                    ((G9ValueChangedListener)listeners[i + 1]).valueChanged((G9ValueChangedEvent)e);
                    continue block3;
                }
            }
        }
    }

    @Override
    public Object getValue() {
        Object value = null;
        Document doc = this.getDocument();
        if (doc instanceof G9Document) {
            G9Document gDoc = (G9Document)doc;
            value = gDoc.getValue();
        } else {
            value = this.getText();
        }
        return value;
    }

    @Override
    public void setValue(Object value) {
        Document doc = this.getDocument();
        if (doc instanceof G9Document) {
            ((G9Document)doc).setValue(value);
        } else {
            this.setText(String.valueOf(value));
        }
        this.setCaretPosition(0);
    }

    @Override
    public String format() {
        String str = "";
        Document doc = this.getDocument();
        if (doc instanceof G9Document) {
            G9Document gDoc = (G9Document)doc;
            str = gDoc.format();
        }
        return str;
    }

    @Override
    public Object parse(String formattedString) {
        Object o = formattedString;
        Document doc = this.getDocument();
        if (doc instanceof G9Document) {
            G9Document gDoc = (G9Document)doc;
            try {
                o = gDoc.parse(formattedString);
            }
            catch (ParseException e) {
                Object[] args = new Object[]{this.getClass(), this.getName(), formattedString};
                Message msg = MessageSystem.getMessageFactory().getMessage("-1514", args);
                MessageSystem.getMessageDispatcher((DispatcherContext)MessageSystem.NO_INTERACTION).dispatch(msg);
                throw new G9ClientFrameworkException((Throwable)e, msg);
            }
        }
        return o;
    }

    public Object parse(Object o) {
        return o;
    }

    @Override
    public void resetState() {
        this.initialValue = this.oldVal = this.getValue();
    }

    @Override
    public boolean isChanged() {
        if (this.initialValue == null && this.getValue() == null) {
            return false;
        }
        if (this.initialValue == null ^ this.getValue() == null) {
            return true;
        }
        Object formattedInitial = ((G9Document)this.getDocument()).transform(this.initialValue);
        Object formattedCurrent = ((G9Document)this.getDocument()).transform(this.getValue());
        return formattedCurrent == null ? formattedInitial != null : !formattedCurrent.equals(formattedInitial);
    }

    @Override
    public void setText(String t) {
        Document doc = this.getDocument();
        if (doc instanceof EnumeratorDocument) {
            this.setValue(((EnumeratorDocument)doc).toValue(t));
        } else {
            super.setText(t);
        }
    }

    @Override
    public void display(Object value) {
        Document doc = this.getDocument();
        if (doc instanceof EnumeratorDocument && value instanceof String) {
            value = ((EnumeratorDocument)doc).toValue(value);
        }
        this.setValue(value);
    }

    @Override
    public Object getInitialValue() {
        return this.initialValue;
    }

    @Override
    public void setInitialValue(Object value) {
        Document doc = this.getDocument();
        if (doc instanceof EnumeratorDocument && (value instanceof String || value instanceof Integer)) {
            value = ((EnumeratorDocument)doc).toValue(value);
        }
        this.oldVal = this.initialValue = value;
    }

    @Override
    public void setEnabled(boolean enable) {
        super.setEnabled(enable);
        if (!this.bugFix) {
            return;
        }
        this.enabled = enable;
        if (!enable || this.editable) {
            super.setEditable(enable);
        }
        if (enable) {
            this.setUpFocusTraversalKeys();
        }
    }

    @Override
    public void setEditable(boolean editable) {
        this.editable = editable;
        super.setEditable(editable);
        this.setEnabled(this.enabled);
    }

    @Override
    public void setVisible(boolean show) {
        Container parent;
        for (parent = this.getParent(); parent != null && !(parent instanceof JScrollPane); parent = parent.getParent()) {
        }
        if (parent != null) {
            parent.setVisible(show);
        } else {
            super.setVisible(show);
        }
    }

    public boolean isSelectAllOnFocus() {
        return this.selectAllOnFocus;
    }

    public void setSelectAllOnFocus(boolean selectAllOnFocus) {
        this.selectAllOnFocus = selectAllOnFocus;
    }

    private void setUpFocusTraversalKeys() {
        if (UIManager.getLookAndFeel().getID().equals("Windows")) {
            Set<AWTKeyStroke> unmodifiable = this.getFocusTraversalKeys(0);
            HashSet<AWTKeyStroke> forwardTraversalKeys = new HashSet<AWTKeyStroke>();
            KeyStroke tabKey = KeyStroke.getKeyStroke(9, 0);
            forwardTraversalKeys.add(tabKey);
            for (AWTKeyStroke o : unmodifiable) {
                forwardTraversalKeys.add(o);
            }
            this.setFocusTraversalKeys(0, forwardTraversalKeys);
            unmodifiable = this.getFocusTraversalKeys(1);
            HashSet<AWTKeyStroke> backwardTraversalKeys = new HashSet<AWTKeyStroke>();
            KeyStroke shiftTabKey = KeyStroke.getKeyStroke(9, 64);
            backwardTraversalKeys.add(shiftTabKey);
            for (AWTKeyStroke o : unmodifiable) {
                backwardTraversalKeys.add(o);
            }
            this.setFocusTraversalKeys(1, backwardTraversalKeys);
        }
    }
}

