/*
 * Decompiled with CFR 0.152.
 */
package no.g9.client.component.menu;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.util.List;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JInternalFrame;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import no.g9.client.component.G9DesktopPane;
import no.g9.client.component.menu.G9Menu;
import no.g9.client.component.menu.G9MenuItem;
import no.g9.support.Registry;

public class G9WindowMenu
extends G9Menu {
    private static final long serialVersionUID = 1L;
    protected JMenuItem cascadeItem;
    protected JMenuItem tileItem;
    protected JMenuItem toolBarItem;
    protected JMenuItem messageBarItem;
    private static List<G9MenuItem> defaultWindowMenuItems;
    private G9DesktopPane desktop;
    private boolean useIconsInWindowList = false;

    public G9WindowMenu(G9DesktopPane desktop) {
        this("", desktop);
    }

    public G9WindowMenu(String s, G9DesktopPane desktop) {
        super(s, 4);
        this.desktop = desktop;
        this.initDefaultItems();
    }

    public G9WindowMenu(String s, boolean b, G9DesktopPane desktop) {
        this("", desktop);
    }

    public G9WindowMenu(Action a, G9DesktopPane desktop) {
        this("", desktop);
        this.setAction(a);
    }

    private synchronized void initDefaultItems() {
        if (defaultWindowMenuItems == null && this.desktop != null) {
            defaultWindowMenuItems = new Vector<G9MenuItem>();
            defaultWindowMenuItems.add(G9WindowMenu.createMenuItem(this.desktop.getActionMap().get("Cascade"), null, "-1906"));
            defaultWindowMenuItems.add(G9WindowMenu.createMenuItem(this.desktop.getActionMap().get("Tile"), null, "-1905"));
        }
        this.setDefaultItem(defaultWindowMenuItems);
        Registry registry = Registry.getRegistry();
        String useIcons = registry.getProperty("menu.windowMenu.useIcons");
        this.setUseIconsInWindowList("true".equals(useIcons));
    }

    @Override
    protected synchronized void createMenuComponents() {
        super.createMenuComponents();
        if (this.desktop == null) {
            return;
        }
        JInternalFrame[] frames = this.desktop.getAllFrames();
        if (frames.length > 0) {
            this.add(new JSeparator());
            for (int i = 0; i < frames.length; ++i) {
                if (!frames[i].isVisible()) continue;
                FrameMenuItem menuItem = new FrameMenuItem(frames[i]);
                this.setColorAndFont(menuItem);
                menuItem.setSelected(frames[i].isSelected());
                menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        JInternalFrame frame = ((FrameMenuItem)e.getSource()).getFrame();
                        try {
                            if (frame.isIcon()) {
                                frame.setIcon(false);
                            }
                            frame.setSelected(true);
                        }
                        catch (PropertyVetoException e1) {
                            FrameMenuItem mi = (FrameMenuItem)e.getSource();
                            mi.setSelected(false);
                        }
                    }
                });
                if (this.isUseIconsInWindowList()) {
                    menuItem.setIcon(frames[i].getFrameIcon());
                }
                this.add(menuItem);
            }
        }
    }

    public synchronized boolean isUseIconsInWindowList() {
        return this.useIconsInWindowList;
    }

    public synchronized void setUseIconsInWindowList(boolean useIconsInWindowList) {
        this.useIconsInWindowList = useIconsInWindowList;
    }

    private static class FrameMenuItem
    extends JCheckBoxMenuItem {
        private static final long serialVersionUID = 1L;
        private JInternalFrame frame;

        public FrameMenuItem(JInternalFrame frame) {
            super(frame.getTitle());
            this.frame = frame;
        }

        public JInternalFrame getFrame() {
            return this.frame;
        }
    }
}

