/*
 * Decompiled with CFR 0.152.
 */
package no.g9.client.support;

import java.util.Comparator;
import java.util.List;

public abstract class AbstractAttributeComparator
implements Comparator,
Comparable {
    private int priority;
    private int direction;
    private int column;
    private String attributeName;
    private String directionString;
    private AbstractAttributeComparator next;
    public static final int ASCENDING = 1;
    public static final int DESCENDING = 2;

    public AbstractAttributeComparator(String attributeName, int column, int priority, int direction) {
        this.attributeName = attributeName;
        this.column = column;
        this.priority = priority;
        this.direction = direction;
        this.setDirectionString();
    }

    public int compareTo(Object o) {
        return this.compareTo((AbstractAttributeComparator)o);
    }

    public int compareTo(AbstractAttributeComparator another) {
        return this.priority - another.priority;
    }

    public static void chainComparators(List comparators) {
        if (comparators == null || comparators.size() == 0) {
            return;
        }
        AbstractAttributeComparator compA = null;
        for (AbstractAttributeComparator compB : comparators) {
            if (compA != null) {
                compA.next = compB;
            }
            compA = compB;
        }
        if (compA != null) {
            compA.next = null;
        }
    }

    public static AbstractAttributeComparator getComparator(List comparators, int column) {
        AbstractAttributeComparator result = null;
        for (AbstractAttributeComparator comp : comparators) {
            if (comp.getColumn() != column) continue;
            result = comp;
            break;
        }
        return result;
    }

    public AbstractAttributeComparator getNextComparator() {
        return this.next;
    }

    public void setNextComparator(AbstractAttributeComparator nextComparator) {
        this.next = nextComparator;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int direction) {
        this.direction = direction;
    }

    private void setDirectionString() {
        this.directionString = this.direction == 1 ? "ascending" : "descending";
    }

    public void toggleDirection() {
        this.direction = this.direction == 1 ? 2 : 1;
        this.setDirectionString();
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public String toString() {
        return this.attributeName + " " + this.directionString + " priority: " + this.priority + " column: " + this.column;
    }

    public int getColumn() {
        return this.column;
    }

    public void setColumn(int column) {
        this.column = column;
    }
}

