/*
 * Decompiled with CFR 0.152.
 */
package no.g9.client.support;

import java.awt.Color;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JInternalFrame;
import javax.swing.SwingUtilities;
import no.g9.client.event.G9ValueState;
import no.g9.client.support.Application;
import no.g9.client.support.ECheckResult;
import no.g9.client.support.ObjectSelectionNode;
import no.g9.client.support.RoleObject;
import no.g9.domain.DomainObjectProxy;
import no.g9.domain.DomainUtil;
import no.g9.exception.G9ClientException;
import no.g9.exception.G9ClientFrameworkException;
import no.g9.message.DispatcherContext;
import no.g9.message.Message;
import no.g9.message.MessageReply;
import no.g9.message.MessageReplyType;
import no.g9.message.MessageSystem;
import no.g9.support.TypeTool;
import no.g9.support.Visitor;

public abstract class AbstractNode<T>
implements ObjectSelectionNode {
    private int currentState = 0;
    private Integer stateOverride = null;
    protected DomainObjectProxy objectProxy;
    private Map roleNameToAssociation = new HashMap();

    @Override
    public Set getChangedNoKeyFields() {
        Set s = this.getChangedFields();
        s.removeAll(this.getChangedKeyFields());
        return s;
    }

    @Override
    public int setState(int state) {
        return this.setState(state, true);
    }

    protected void clearOnEDT() {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                AbstractNode.this.clear();
            }
        };
        this.edt(task, "clear");
    }

    protected void clearKeepKeysOnEDT() {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                AbstractNode.this.clearKeepKeys();
            }
        };
        this.edt(task, "clearKeepKeys");
    }

    protected void clearOnEDT(final String s) {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                AbstractNode.this.clear(s);
            }
        };
        this.edt(task, "clear " + s);
    }

    public abstract void append(T var1, String var2);

    protected void appendOnEDT(final T domainInstance, final String field) {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                AbstractNode.this.append(domainInstance, field);
            }
        };
        this.edt(task, "append " + field);
    }

    protected int setState(int state, boolean override) {
        this.stateOverride = override ? new Integer(state) : null;
        this.currentState = state;
        return this.getState();
    }

    @Override
    public int getState() {
        if (this.stateOverride != null) {
            return this.stateOverride;
        }
        Set s = this.getChangedFields();
        boolean altered = s.size() > 0;
        switch (this.currentState) {
            case 0: {
                if (!altered) break;
                this.currentState = 1;
                break;
            }
            case 1: {
                if (altered) break;
                this.currentState = 0;
                break;
            }
            case 2: {
                if (!altered) break;
                this.currentState = 3;
                break;
            }
            case 3: {
                if (altered) break;
                this.currentState = 2;
                break;
            }
        }
        return this.currentState;
    }

    public void recursiveDisplay(Collection domainObjectCollection) {
    }

    protected void displayOnEDT(final Object domainInstance) {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                AbstractNode.this.display(domainInstance);
            }
        };
        this.edt(task, "display " + domainInstance);
    }

    protected void displayOnEDT(final String attributeName, final Object value, final boolean resetState) {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                AbstractNode.this.display(attributeName, value, resetState);
            }
        };
        this.edt(task, "display " + attributeName + " " + value);
    }

    public abstract void display(String var1, Object var2, boolean var3);

    @Override
    public void displayOnEDT(final Collection resultObject, final List pathToTarget, final boolean findAll) {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                AbstractNode.this.displayAboveTarget(resultObject, pathToTarget, findAll);
            }
        };
        this.edt(task, "displayOnEDT");
    }

    @Override
    public abstract void displayAboveTarget(Collection var1, List var2, boolean var3);

    @Deprecated
    public Set obtainSet() {
        return this.obtainSet(true);
    }

    public abstract void display(T var1, String var2, boolean var3);

    protected void displayOnEDT(final T domainInstance, final String attributeName, final boolean resetState) {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                AbstractNode.this.display(domainInstance, attributeName, resetState);
            }
        };
        this.edt(task, "display");
    }

    protected void setFocusOnEDT(final String field) {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                AbstractNode.this.setFocus(field);
            }
        };
        this.edt(task, "setFocus " + field);
    }

    protected void setShownOnEDT(final boolean shown) {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                AbstractNode.this.setShown(shown);
            }
        };
        this.edt(task, "setShown");
    }

    protected void setShownOnEDT(final boolean shown, final String field) {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                AbstractNode.this.setShown(shown, field);
            }
        };
        this.edt(task, "setShown " + field);
    }

    protected void setEnabledOnEDT(final boolean enable, final String field) {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                AbstractNode.this.setEnabled(enable, field);
            }
        };
        this.edt(task, "setEnabled " + field);
    }

    protected void setEnabledOnEDT(final boolean enable) {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                AbstractNode.this.setEnabled(enable);
            }
        };
        this.edt(task, "setEnabled");
    }

    protected void setStyleOnEDT(final Color foreground, final Color background) {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                AbstractNode.this.setStyle(foreground, background);
            }
        };
        this.edt(task, "setStyle");
    }

    @Override
    public Set obtainSet(boolean createIfNull) {
        Set objectSet = TypeTool.getDefaultSet();
        objectSet.add(this.obtainAsObject());
        return objectSet;
    }

    public void nullProxy() {
        this.objectProxy = null;
        List related = this.getChildren();
        for (AbstractNode child : related) {
            child.nullProxy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean checkFind() {
        if (this.getController().ignoreCheckChanged()) {
            return true;
        }
        CheckFindTask cft = new CheckFindTask();
        if (!SwingUtilities.isEventDispatchThread()) {
            String msgID = null;
            Throwable throwable = null;
            try {
                SwingUtilities.invokeAndWait(cft);
                if (msgID == null) return cft.result;
            }
            catch (InterruptedException e) {
                msgID = "-1801";
                InterruptedException interruptedException = e;
                if (msgID == null) return cft.result;
                Object[] msgArgs = new Object[]{this.getClass(), "checkFind", interruptedException};
                Message msg = MessageSystem.getMessageFactory().getMessage(msgID, msgArgs);
                MessageSystem.getMessageDispatcher((DispatcherContext)MessageSystem.NO_INTERACTION).dispatch(msg);
                throw new G9ClientFrameworkException((Throwable)interruptedException, msg);
            }
            catch (InvocationTargetException e2) {
                void var3_7;
                msgID = "-1802";
                if (e2.getCause() != null && e2.getCause() instanceof Exception) {
                    Exception exception = (Exception)e2.getCause();
                } else {
                    InvocationTargetException invocationTargetException = e2;
                }
                if (msgID == null) return cft.result;
                {
                    catch (Throwable throwable2) {
                        if (msgID == null) throw throwable2;
                        Object[] msgArgs = new Object[]{this.getClass(), "checkFind", throwable};
                        Message msg = MessageSystem.getMessageFactory().getMessage(msgID, msgArgs);
                        MessageSystem.getMessageDispatcher((DispatcherContext)MessageSystem.NO_INTERACTION).dispatch(msg);
                        throw new G9ClientFrameworkException(throwable, msg);
                    }
                }
                Object[] msgArgs = new Object[]{this.getClass(), "checkFind", var3_7};
                Message msg = MessageSystem.getMessageFactory().getMessage(msgID, msgArgs);
                MessageSystem.getMessageDispatcher((DispatcherContext)MessageSystem.NO_INTERACTION).dispatch(msg);
                throw new G9ClientFrameworkException((Throwable)var3_7, msg);
            }
            Object[] msgArgs = new Object[]{this.getClass(), "checkFind", throwable};
            Message msg = MessageSystem.getMessageFactory().getMessage(msgID, msgArgs);
            MessageSystem.getMessageDispatcher((DispatcherContext)MessageSystem.NO_INTERACTION).dispatch(msg);
            throw new G9ClientFrameworkException(throwable, msg);
        }
        cft.result = cft.checkFind();
        return cft.result;
    }

    @Override
    public boolean checkRowSelection(int oldSelection, int newSelection) {
        return this.checkRowSelection(oldSelection, newSelection, null);
    }

    public boolean checkRowSelection(int oldSelection, int newSelection, Set foreignNodes) {
        if (this.getController().ignoreCheckChanged()) {
            return true;
        }
        ECheckResult cr = this.getController().callHookCheckRowSelect(this.getRoleName(), oldSelection, newSelection);
        boolean ok = true;
        if (cr == ECheckResult.CHANGED) {
            ok = false;
        } else if (cr == ECheckResult.DEFAULT) {
            ok = this.checkChanged();
        }
        if (ok && cr != ECheckResult.CONTINUE) {
            Iterator it;
            Iterator iterator = it = foreignNodes != null ? foreignNodes.iterator() : null;
            if (it != null) {
                while (ok && it.hasNext()) {
                    String foreignNodeName = (String)it.next();
                    AbstractNode foreignNode = (AbstractNode)this.getController().getObjectSelectionNode(foreignNodeName);
                    ok = foreignNode.checkChanged();
                }
            }
        }
        if (!ok) {
            String msgID = oldSelection == newSelection ? "-1606" : "-1605";
            Message message = MessageSystem.getMessageFactory().getMessage(msgID, new Object[0]);
            MessageReply reply = Application.getMessageDispatcher(this.getController().getWindow(), this.getController().getApplication()).dispatch(message);
            ok = MessageReplyType.REPLY_OK.equals((Object)reply);
        }
        return ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean checkPrint() {
        if (this.getController().ignoreCheckChanged()) {
            return true;
        }
        CheckPrintTask cpt = new CheckPrintTask();
        if (!SwingUtilities.isEventDispatchThread()) {
            String msgID = null;
            Object var3_3 = null;
            try {
                SwingUtilities.invokeAndWait(cpt);
                if (msgID == null) return cpt.result;
            }
            catch (InterruptedException e) {
                msgID = "-1801";
                InterruptedException interruptedException = e;
                if (msgID == null) return cpt.result;
                Object[] msgArgs = new Object[]{this.getClass(), "checkPrint", interruptedException};
                Message msg = MessageSystem.getMessageFactory().getMessage(msgID, msgArgs);
                MessageSystem.getMessageDispatcher((DispatcherContext)MessageSystem.NO_INTERACTION).dispatch(msg);
                return cpt.result;
            }
            catch (InvocationTargetException e2) {
                void var3_7;
                msgID = "-1802";
                if (e2.getCause() != null && e2.getCause() instanceof Exception) {
                    Exception exception = (Exception)e2.getCause();
                } else {
                    InvocationTargetException invocationTargetException = e2;
                }
                if (msgID == null) return cpt.result;
                {
                    catch (Throwable throwable) {
                        if (msgID == null) throw throwable;
                        Object[] msgArgs = new Object[]{this.getClass(), "checkPrint", var3_3};
                        Message msg = MessageSystem.getMessageFactory().getMessage(msgID, msgArgs);
                        MessageSystem.getMessageDispatcher((DispatcherContext)MessageSystem.NO_INTERACTION).dispatch(msg);
                        throw throwable;
                    }
                }
                Object[] msgArgs = new Object[]{this.getClass(), "checkPrint", var3_7};
                Message msg = MessageSystem.getMessageFactory().getMessage(msgID, msgArgs);
                MessageSystem.getMessageDispatcher((DispatcherContext)MessageSystem.NO_INTERACTION).dispatch(msg);
                return cpt.result;
            }
            Object[] msgArgs = new Object[]{this.getClass(), "checkPrint", var3_3};
            Message msg = MessageSystem.getMessageFactory().getMessage(msgID, msgArgs);
            MessageSystem.getMessageDispatcher((DispatcherContext)MessageSystem.NO_INTERACTION).dispatch(msg);
            return cpt.result;
        }
        cpt.result = cpt.checkPrint();
        return cpt.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean checkClose() {
        if (this.getController().ignoreCheckChanged()) {
            return true;
        }
        CheckCloseTask cct = new CheckCloseTask();
        if (!SwingUtilities.isEventDispatchThread()) {
            String msgID = null;
            Throwable throwable = null;
            try {
                SwingUtilities.invokeAndWait(cct);
                if (msgID == null) return cct.result;
            }
            catch (InterruptedException e) {
                msgID = "-1801";
                InterruptedException interruptedException = e;
                if (msgID == null) return cct.result;
                Object[] msgArgs = new Object[]{this.getClass(), "checkClose", interruptedException};
                Message msg = MessageSystem.getMessageFactory().getMessage(msgID, msgArgs);
                MessageSystem.getMessageDispatcher((DispatcherContext)MessageSystem.NO_INTERACTION).dispatch(msg);
                throw new G9ClientFrameworkException((Throwable)interruptedException, msg);
            }
            catch (InvocationTargetException e2) {
                void var3_7;
                msgID = "-1802";
                if (e2.getCause() != null && e2.getCause() instanceof Exception) {
                    Exception exception = (Exception)e2.getCause();
                } else {
                    InvocationTargetException invocationTargetException = e2;
                }
                if (msgID == null) return cct.result;
                {
                    catch (Throwable throwable2) {
                        if (msgID == null) throw throwable2;
                        Object[] msgArgs = new Object[]{this.getClass(), "checkClose", throwable};
                        Message msg = MessageSystem.getMessageFactory().getMessage(msgID, msgArgs);
                        MessageSystem.getMessageDispatcher((DispatcherContext)MessageSystem.NO_INTERACTION).dispatch(msg);
                        throw new G9ClientFrameworkException(throwable, msg);
                    }
                }
                Object[] msgArgs = new Object[]{this.getClass(), "checkClose", var3_7};
                Message msg = MessageSystem.getMessageFactory().getMessage(msgID, msgArgs);
                MessageSystem.getMessageDispatcher((DispatcherContext)MessageSystem.NO_INTERACTION).dispatch(msg);
                throw new G9ClientFrameworkException((Throwable)var3_7, msg);
            }
            Object[] msgArgs = new Object[]{this.getClass(), "checkClose", throwable};
            Message msg = MessageSystem.getMessageFactory().getMessage(msgID, msgArgs);
            MessageSystem.getMessageDispatcher((DispatcherContext)MessageSystem.NO_INTERACTION).dispatch(msg);
            throw new G9ClientFrameworkException(throwable, msg);
        }
        cct.result = cct.checkClose();
        return cct.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean checkDelete() {
        if (this.getController().ignoreCheckChanged()) {
            return true;
        }
        CheckDeleteTask cdt = new CheckDeleteTask(this);
        if (!SwingUtilities.isEventDispatchThread()) {
            String msgID = null;
            Throwable throwable = null;
            try {
                SwingUtilities.invokeAndWait(cdt);
                if (msgID == null) return cdt.result;
            }
            catch (InterruptedException e) {
                msgID = "-1801";
                InterruptedException interruptedException = e;
                if (msgID == null) return cdt.result;
                Object[] msgArgs = new Object[]{this.getClass(), "checkDelete", interruptedException};
                Message msg = MessageSystem.getMessageFactory().getMessage(msgID, msgArgs);
                MessageSystem.getMessageDispatcher((DispatcherContext)MessageSystem.NO_INTERACTION).dispatch(msg);
                throw new G9ClientFrameworkException((Throwable)interruptedException, msg);
            }
            catch (InvocationTargetException e2) {
                void var3_7;
                msgID = "-1802";
                if (e2.getCause() != null && e2.getCause() instanceof Exception) {
                    Exception exception = (Exception)e2.getCause();
                } else {
                    InvocationTargetException invocationTargetException = e2;
                }
                if (msgID == null) return cdt.result;
                {
                    catch (Throwable throwable2) {
                        if (msgID == null) throw throwable2;
                        Object[] msgArgs = new Object[]{this.getClass(), "checkDelete", throwable};
                        Message msg = MessageSystem.getMessageFactory().getMessage(msgID, msgArgs);
                        MessageSystem.getMessageDispatcher((DispatcherContext)MessageSystem.NO_INTERACTION).dispatch(msg);
                        throw new G9ClientFrameworkException(throwable, msg);
                    }
                }
                Object[] msgArgs = new Object[]{this.getClass(), "checkDelete", var3_7};
                Message msg = MessageSystem.getMessageFactory().getMessage(msgID, msgArgs);
                MessageSystem.getMessageDispatcher((DispatcherContext)MessageSystem.NO_INTERACTION).dispatch(msg);
                throw new G9ClientFrameworkException((Throwable)var3_7, msg);
            }
            Object[] msgArgs = new Object[]{this.getClass(), "checkDelete", throwable};
            Message msg = MessageSystem.getMessageFactory().getMessage(msgID, msgArgs);
            MessageSystem.getMessageDispatcher((DispatcherContext)MessageSystem.NO_INTERACTION).dispatch(msg);
            throw new G9ClientFrameworkException(throwable, msg);
        }
        cdt.result = cdt.checkDelete();
        return cdt.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean checkClear() {
        if (this.getController().ignoreCheckChanged()) {
            return true;
        }
        CheckClearTask cct = new CheckClearTask();
        if (!SwingUtilities.isEventDispatchThread()) {
            String msgID = null;
            Throwable throwable = null;
            try {
                SwingUtilities.invokeAndWait(cct);
                if (msgID == null) return cct.result;
            }
            catch (InterruptedException e) {
                msgID = "-1801";
                InterruptedException interruptedException = e;
                if (msgID == null) return cct.result;
                Object[] msgArgs = new Object[]{this.getClass(), "checkClear", interruptedException};
                Message msg = MessageSystem.getMessageFactory().getMessage(msgID, msgArgs);
                MessageSystem.getMessageDispatcher((DispatcherContext)MessageSystem.NO_INTERACTION).dispatch(msg);
                throw new G9ClientFrameworkException((Throwable)interruptedException, msg);
            }
            catch (InvocationTargetException e2) {
                void var3_7;
                msgID = "-1802";
                if (e2.getCause() != null && e2.getCause() instanceof Exception) {
                    Exception exception = (Exception)e2.getCause();
                } else {
                    InvocationTargetException invocationTargetException = e2;
                }
                if (msgID == null) return cct.result;
                {
                    catch (Throwable throwable2) {
                        if (msgID == null) throw throwable2;
                        Object[] msgArgs = new Object[]{this.getClass(), "checkClear", throwable};
                        Message msg = MessageSystem.getMessageFactory().getMessage(msgID, msgArgs);
                        MessageSystem.getMessageDispatcher((DispatcherContext)MessageSystem.NO_INTERACTION).dispatch(msg);
                        throw new G9ClientFrameworkException(throwable, msg);
                    }
                }
                Object[] msgArgs = new Object[]{this.getClass(), "checkClear", var3_7};
                Message msg = MessageSystem.getMessageFactory().getMessage(msgID, msgArgs);
                MessageSystem.getMessageDispatcher((DispatcherContext)MessageSystem.NO_INTERACTION).dispatch(msg);
                throw new G9ClientFrameworkException((Throwable)var3_7, msg);
            }
            Object[] msgArgs = new Object[]{this.getClass(), "checkClear", throwable};
            Message msg = MessageSystem.getMessageFactory().getMessage(msgID, msgArgs);
            MessageSystem.getMessageDispatcher((DispatcherContext)MessageSystem.NO_INTERACTION).dispatch(msg);
            throw new G9ClientFrameworkException(throwable, msg);
        }
        cct.result = cct.checkClear();
        return cct.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean checkSave() {
        if (this.getController().ignoreCheckChanged()) {
            return true;
        }
        CheckSaveTask cst = new CheckSaveTask(this);
        if (!SwingUtilities.isEventDispatchThread()) {
            String msgID = null;
            Throwable throwable = null;
            try {
                SwingUtilities.invokeAndWait(cst);
                if (msgID == null) return cst.result;
            }
            catch (InterruptedException e) {
                msgID = "-1801";
                InterruptedException interruptedException = e;
                if (msgID == null) return cst.result;
                Object[] msgArgs = new Object[]{this.getClass(), "checkSave", interruptedException};
                Message msg = MessageSystem.getMessageFactory().getMessage(msgID, msgArgs);
                MessageSystem.getMessageDispatcher((DispatcherContext)MessageSystem.NO_INTERACTION).dispatch(msg);
                throw new G9ClientFrameworkException((Throwable)interruptedException, msg);
            }
            catch (InvocationTargetException e2) {
                void var3_7;
                msgID = "-1802";
                if (e2.getCause() != null && e2.getCause() instanceof Exception) {
                    Exception exception = (Exception)e2.getCause();
                } else {
                    InvocationTargetException invocationTargetException = e2;
                }
                if (msgID == null) return cst.result;
                {
                    catch (Throwable throwable2) {
                        if (msgID == null) throw throwable2;
                        Object[] msgArgs = new Object[]{this.getClass(), "checkSave", throwable};
                        Message msg = MessageSystem.getMessageFactory().getMessage(msgID, msgArgs);
                        MessageSystem.getMessageDispatcher((DispatcherContext)MessageSystem.NO_INTERACTION).dispatch(msg);
                        throw new G9ClientFrameworkException(throwable, msg);
                    }
                }
                Object[] msgArgs = new Object[]{this.getClass(), "checkSave", var3_7};
                Message msg = MessageSystem.getMessageFactory().getMessage(msgID, msgArgs);
                MessageSystem.getMessageDispatcher((DispatcherContext)MessageSystem.NO_INTERACTION).dispatch(msg);
                throw new G9ClientFrameworkException((Throwable)var3_7, msg);
            }
            Object[] msgArgs = new Object[]{this.getClass(), "checkSave", throwable};
            Message msg = MessageSystem.getMessageFactory().getMessage(msgID, msgArgs);
            MessageSystem.getMessageDispatcher((DispatcherContext)MessageSystem.NO_INTERACTION).dispatch(msg);
            throw new G9ClientFrameworkException(throwable, msg);
        }
        cst.result = cst.checkSave();
        return cst.result;
    }

    @Override
    public boolean checkChanged() {
        return this.nodeCheckChange(false);
    }

    private boolean nodeCheckChange(boolean checkRelation) {
        if (this.getController().ignoreCheckChanged()) {
            return true;
        }
        ECheckResult rs = this.getController().callHookCheckChange(this.getRoleName());
        boolean ok = true;
        if (rs == ECheckResult.CHANGED) {
            return false;
        }
        if (rs == ECheckResult.UNCHANGED) {
            return true;
        }
        if (rs == ECheckResult.DEFAULT) {
            if (this.getRoleObject().isUpRelated()) {
                ok = this.getChangedNoKeyFields().size() == 0;
            } else {
                boolean bl = ok = this.getChangedFields().size() == 0;
            }
            if (!ok) {
                return false;
            }
            if (checkRelation) {
                ok = this.relationIntact();
            }
        }
        List related = this.getChildren();
        Iterator it = related.iterator();
        while (it.hasNext() && ok) {
            AbstractNode child = (AbstractNode)it.next();
            ok = child.nodeCheckChange(true);
        }
        return ok;
    }

    public boolean checkChangedAsChild() {
        return this.nodeCheckChange(true);
    }

    private RoleObject getRoleObject() {
        Object domainObject = this.getProxy().getObject();
        List roles = this.getController().getRoleObjects(domainObject);
        Iterator it = roles.iterator();
        RoleObject role = null;
        while (it.hasNext() && role == null) {
            RoleObject cur = (RoleObject)it.next();
            if (!cur.getRoleName().equals(this.getRoleName())) continue;
            role = cur;
        }
        return role;
    }

    private boolean relationIntact() {
        RoleObject currentRole = this.getRoleObject();
        if (!currentRole.isUpRelated()) {
            return true;
        }
        AbstractNode parentNode = (AbstractNode)this.getParentNode();
        if (parentNode == null || parentNode == this || parentNode.getState() == 0 || parentNode.getState() == 1) {
            return true;
        }
        RoleObject parentRole = parentNode.getRoleObject();
        Object parentObject = parentNode.getProxy().getObject();
        RoleObject.AssociationAccess associationAccess = parentRole.getAssociationAccess(currentRole);
        Object asumedChild = associationAccess.getAssociationOnType(parentObject);
        int originalHash = 0;
        if (asumedChild == null) {
            return this.getState() == 0;
        }
        originalHash = asumedChild.hashCode();
        this.obtainAsObject();
        int displayedHash = this.getProxy().getObject().hashCode();
        this.getProxy().reset();
        return originalHash == displayedHash;
    }

    public abstract Object getEmptyDomainObject();

    @Override
    public Object peekAtObject() {
        DomainObjectProxy tmpProxy = this.getController().getNewProxy(this.getEmptyDomainObject(), this.getRoleName());
        DomainObjectProxy oldProxy = this.objectProxy;
        this.objectProxy = tmpProxy;
        Object retVal = this.obtainAsObject();
        this.objectProxy = oldProxy;
        return retVal;
    }

    public DomainObjectProxy getProxy() {
        if (this.objectProxy == null) {
            this.objectProxy = this.getController().getNewProxy(this.getEmptyDomainObject(), this.getRoleName());
        }
        return this.objectProxy;
    }

    public abstract void display(String var1, Object var2);

    private void checkSaveListAboveTarget(List nodesToCheck, AbstractNode currentChild, boolean asUpRelated) {
        if (!asUpRelated && this.getParentNode() != null) {
            AbstractNode parent = (AbstractNode)this.getParentNode();
            parent.checkSaveListAboveTarget(nodesToCheck, this, false);
        }
        List children = this.getChildren();
        for (AbstractNode child : children) {
            if (child == currentChild || !child.getRoleObject().isUpRelated()) continue;
            child.checkSaveListAboveTarget(nodesToCheck, this, true);
        }
        nodesToCheck.add(this);
    }

    private void checkSaveListFromTarget(List nodesToCheck) {
        List childList = this.getChildren();
        for (AbstractNode child : childList) {
            if (!child.getRoleObject().isUpRelated()) continue;
            child.checkSaveListFromTarget(nodesToCheck);
        }
        nodesToCheck.add(this);
        for (AbstractNode child : childList) {
            if (child.getRoleObject().isUpRelated()) continue;
            child.checkSaveListFromTarget(nodesToCheck);
        }
    }

    @Override
    public List<AbstractNode> getPathToNode() {
        LinkedList<AbstractNode> path = this.getParentNode() != null ? this.getParentNode().getPathToNode() : new LinkedList<AbstractNode>();
        path.add(this);
        return path;
    }

    @Override
    public ObjectSelectionNode getRootNode() {
        if (this.getParentNode() != null) {
            return this.getParentNode().getRootNode();
        }
        return this;
    }

    public boolean isRootNode() {
        return this.getParentNode() == null;
    }

    public Set getAllChildNames() {
        HashSet<String> childrenNames = new HashSet<String>();
        Iterator childIterator = null;
        if (this.getChildren() != null) {
            childIterator = this.getChildren().iterator();
        }
        if (childIterator != null) {
            while (childIterator.hasNext()) {
                AbstractNode child = (AbstractNode)childIterator.next();
                childrenNames.add(child.getRoleName());
                childrenNames.addAll(child.getAllChildNames());
            }
        }
        return childrenNames;
    }

    public abstract void mergeAssociations(Object var1, List var2, boolean var3);

    protected void saveAssociation(String roleName, Object domainObject, Object association) {
        if (DomainUtil.isLazy((Object)association)) {
            return;
        }
        ObjectToAssociation newAssociation = new ObjectToAssociation(roleName, domainObject, association);
        HashMap keptAssociations = (HashMap)this.roleNameToAssociation.get(roleName);
        if (keptAssociations == null) {
            keptAssociations = new HashMap();
            this.roleNameToAssociation.put(roleName, keptAssociations);
        }
        keptAssociations.put(newAssociation, newAssociation);
    }

    protected Object getAssociation(String roleName, Object domainObject) {
        ObjectToAssociation objToAss;
        ObjectToAssociation key = new ObjectToAssociation(roleName, domainObject);
        Object association = null;
        Map keptAssociations = (Map)this.roleNameToAssociation.get(roleName);
        if (keptAssociations != null && (objToAss = (ObjectToAssociation)keptAssociations.get(key)) != null) {
            association = objToAss.getAssociation();
        }
        return association;
    }

    public void removeFromParent(Object root) {
        Object association = this.getAssociationToSelfFromParent(root);
        Object selfInstance = this.getSelfInstance(root);
        if (association instanceof Collection) {
            Collection collection = (Collection)association;
            collection.remove(selfInstance);
        }
    }

    public Map getRoleNameToAssociationMap() {
        return this.roleNameToAssociation;
    }

    protected void clearAllAssociation() {
        this.roleNameToAssociation.clear();
    }

    private Object getSelfInstance(Object root) {
        List<AbstractNode> pathToSelf = this.getPathToNode();
        Object selfInstance = AbstractNode.navigateToTarget(root, pathToSelf);
        return selfInstance;
    }

    private Object getAssociationToSelfFromParent(Object root) {
        AbstractNode parentNode = this.isRootNode() ? this : (AbstractNode)this.getParentNode();
        Object parentInstance = AbstractNode.navigateToTarget(root, parentNode.getPathToNode());
        Object association = parentNode.getAssociation(this.getRoleName(), parentInstance);
        return association;
    }

    private static Object navigateToTarget(Object root, List<AbstractNode> pathToTarget) {
        Object found = root;
        for (int i = 0; i < pathToTarget.size() - 1; ++i) {
            AbstractNode child;
            AbstractNode par = pathToTarget.get(i);
            RoleObject parentRole = par.getRoleObject();
            RoleObject.AssociationAccess associationAccess = parentRole.getAssociationAccess((child = pathToTarget.get(i + 1)).getRoleObject());
            found = associationAccess.getAssociationOnType(found);
            if (!(found instanceof Collection)) continue;
            Collection tmp = (Collection)found;
            if (tmp.size() != 1) {
                throw new G9ClientException("Can't navigate to target instance.");
            }
            found = tmp.iterator().next();
        }
        return found;
    }

    protected void addToAssociation(String roleName, Object domainObject, Set association) {
        Set keptAssociation = (Set)this.getAssociation(roleName, domainObject);
        if (keptAssociation != null) {
            keptAssociation.addAll(association);
        } else {
            this.saveAssociation(roleName, domainObject, association);
        }
    }

    public void resetAssociations(Object o) {
    }

    @Override
    public boolean isChanged(String attributeName) throws G9ClientException {
        String qualifiedAttributeName = TypeTool.addRoleNamePrefix((String)attributeName, (String)this.getRoleName());
        JComponent component = this.getController().getView().fromNameToComponent(qualifiedAttributeName);
        if (component instanceof G9ValueState) {
            G9ValueState stateComponent = (G9ValueState)((Object)component);
            return stateComponent.isChanged();
        }
        throw new G9ClientException("No such attribute: " + attributeName);
    }

    @Override
    public boolean inListblock() {
        return false;
    }

    protected abstract void setAssociation(Object var1, String var2, Object var3);

    public abstract boolean isNavigableToParent();

    @Override
    public Object greedyObtain() {
        if (this.inListblock()) {
            return this.obtainSet(false);
        }
        if (this.getState() == 0) {
            AbstractNode child;
            Iterator childIterator = this.getChildren().iterator();
            do {
                if (childIterator.hasNext()) continue;
                return null;
            } while ((child = (AbstractNode)childIterator.next()).getState() == 0);
        }
        Object self = this.obtainAsObject();
        List childrenList = this.getChildren();
        for (AbstractNode childNode : childrenList) {
            Object child = childNode.inListblock() ? childNode.obtainSet(false) : childNode.greedyObtain();
            this.setAssociation(self, childNode.getRoleName(), child);
            if (!childNode.isNavigableToParent()) continue;
            if (child instanceof Collection) {
                Iterator childIterator = ((Collection)child).iterator();
                while (childIterator.hasNext()) {
                    childNode.setAssociation(childIterator.next(), this.getRoleName(), self);
                }
                continue;
            }
            if (child == null) continue;
            childNode.setAssociation(child, this.getRoleName(), self);
        }
        return self;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void edt(Runnable task, String msgArg) {
        String msgID = null;
        Throwable throwable = null;
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(task);
                if (msgID == null) return;
            }
            catch (InterruptedException e) {
                msgID = "-1801";
                InterruptedException interruptedException = e;
                if (msgID == null) return;
                Object[] msgArgs = new Object[]{this.getClass(), msgArg, interruptedException};
                Message msg = MessageSystem.getMessageFactory().getMessage(msgID, msgArgs);
                MessageSystem.getMessageDispatcher((DispatcherContext)MessageSystem.NO_INTERACTION).dispatch(msg);
                throw new G9ClientFrameworkException((Throwable)interruptedException, msg);
            }
            catch (InvocationTargetException e2) {
                void var4_8;
                msgID = "-1802";
                if (e2.getCause() != null && e2.getCause() instanceof Exception) {
                    Exception exception = (Exception)e2.getCause();
                } else {
                    InvocationTargetException invocationTargetException = e2;
                }
                if (msgID == null) return;
                {
                    catch (Throwable throwable2) {
                        if (msgID == null) throw throwable2;
                        Object[] msgArgs = new Object[]{this.getClass(), msgArg, throwable};
                        Message msg = MessageSystem.getMessageFactory().getMessage(msgID, msgArgs);
                        MessageSystem.getMessageDispatcher((DispatcherContext)MessageSystem.NO_INTERACTION).dispatch(msg);
                        throw new G9ClientFrameworkException(throwable, msg);
                    }
                }
                Object[] msgArgs = new Object[]{this.getClass(), msgArg, var4_8};
                Message msg = MessageSystem.getMessageFactory().getMessage(msgID, msgArgs);
                MessageSystem.getMessageDispatcher((DispatcherContext)MessageSystem.NO_INTERACTION).dispatch(msg);
                throw new G9ClientFrameworkException((Throwable)var4_8, msg);
            }
            Object[] msgArgs = new Object[]{this.getClass(), msgArg, throwable};
            Message msg = MessageSystem.getMessageFactory().getMessage(msgID, msgArgs);
            MessageSystem.getMessageDispatcher((DispatcherContext)MessageSystem.NO_INTERACTION).dispatch(msg);
            throw new G9ClientFrameworkException(throwable, msg);
        }
        task.run();
    }

    public void accept(Visitor<ObjectSelectionNode> visitor) {
        visitor.visit((Object)this);
    }

    @Override
    public void visitBranch(Visitor<ObjectSelectionNode> visitor) {
        this.accept(visitor);
        List children = this.getChildren();
        for (ObjectSelectionNode child : children) {
            child.visitBranch(visitor);
        }
    }

    private class ObjectToAssociation<T> {
        private Object domainObject;
        private Object association;
        private String roleName;

        ObjectToAssociation(String roleName, Object domainObject, Object association) {
            this.roleName = roleName;
            this.domainObject = domainObject;
            if (association instanceof Set) {
                this.association = TypeTool.getDefaultSet();
                ((Set)this.association).addAll((Set)association);
            } else {
                this.association = association;
            }
        }

        ObjectToAssociation(String roleName, Object domainObject) {
            this(roleName, domainObject, null);
        }

        private Object getAssociation() {
            return this.association;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ObjectToAssociation)) {
                return false;
            }
            ObjectToAssociation other = (ObjectToAssociation)o;
            return this.domainObject.equals(other.domainObject);
        }

        public int hashCode() {
            return this.domainObject.hashCode();
        }

        public String toString() {
            return "ObjectToAssociation, hashCode(" + this.hashCode() + "): " + this.roleName;
        }
    }

    private class CheckSaveTask
    extends CheckSaveCommon
    implements Runnable {
        private boolean result;
        private AbstractNode target;

        CheckSaveTask(AbstractNode node) {
            this.target = node;
        }

        private boolean checkSave() {
            LinkedList nodesToCheck = new LinkedList();
            AbstractNode parent = (AbstractNode)AbstractNode.this.getParentNode();
            if (parent != null) {
                parent.checkSaveListAboveTarget(nodesToCheck, this.target, false);
            }
            AbstractNode.this.checkSaveListFromTarget(nodesToCheck);
            ECheckResult cr = this.doCheckSave(nodesToCheck);
            return cr != null && cr != ECheckResult.CHANGED;
        }

        @Override
        public void run() {
            this.result = this.checkSave();
        }
    }

    private class CheckClearTask
    implements Runnable {
        private boolean result;

        CheckClearTask() {
        }

        private boolean checkClear() {
            boolean ok = true;
            ECheckResult cr = AbstractNode.this.getController().callHookCheckClear(AbstractNode.this.getRoleName());
            if (cr == ECheckResult.CHANGED) {
                ok = false;
            } else if (cr == ECheckResult.DEFAULT) {
                ok = AbstractNode.this.checkChanged();
            }
            if (ok && cr != ECheckResult.UNCHANGED) {
                List children = AbstractNode.this.getChildren();
                Iterator it = children.iterator();
                while (it.hasNext() && ok) {
                    ok = ((AbstractNode)it.next()).checkChangedAsChild();
                }
            }
            if (!ok) {
                Message message = MessageSystem.getMessageFactory().getMessage("-1604", new Object[0]);
                MessageReply reply = Application.getMessageDispatcher(AbstractNode.this.getController().getWindow(), AbstractNode.this.getController().getApplication()).dispatch(message);
                ok = MessageReplyType.REPLY_OK.equals((Object)reply);
            }
            return ok;
        }

        @Override
        public void run() {
            this.result = this.checkClear();
        }
    }

    private class CheckDeleteTask
    extends CheckSaveCommon
    implements Runnable {
        private boolean result;
        private AbstractNode target;

        CheckDeleteTask(AbstractNode node) {
            this.target = node;
        }

        private boolean checkDelete() {
            ECheckResult cr;
            boolean ok = true;
            LinkedList nodesToCheck = new LinkedList();
            AbstractNode parent = (AbstractNode)AbstractNode.this.getParentNode();
            if (parent != null) {
                parent.checkSaveListAboveTarget(nodesToCheck, this.target, false);
            }
            boolean bl = ok = (cr = this.doCheckSave(nodesToCheck)) != null && cr != ECheckResult.CHANGED;
            if (!ok) {
                return false;
            }
            cr = AbstractNode.this.getController().callHookCheckDelete(AbstractNode.this.getRoleName());
            if (cr == ECheckResult.CHANGED) {
                ok = false;
            } else if (cr == ECheckResult.DEFAULT) {
                ok = AbstractNode.this.checkChanged();
            }
            if (ok && cr != ECheckResult.CONTINUE) {
                Iterator it = AbstractNode.this.getChildren().iterator();
                while (it.hasNext() && ok) {
                    ok = ((AbstractNode)it.next()).checkChangedAsChild();
                }
            }
            if (!ok) {
                Message message = MessageSystem.getMessageFactory().getMessage("-1603", new Object[0]);
                MessageReply reply = Application.getMessageDispatcher(AbstractNode.this.getController().getWindow(), AbstractNode.this.getController().getApplication()).dispatch(message);
                ok = MessageReplyType.REPLY_OK.equals((Object)reply);
            }
            return ok;
        }

        @Override
        public void run() {
            this.result = this.checkDelete();
        }
    }

    private class CheckSaveCommon {
        CheckSaveCommon() {
        }

        protected ECheckResult doCheckSave(List nodesToCheck) {
            ECheckResult cr = ECheckResult.DEFAULT;
            Iterator pIt = nodesToCheck.iterator();
            boolean continueCheck = true;
            while (pIt.hasNext() && continueCheck) {
                AbstractNode n = (AbstractNode)pIt.next();
                cr = AbstractNode.this.getController().callHookCheckSave(n.getRoleName());
                if (cr != ECheckResult.CHANGED && cr != ECheckResult.UNCHANGED) continue;
                continueCheck = false;
            }
            return cr;
        }
    }

    private class CheckCloseTask
    implements Runnable {
        private boolean result;

        CheckCloseTask() {
        }

        private boolean checkClose() {
            if (AbstractNode.this.getController().getWindow() instanceof JInternalFrame) {
                JInternalFrame fView = (JInternalFrame)AbstractNode.this.getController().getWindow();
                fView.toFront();
            } else if (AbstractNode.this.getController().getWindow() instanceof JDialog) {
                JDialog dView = (JDialog)AbstractNode.this.getController().getWindow();
                dView.toFront();
            }
            ECheckResult cr = AbstractNode.this.getController().callHookCheckClose(AbstractNode.this.getRoleName());
            boolean ok = true;
            if (cr == ECheckResult.CHANGED) {
                ok = false;
            } else if (cr == ECheckResult.DEFAULT) {
                ok = AbstractNode.this.checkChanged();
            }
            if (ok && cr != ECheckResult.UNCHANGED) {
                List children = AbstractNode.this.getChildren();
                Iterator it = children.iterator();
                while (it.hasNext() && ok) {
                    ok = ((AbstractNode)it.next()).checkChangedAsChild();
                }
            }
            return ok;
        }

        @Override
        public void run() {
            this.result = this.checkClose();
        }
    }

    private class CheckPrintTask
    implements Runnable {
        private boolean result;

        private CheckPrintTask() {
        }

        private boolean checkPrint() {
            ECheckResult checkResult = AbstractNode.this.getController().callHookCheckPrint(AbstractNode.this.getRoleName());
            boolean ok = true;
            if (checkResult == ECheckResult.CHANGED) {
                ok = false;
            } else if (checkResult == ECheckResult.DEFAULT) {
                ok = AbstractNode.this.checkChanged();
            }
            if (ok && checkResult != ECheckResult.UNCHANGED) {
                List children = AbstractNode.this.getChildren();
                Iterator it = children.iterator();
                while (it.hasNext() && ok) {
                    ok = ((AbstractNode)it.next()).checkChangedAsChild();
                }
            }
            return ok;
        }

        @Override
        public void run() {
            this.result = this.checkPrint();
        }
    }

    private class CheckFindTask
    implements Runnable {
        private boolean result;

        CheckFindTask() {
        }

        private boolean checkFind() {
            boolean ok = true;
            ECheckResult cr = AbstractNode.this.getController().callHookCheckFind(AbstractNode.this.getRoleName());
            if (cr == ECheckResult.CHANGED) {
                ok = false;
            } else if (cr == ECheckResult.DEFAULT) {
                boolean bl = ok = AbstractNode.this.getChangedNoKeyFields().size() == 0;
            }
            if (ok && cr != ECheckResult.UNCHANGED) {
                List related = AbstractNode.this.getChildren();
                Iterator it = related.iterator();
                while (it.hasNext() && ok) {
                    AbstractNode child = (AbstractNode)it.next();
                    ok = child.checkChangedAsChild();
                }
            }
            if (!ok) {
                Message message = MessageSystem.getMessageFactory().getMessage("-1601", new Object[0]);
                MessageReply reply = Application.getMessageDispatcher(AbstractNode.this.getController().getWindow(), AbstractNode.this.getController().getApplication()).dispatch(message);
                ok = MessageReplyType.REPLY_OK.equals((Object)reply);
            }
            return ok;
        }

        @Override
        public void run() {
            this.result = this.checkFind();
        }
    }
}

