/*
 * Decompiled with CFR 0.152.
 */
package no.g9.client.support;

import java.awt.Color;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import no.g9.client.component.G9ComboBox;
import no.g9.client.event.G9SelectedEvent;
import no.g9.client.event.G9SelectionListener;
import no.g9.client.event.G9VetoableSelectionEvent;
import no.g9.client.event.G9VetoableSelectionListener;
import no.g9.client.support.CellRenderOverride;
import no.g9.client.support.Listblock;
import no.g9.client.support.ToolTipHeader;
import no.g9.exception.G9ClientFrameworkException;
import no.g9.message.DispatcherContext;
import no.g9.message.Message;
import no.g9.message.MessageSystem;

public class G9Table
extends JTable {
    public String myStupidId = null;
    private Set editableCols = new HashSet();
    private boolean isBlocked = false;
    private long mouseReleasedTime = 0L;
    private Color changedColor;
    private CellRenderOverride cellRenderOverride = null;
    private Listblock listblock;
    HashSet addedFocusListener = new HashSet();
    private Map indexToColumn = new HashMap();
    private Map columnToWidth = new HashMap();

    public Listblock getListblock() {
        return this.listblock;
    }

    public void registerCellRenderOverride(CellRenderOverride renderOverride) {
        this.cellRenderOverride = renderOverride;
        renderOverride.setTable(this);
    }

    public CellRenderOverride getRenderOverride() {
        return this.cellRenderOverride;
    }

    public boolean isBlocked() {
        return this.isBlocked;
    }

    public void setBlocked(boolean isBlocked) {
        this.isBlocked = isBlocked;
        if (this.getTableHeader() instanceof ToolTipHeader) {
            ToolTipHeader header = (ToolTipHeader)this.getTableHeader();
            header.setBlocked(isBlocked);
        }
    }

    public G9Table(AbstractTableModel m, String id, Listblock listblock) {
        super(m);
        this.myStupidId = id;
        this.listblock = listblock;
        this.setAutoResizeMode(0);
        this.initFocusPolicy();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                G9Table.this.mouseReleasedTime = e.getWhen();
            }
        });
    }

    public boolean processDoubleClickMouseEvent(MouseEvent e) {
        int multiClickInterval = (Integer)this.getToolkit().getDesktopProperty("awt.multiClickInterval");
        boolean doProcessing = this.contains(e.getPoint());
        doProcessing = doProcessing && e.getID() == 500;
        doProcessing = doProcessing && e.getClickCount() == 2;
        boolean bl = doProcessing = e.getWhen() - this.mouseReleasedTime <= (long)multiClickInterval;
        if (doProcessing) {
            MouseEvent doubleClick = new MouseEvent(this, e.getID(), e.getWhen(), e.getModifiers(), e.getX(), e.getY(), e.getClickCount(), e.isPopupTrigger());
            this.processMouseEvent(doubleClick);
        }
        return doProcessing;
    }

    private void initFocusPolicy() {
        AbstractAction focusNextAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
            }
        };
        String focusNext = "FOCUS NEXT";
        KeyStroke tab = KeyStroke.getKeyStroke(9, 0);
        this.getInputMap(0).put(tab, focusNext);
        this.getActionMap().put(focusNext, focusNextAction);
        AbstractAction focusPreviousAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().focusPreviousComponent();
            }
        };
        String focusPrevious = "FOCUS PREVIOUS";
        KeyStroke shift_tab = KeyStroke.getKeyStroke(9, 64);
        this.getInputMap(0).put(shift_tab, focusPrevious);
        this.getActionMap().put(focusPrevious, focusPreviousAction);
    }

    public void setEditableCol(int col) {
        this.editableCols.add(new Integer(col));
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return super.isCellEditable(row, col);
    }

    public static void setBestFitColumnWidths(JTable table) {
        G9Table.setBestFitColumnWidths(table, -1);
    }

    public static void setBestFitColumnWidths(JTable table, int columnnumber) {
        JTableHeader header = table.getTableHeader();
        TableCellRenderer defaultHeaderRenderer = null;
        if (header != null) {
            defaultHeaderRenderer = header.getDefaultRenderer();
        }
        TableColumnModel columns = table.getColumnModel();
        TableModel data = table.getModel();
        int margin = columns.getColumnMargin();
        int rowCount = data.getRowCount();
        for (int col = columns.getColumnCount() - 1; col >= 0; --col) {
            TableColumn column = columns.getColumn(col);
            int columnIndex = column.getModelIndex();
            if (columnnumber > 0 && columnnumber != columnIndex) continue;
            int width = -1;
            TableCellRenderer h = column.getHeaderRenderer();
            if (h == null) {
                h = defaultHeaderRenderer;
            }
            if (h != null) {
                Component c = h.getTableCellRendererComponent(table, column.getHeaderValue(), false, false, -1, col);
                width = c.getPreferredSize().width;
            }
            for (int row = rowCount - 1; row >= 0; --row) {
                TableCellRenderer r = table.getCellRenderer(row, col);
                Component c = r.getTableCellRendererComponent(table, data.getValueAt(row, columnIndex), false, false, row, col);
                if (c.getPreferredSize().width <= width) continue;
                width = c.getPreferredSize().width;
            }
            if (width >= 0) {
                int finalWidth = width + margin + 5;
                column.setPreferredWidth(finalWidth);
                continue;
            }
            Object[] args = new Object[]{G9Table.class.getClass()};
            Message msg = MessageSystem.getMessageFactory().getMessage("-1511", args);
            MessageSystem.getMessageDispatcher((DispatcherContext)MessageSystem.NO_INTERACTION).dispatch(msg);
            throw new G9ClientFrameworkException(msg);
        }
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        TableColumn tableColumn = this.getColumnModel().getColumn(column);
        TableCellRenderer renderer = tableColumn.getCellRenderer();
        if (renderer == null) {
            Object o;
            Class<?> c = this.getColumnClass(column);
            if (c.equals(Object.class) && (o = this.getValueAt(row, column)) != null) {
                c = o.getClass();
            }
            renderer = this.getDefaultRenderer(c);
        }
        return renderer;
    }

    private void myAddListener(DefaultCellEditor edIn, Component edComp) {
        final DefaultCellEditor theEditor = edIn;
        final Component editorComponent = edComp;
        if (!this.addedFocusListener.contains(editorComponent)) {
            this.addedFocusListener.add(editorComponent);
            editorComponent.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    if (!(editorComponent instanceof JComboBox) || ((JComboBox)editorComponent).isEditable()) {
                        theEditor.stopCellEditing();
                    }
                }

                @Override
                public void focusGained(FocusEvent e) {
                    JComboBox box;
                    if (editorComponent instanceof JComboBox && !(box = (JComboBox)editorComponent).isPopupVisible()) {
                        box.setPopupVisible(true);
                    }
                }
            });
        }
    }

    @Override
    public TableCellEditor getCellEditor(int row, int column) {
        if (row < 0 || column < 0) {
            return null;
        }
        TableCellEditor x = super.getCellEditor(row, column);
        if (x instanceof DefaultCellEditor) {
            DefaultCellEditor tx = (DefaultCellEditor)x;
            if (tx.getComponent() instanceof G9ComboBox) {
                G9ComboBox source = (G9ComboBox)tx.getComponent();
                tx = new DefaultCellEditor(source);
                source.setUsedAsListblockEditor(tx);
                this.getSelectionModel().setSelectionInterval(row, row);
                source.editingAboutToBegin();
                this.myAddListener(tx, source);
                return tx;
            }
            this.myAddListener(tx, tx.getComponent());
        }
        return x;
    }

    @Override
    public boolean editCellAt(int row, int column) {
        Component editorComponent;
        boolean result = super.editCellAt(row, column);
        if (result && !(editorComponent = this.getEditorComponent()).isFocusOwner()) {
            editorComponent.requestFocus();
        }
        return result;
    }

    @Override
    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        if (10 == e.getKeyCode() || 27 == e.getKeyCode()) {
            return false;
        }
        return super.processKeyBinding(ks, e, condition, pressed);
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        if (this.isEnabled() && !this.isBlocked()) {
            super.processMouseEvent(e);
        }
    }

    @Override
    public void setEnabled(boolean enable) {
        if (this.isEnabled() == enable) {
            return;
        }
        super.setEnabled(enable);
        for (int col = 0; col < this.getColumnCount(); ++col) {
            TableColumn column = this.getColumnModel().getColumn(col);
            this.setEnableSafe(column.getHeaderRenderer(), enable);
            this.setEnableSafe(this.getCellRenderer(0, col), enable);
            this.setEnableSafe(this.getDefaultRenderer(Boolean.class), enable);
            this.repaint();
        }
    }

    private void setEnableSafe(TableCellRenderer renderer, boolean enable) {
        if (renderer instanceof JComponent) {
            ((JComponent)((Object)renderer)).setEnabled(enable);
        }
    }

    @Override
    public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
        int selectedRow = this.getSelectedRow();
        boolean veto = false;
        if (selectedRow != rowIndex || toggle) {
            veto = this.fireVetoableSelectionEvent(selectedRow, rowIndex);
            if (!veto) {
                super.changeSelection(rowIndex, columnIndex, toggle, extend);
                this.fireG9SelectedEvent(selectedRow, rowIndex);
            }
        } else {
            super.changeSelection(rowIndex, columnIndex, toggle, extend);
        }
    }

    @Override
    public void selectAll() {
        int rowIndex = this.getRowCount() - 1;
        int selectedRow = this.getSelectedRow();
        boolean veto = false;
        veto = this.fireVetoableSelectionEvent(selectedRow, rowIndex);
        if (!veto) {
            super.selectAll();
            this.fireG9SelectedEvent(selectedRow, rowIndex);
        }
    }

    public void addVetoableSelectionListener(G9VetoableSelectionListener listener) {
        this.listenerList.add(G9VetoableSelectionListener.class, listener);
    }

    protected boolean fireVetoableSelectionEvent(int oldRow, int newRow) {
        Object[] listeners = this.listenerList.getListenerList();
        G9VetoableSelectionEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != G9VetoableSelectionListener.class) continue;
            if (e == null) {
                e = new G9VetoableSelectionEvent(this, oldRow, newRow);
            }
            ((G9VetoableSelectionListener)listeners[i + 1]).vetoableSelectionChange(e);
        }
        return e != null ? e.isVetoed() : false;
    }

    public void addG9SelectionListener(G9SelectionListener listener) {
        this.listenerList.add(G9SelectionListener.class, listener);
    }

    public void fireG9SelectedEvent(int oldRow, int newRow) {
        Object[] listeners = this.listenerList.getListenerList();
        G9SelectedEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != G9SelectionListener.class) continue;
            if (e == null) {
                e = new G9SelectedEvent(this, oldRow, newRow);
            }
            ((G9SelectionListener)listeners[i + 1]).selectionChanged(e);
        }
    }

    public TableCellRenderer getTextRenderer(int alignment) {
        return new G9TextRenderer(alignment);
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    private void setColWidths(TableColumn column, ColWidths widths) {
        column.setMinWidth(widths.min);
        column.setMaxWidth(widths.max);
        column.setPreferredWidth(widths.pref);
        column.setWidth(widths.width);
    }

    private ColWidths getColWidths(TableColumn column) {
        return new ColWidths(column.getMinWidth(), column.getMaxWidth(), column.getPreferredWidth(), column.getWidth());
    }

    public void hideColumn(int columnIndex) {
        TableColumn column = this.getColumnModel().getColumn(columnIndex);
        if (column == null) {
            return;
        }
        Integer colIndex = new Integer(columnIndex);
        this.indexToColumn.put(colIndex, column);
        this.columnToWidth.put(column, this.getColWidths(column));
        this.setColWidths(column, new ColWidths());
        this.revalidate();
    }

    public void showColumn(int columnIndex) {
        TableColumn column = (TableColumn)this.indexToColumn.remove(new Integer(columnIndex));
        if (column == null) {
            return;
        }
        ColWidths widths = (ColWidths)this.columnToWidth.remove(column);
        this.setColWidths(column, widths);
    }

    public void setScrollPaneInUse(JScrollPane scrollPane) {
    }

    boolean isChanged(int row) {
        return this.listblock.getLine(row).isChanged();
    }

    public void setChangedLineColor(Color changedColor) {
        this.changedColor = changedColor;
    }

    public Color getChangedForgroundColor() {
        return this.changedColor;
    }

    public void setDefaultLineColor(Color defaultColor) {
    }

    private static class ColWidths {
        int min;
        int max;
        int pref;
        int width;

        ColWidths(int min, int max, int pref, int width) {
            this.min = min;
            this.max = max;
            this.pref = pref;
            this.width = width;
        }

        ColWidths() {
        }
    }

    static class G9TextRenderer
    extends DefaultTableCellRenderer {
        private int alignment;

        public G9TextRenderer(int alignment) {
            this.alignment = alignment;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setHorizontalAlignment(this.alignment);
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }
}

