/*
 * Decompiled with CFR 0.152.
 */
package no.g9.client.support;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import no.g9.client.support.AbstractNode;
import no.g9.client.support.Listblock;
import no.g9.domain.DomainUtil;
import no.g9.exception.G9ClientFrameworkException;
import no.g9.message.DispatcherContext;
import no.g9.message.Message;
import no.g9.message.MessageSystem;

public class RoleObject {
    private AbstractNode node;
    private String roleName;
    boolean visited = false;
    private Map associations = new HashMap();
    private AssociationAccess parentAssocciation = null;
    private Map listBlocks = new HashMap();
    private List simpleBlocks = new ArrayList();
    private boolean isUpRelated;
    protected static final int MIN_RELATION_TYPE = 1;
    protected static final int MAX_RELATION_TYPE = 4;
    public static final int ONE_RELATED = 1;
    public static final int ONE_IN_MORE_RELATED = 2;
    public static final int MORE_RELATED = 3;
    public static final int PARENT_RELATION = 4;

    public RoleObject(String roleName) {
        this.roleName = roleName;
    }

    public void setNode(AbstractNode node) {
        this.node = node;
    }

    public AbstractNode getNode() {
        return this.node;
    }

    public void addAssociation(Object associationRoleObject, String associationName, int associationType, boolean useAccessMethod, Class paramType) {
        AssociationAccess anAssociation = new AssociationAccess(associationName, associationType, useAccessMethod, paramType);
        if (associationType == 4) {
            this.parentAssocciation = anAssociation;
        } else {
            this.associations.put(associationRoleObject, anAssociation);
        }
    }

    public Object getParentDomainObject(Object childObject) {
        Object parentDomainObject = null;
        if (this.parentAssocciation != null) {
            parentDomainObject = this.parentAssocciation.getAssociationOnType(childObject);
        }
        return parentDomainObject;
    }

    public boolean hasLoopInAssociations() {
        this.visited = true;
        boolean loopFound = false;
        Iterator it = this.associations.keySet().iterator();
        while (it.hasNext() && !loopFound) {
            RoleObject aRoleObject = (RoleObject)it.next();
            if (!aRoleObject.visited && !aRoleObject.hasLoopInAssociations()) continue;
            loopFound = true;
        }
        this.visited = false;
        return loopFound;
    }

    public List getPathToRole(String targetRoleName) {
        ArrayList<RoleObject> path = new ArrayList<RoleObject>();
        if (this.getRoleName().equals(targetRoleName)) {
            path.add(this);
            return path;
        }
        for (RoleObject anAssociation : this.associations.keySet()) {
            List possiblePath = anAssociation.getPathToRole(targetRoleName);
            if (possiblePath == null) continue;
            path.add(this);
            path.addAll(possiblePath);
            return path;
        }
        return null;
    }

    public Set getAssociations(Object actualObject) {
        Iterator it = this.associations.values().iterator();
        HashSet<Set> associationSet = new HashSet<Set>();
        while (it.hasNext()) {
            AssociationAccess anAssosiation = (AssociationAccess)it.next();
            associationSet.add(anAssosiation.getAssociation(actualObject));
        }
        return associationSet;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public AssociationAccess getAssociationAccess(RoleObject associationRole) {
        return (AssociationAccess)this.associations.get(associationRole);
    }

    public Iterator getAssociationRoles() {
        return this.associations.keySet().iterator();
    }

    public void addListBlock(Object listBlock, Class[] params) {
        this.listBlocks.put(listBlock, params);
    }

    public Map getListBlocks() {
        return this.listBlocks;
    }

    public void addSimpleBlock(Object simpleBlock) {
        this.simpleBlocks.add(simpleBlock);
    }

    public List getSimpleBlocks() {
        return this.simpleBlocks;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RoleObject)) {
            return false;
        }
        return this.getRoleName().equals(((RoleObject)obj).getRoleName());
    }

    public int hashCode() {
        return this.getRoleName().hashCode();
    }

    public Class[] getListBlockParams(Object aListBlock) {
        return (Class[])this.listBlocks.get(aListBlock);
    }

    public List getListBlockArgs(Object domainObject, Class[] params) {
        HashSet<Class> paramSet = new HashSet<Class>();
        paramSet.addAll(Arrays.asList(params));
        return this.buildListBlockArgs(domainObject, paramSet);
    }

    private Class getSuperClassFromSet(Object domainObject, Set params) {
        Class domainClass = DomainUtil.getDomainClass((Object)domainObject);
        Class foundSuperClass = null;
        Iterator it = params.iterator();
        while (it.hasNext() && foundSuperClass == null) {
            Class possibleSuperClass = (Class)it.next();
            if (!possibleSuperClass.isAssignableFrom(domainClass)) continue;
            foundSuperClass = possibleSuperClass;
        }
        return foundSuperClass;
    }

    private List buildListBlockArgs(Object domainObject, Set params) {
        if (params.size() == 0) {
            return null;
        }
        ArrayList<Object> myAssociations = null;
        Class argClass = this.getSuperClassFromSet(domainObject, params);
        if (argClass != null) {
            myAssociations = new ArrayList<Object>();
            myAssociations.add(domainObject);
            params.remove(argClass);
        }
        for (RoleObject associatedRole : this.associations.keySet()) {
            AssociationAccess access = (AssociationAccess)this.associations.get(associatedRole);
            if (access.ASSOCIATION_TYPE == 3) continue;
            Set associationSet = access.getAssociation(domainObject);
            if (associationSet != null && associationSet.size() > 1) {
                Object[] args = new Object[]{this.getClass(), associatedRole.getRoleName()};
                Message msg = MessageSystem.getMessageFactory().getMessage("-1507", args);
                MessageSystem.getMessageDispatcher((DispatcherContext)MessageSystem.NO_INTERACTION).dispatch(msg);
                throw new G9ClientFrameworkException(msg);
            }
            Iterator tmpIt = null;
            if (associationSet != null) {
                tmpIt = associationSet.iterator();
            }
            Object associatedObject = null;
            List associationList = null;
            assert (associationSet != null);
            if (tmpIt != null && tmpIt.hasNext()) {
                associatedObject = associationSet.iterator().next();
                associationList = associatedRole.buildListBlockArgs(associatedObject, params);
            }
            if (associationList == null) continue;
            if (myAssociations == null) {
                myAssociations = new ArrayList();
            }
            myAssociations.addAll(associationList);
        }
        return myAssociations;
    }

    public void getListBlockArgs(Object actualObject, RoleObject roleObject, Listblock aListBlock, Class[] params, Object[] args, int curIndex) {
        if (DomainUtil.getDomainClass((Object)actualObject) == params[curIndex] && aListBlock.getRoleNamesInUse().contains(roleObject.getRoleName())) {
            args[curIndex++] = actualObject;
        }
        if (curIndex < args.length) {
            for (RoleObject anAssociation : this.associations.keySet()) {
                AssociationAccess associationAcces;
                Set argument;
                if (!aListBlock.getRoleNamesInUse().contains(anAssociation.getRoleName()) || (argument = (associationAcces = (AssociationAccess)this.associations.get(anAssociation)).getAssociation(actualObject)) == null || argument.size() != 1) continue;
                for (int i = curIndex; i < args.length; ++i) {
                    Object foundArgument = argument.iterator().next();
                    if (args[i] != null || params[i] != DomainUtil.getDomainClass(foundArgument)) continue;
                    args[i] = foundArgument;
                }
            }
        }
        if (curIndex < args.length) {
            for (RoleObject anAssociationRole : this.associations.keySet()) {
                AssociationAccess anAssociation = (AssociationAccess)this.associations.get(anAssociationRole);
                Set possiblePathToArumentsSet = anAssociation.getAssociation(actualObject);
                if (possiblePathToArumentsSet.size() != 1) continue;
                Object possiblePathToArgument = possiblePathToArumentsSet.iterator().next();
                this.getListBlockArgs(possiblePathToArgument, anAssociationRole, aListBlock, params, args, curIndex);
            }
        }
    }

    public boolean isUpRelated() {
        return this.isUpRelated;
    }

    public void setUpRelated(boolean isUpRelated) {
        this.isUpRelated = isUpRelated;
    }

    public class AssociationAccess {
        private boolean useAccessMethod;
        private Class[] param;
        private String associationName;
        private String getPrefix = "get";
        private String setPrefix = "set";
        private final int ASSOCIATION_TYPE;

        public AssociationAccess() {
            this.ASSOCIATION_TYPE = 0;
        }

        public AssociationAccess(String associationName, int associationType, boolean useAccessMethod, Class paramType) {
            if (associationType < 1 || associationType > 4) {
                Object[] args = new Object[]{this.getClass(), Integer.toString(associationType)};
                Message msg = MessageSystem.getMessageFactory().getMessage("-1508", args);
                MessageSystem.getMessageDispatcher((DispatcherContext)MessageSystem.NO_INTERACTION).dispatch(msg);
                throw new G9ClientFrameworkException(msg);
            }
            this.associationName = associationName;
            this.ASSOCIATION_TYPE = associationType;
            this.useAccessMethod = useAccessMethod;
            this.param = new Class[]{paramType};
        }

        public int getAssociationType() {
            return this.ASSOCIATION_TYPE;
        }

        public Set getAssociation(Object actualObject) {
            return this.useAccessMethod ? this.getAssociationUsingMethod(actualObject) : this.getAssociationUsingField(actualObject);
        }

        public void setAssociation(Object actualObject, Object associationValue) {
            if (this.useAccessMethod) {
                this.setAssociationUsingMethod(actualObject, associationValue);
            } else {
                this.setAssociationUsingField(actualObject, associationValue);
            }
        }

        public List obtainChangedLinesFromListBlock(Listblock theListBlock) {
            return theListBlock.obtainChangedLines();
        }

        public List obtainLinesFromListBlock(Listblock theListBlock) {
            return theListBlock.allLines();
        }

        public String getAssociationName() {
            return this.associationName;
        }

        public void setAssociationName(String associationName) {
            this.associationName = associationName;
        }

        public boolean isUseAccessMethod() {
            return this.useAccessMethod;
        }

        public void setUseAccessMethod(boolean useAccessMethod) {
            this.useAccessMethod = useAccessMethod;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(RoleObject.this.roleName + " {");
            for (RoleObject anAssociation : RoleObject.this.associations.keySet()) {
                if (anAssociation.hasLoopInAssociations()) {
                    sb.append("associative loop");
                } else {
                    sb.append(anAssociation);
                }
                sb.append(", ");
            }
            return sb.substring(0, sb.length() - 2) + "}";
        }

        private Set getAssociationUsingField(Object actualObject) {
            HashSet anAssociation = this.getAssociationTypeField(actualObject, this.associationName);
            if (!(anAssociation instanceof Set)) {
                HashSet tmp = new HashSet();
                if (anAssociation != null) {
                    tmp.add(anAssociation);
                }
                anAssociation = tmp;
            }
            return anAssociation;
        }

        private Set getAssociationUsingMethod(Object actualObject) {
            HashSet anAssociation = this.getAssociationOnTypeMethod(actualObject, this.associationName);
            if (!(anAssociation instanceof Set)) {
                HashSet tmp = new HashSet();
                if (anAssociation != null) {
                    tmp.add(anAssociation);
                }
                anAssociation = tmp;
            }
            return anAssociation;
        }

        private void setAssociationUsingMethod(Object actualObject, Object associationValue) {
            Object[] args = new Object[]{associationValue};
            ReflectiveOperationException ex = null;
            try {
                Method m = actualObject.getClass().getMethod(this.asSetMethod(this.associationName), this.param);
                m.setAccessible(true);
                m.invoke(actualObject, args);
            }
            catch (IllegalAccessException e) {
                ex = e;
            }
            catch (InvocationTargetException e) {
                ex = e;
            }
            catch (NoSuchMethodException e) {
                ex = e;
            }
            if (ex != null) {
                Object[] msgArgs = new Object[]{this.getClass(), this.asSetMethod(this.associationName) + "()", actualObject.getClass(), ex.getMessage()};
                Message msg = MessageSystem.getMessageFactory().getMessage("-1509", msgArgs);
                MessageSystem.getMessageDispatcher((DispatcherContext)MessageSystem.NO_INTERACTION).dispatch(msg);
                throw new G9ClientFrameworkException((Throwable)ex, msg);
            }
        }

        private void setAssociationUsingField(Object actualObject, Object associationValue) {
            ReflectiveOperationException ex = null;
            try {
                Field f = actualObject.getClass().getField(this.associationName);
                f.setAccessible(true);
                f.set(actualObject, associationValue);
            }
            catch (IllegalAccessException e) {
                ex = e;
            }
            catch (NoSuchFieldException e) {
                ex = e;
            }
            if (ex != null) {
                Object[] msgArgs = new Object[]{this.getClass(), this.associationName, actualObject.getClass(), ex.getMessage()};
                Message msg = MessageSystem.getMessageFactory().getMessage("-1509", msgArgs);
                MessageSystem.getMessageDispatcher((DispatcherContext)MessageSystem.NO_INTERACTION).dispatch(msg);
                throw new G9ClientFrameworkException((Throwable)ex, msg);
            }
        }

        private String asGetMethod(String name) {
            StringBuffer methodName = new StringBuffer(name);
            methodName.setCharAt(0, Character.toUpperCase(methodName.charAt(0)));
            return this.getPrefix + methodName.toString();
        }

        private String asSetMethod(String name) {
            StringBuffer methodName = new StringBuffer(name);
            methodName.setCharAt(0, Character.toUpperCase(methodName.charAt(0)));
            return this.setPrefix + methodName.toString();
        }

        public Object getAssociationOnType(Object fromObject) {
            if (this.associationName.contains(".")) {
                Object toObject = fromObject;
                for (String path : this.associationName.split("\\.")) {
                    toObject = this.useAccessMethod ? this.getAssociationOnTypeMethod(toObject, path) : this.getAssociationTypeField(toObject, path);
                }
                return toObject;
            }
            return this.useAccessMethod ? this.getAssociationOnTypeMethod(fromObject, this.associationName) : this.getAssociationTypeField(fromObject, this.associationName);
        }

        private Object getAssociationTypeField(Object actualObject, String assocName) {
            ReflectiveOperationException ex = null;
            try {
                Field f = actualObject.getClass().getField(assocName);
                f.setAccessible(true);
                return f.get(actualObject);
            }
            catch (IllegalAccessException e) {
                ex = e;
            }
            catch (NoSuchFieldException e) {
                ex = e;
            }
            Object[] msgArgs = new Object[]{this.getClass(), assocName, actualObject.getClass(), ex.getMessage()};
            Message msg = MessageSystem.getMessageFactory().getMessage("-1509", msgArgs);
            MessageSystem.getMessageDispatcher((DispatcherContext)MessageSystem.NO_INTERACTION).dispatch(msg);
            throw new G9ClientFrameworkException((Throwable)ex, msg);
        }

        private Object getAssociationOnTypeMethod(Object actualObject, String assocName) {
            ReflectiveOperationException ex = null;
            try {
                Method m = actualObject.getClass().getMethod(this.asGetMethod(assocName), null);
                m.setAccessible(true);
                return m.invoke(actualObject, (Object[])null);
            }
            catch (IllegalAccessException e) {
                ex = e;
            }
            catch (InvocationTargetException e) {
                ex = e;
            }
            catch (NoSuchMethodException e) {
                ex = e;
            }
            Object[] msgArgs = new Object[]{this.getClass(), this.asGetMethod(assocName) + "()", actualObject.getClass(), ex.getMessage()};
            Message msg = MessageSystem.getMessageFactory().getMessage("-1509", msgArgs);
            MessageSystem.getMessageDispatcher((DispatcherContext)MessageSystem.NO_INTERACTION).dispatch(msg);
            throw new G9ClientFrameworkException((Throwable)ex, msg);
        }
    }
}

