/*
 * Decompiled with CFR 0.152.
 */
package no.g9.client.support;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import no.esito.log.Logger;
import no.g9.client.support.G9Document;
import no.g9.support.FormatHelper;
import no.g9.support.TypeTool;

public class TextDocument
extends G9Document {
    private int caseConvertion = 0;

    public TextDocument(int datatype, String inputFormat, String outputFormat, int maxLength, int caseConvertion) {
        super(datatype, inputFormat, outputFormat, maxLength);
        this.caseConvertion = caseConvertion;
    }

    @Override
    public void insertString(int offset, String str, AttributeSet attr) throws BadLocationException {
        if (str == null) {
            return;
        }
        int maxLength = this.getMaxLength();
        if (maxLength > 0 && this.getLength() + str.length() > maxLength) {
            int newlen = maxLength - this.getLength();
            if (newlen <= 0) {
                return;
            }
            str = str.substring(0, newlen);
        }
        if (this.caseConvertion == -1) {
            str = str.toLowerCase(FormatHelper.getLocale());
        } else if (this.caseConvertion == 1) {
            str = str.toUpperCase(FormatHelper.getLocale());
        }
        super.insertString(offset, str, attr);
    }

    @Override
    public synchronized void setValue(Object value) {
        super.setValue(value);
        StringBuffer buf = new StringBuffer();
        if (value != null) {
            buf.append(value.toString());
        }
        try {
            String str = this.caseConvertion == -1 ? buf.toString().toLowerCase(FormatHelper.getLocale()) : (this.caseConvertion == 1 ? buf.toString().toUpperCase(FormatHelper.getLocale()) : buf.toString());
            this.replace(0, this.getLength(), str, null);
        }
        catch (BadLocationException e) {
            Logger.getLogger(TextDocument.class).warn((Object)"Failed to set value.", (Throwable)e);
        }
    }

    @Override
    public synchronized Object getValue() {
        Object result = super.getValue();
        if (this.getInputMode()) {
            String strValue = null;
            try {
                strValue = this.getText(0, this.getLength());
            }
            catch (BadLocationException e) {
                Logger.getLogger(TextDocument.class).warn((Object)"Failed to get value.", (Throwable)e);
            }
            if (strValue != null && (strValue.length() != 0 || result != null)) {
                strValue = TypeTool.stripEnd((String)strValue);
                if (this.caseConvertion == -1) {
                    strValue = strValue.toLowerCase(FormatHelper.getLocale());
                } else if (this.caseConvertion == 1) {
                    strValue = strValue.toUpperCase(FormatHelper.getLocale());
                }
                result = strValue;
            }
        }
        return result;
    }

    @Override
    public synchronized Object parse(String s) {
        return s;
    }

    private String toInternal(String s) {
        if (s != null) {
            s = TypeTool.stripEnd((String)s);
            if (this.getMaxLength() > 0 && s.length() > this.getMaxLength()) {
                s = s.substring(0, this.getMaxLength());
            }
            if (this.caseConvertion == -1) {
                s = s.toLowerCase(FormatHelper.getLocale());
            } else if (this.caseConvertion == 1) {
                s = s.toUpperCase(FormatHelper.getLocale());
            }
        }
        return s;
    }

    @Override
    public synchronized Object transform(Object o) {
        return this.toInternal((String)o);
    }

    @Override
    public synchronized String getOutputText() {
        return (String)this.transform(this.getValue());
    }
}

