/*
 * Decompiled with CFR 0.152.
 */
package no.finntech.lambdacompanion;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public abstract class Either<L, R> {
    public abstract boolean isLeft();

    public boolean isRight() {
        return !this.isLeft();
    }

    public LeftProjection<L, R> left() {
        return new LeftProjection(this);
    }

    public RightProjection<L, R> right() {
        return new RightProjection(this);
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public abstract String toString();

    public abstract <X> X fold(Function<L, X> var1, Function<R, X> var2);

    public abstract <X> Either<X, R> joinLeft(Function<L, Either<X, R>> var1);

    public abstract <X> Either<L, X> joinRight(Function<R, Either<L, X>> var1);

    public static <L, R> Either<L, R> left(L value) {
        return new Left(value);
    }

    public static <L, R> Either<L, R> right(R value) {
        return new Right(value);
    }

    private static final class Right<L, R>
    extends Either<L, R> {
        private final R value;

        @Override
        public boolean isLeft() {
            return false;
        }

        @Override
        public <X> X fold(Function<L, X> leftMapper, Function<R, X> rightMapper) {
            return rightMapper.apply(this.value);
        }

        @Override
        public <X> Either<X, R> joinLeft(Function<L, Either<X, R>> leftJoiner) {
            return Either.right(this.value);
        }

        @Override
        public <X> Either<L, X> joinRight(Function<R, Either<L, X>> rightJoiner) {
            return rightJoiner.apply(this.value);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Right right = (Right)o;
            return !(this.value != null ? !this.value.equals(right.value) : right.value != null);
        }

        @Override
        public int hashCode() {
            return this.value != null ? this.value.hashCode() : 0;
        }

        @Override
        public String toString() {
            return "Right(" + this.value + ")";
        }

        Right(R value) {
            this.value = value;
        }
    }

    private static final class Left<L, R>
    extends Either<L, R> {
        private final L value;

        Left(L value) {
            this.value = value;
        }

        @Override
        public boolean isLeft() {
            return true;
        }

        @Override
        public <X> X fold(Function<L, X> leftMapper, Function<R, X> rightMapper) {
            return leftMapper.apply(this.value);
        }

        @Override
        public <X> Either<X, R> joinLeft(Function<L, Either<X, R>> leftJoiner) {
            return leftJoiner.apply(this.value);
        }

        @Override
        public <X> Either<L, X> joinRight(Function<R, Either<L, X>> rightJoiner) {
            return Either.left(this.value);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Left left = (Left)o;
            return !(this.value != null ? !this.value.equals(left.value) : left.value != null);
        }

        @Override
        public int hashCode() {
            return this.value != null ? this.value.hashCode() : 0;
        }

        @Override
        public String toString() {
            return "Left(" + this.value + ")";
        }
    }

    public static final class RightProjection<L, R> {
        private final Either<L, R> either;

        RightProjection(Either<L, R> either) {
            this.either = either;
        }

        public <X> Either<L, X> map(Function<R, X> mapper) {
            return this.either.joinRight(right -> Either.right(mapper.apply(right)));
        }

        public Optional<Either<L, R>> filter(Predicate<R> predicate) {
            return this.either.fold(left -> Optional.empty(), right -> predicate.test(right) ? Optional.of(this.either) : Optional.empty());
        }

        public Either<L, R> peek(Consumer<? super R> consumer) {
            this.forEach(consumer);
            return this.either;
        }

        public void forEach(Consumer<? super R> consumer) {
            this.toOptional().ifPresent(consumer);
        }

        public Optional<R> toOptional() {
            return this.either.fold(left -> Optional.empty(), Optional::ofNullable);
        }

        public R orElse(R other) {
            return (R)this.either.fold(left -> other, Function.identity());
        }

        public R orElseGet(Supplier<R> supplier) {
            return (R)this.either.fold(left -> supplier.get(), Function.identity());
        }

        public <X extends Throwable> R orElseThrow(Function<L, X> exceptionMapper) throws X {
            return this.either.right().toOptional().orElseThrow(() -> (Throwable)exceptionMapper.apply(this.either.left().toOptional().get()));
        }
    }

    public static final class LeftProjection<L, R> {
        private final Either<L, R> either;

        LeftProjection(Either<L, R> either) {
            this.either = either;
        }

        public <X> Either<X, R> map(Function<L, X> mapper) {
            return this.either.joinLeft(left -> Either.left(mapper.apply(left)));
        }

        public Optional<Either<L, R>> filter(Predicate<L> predicate) {
            return this.either.fold(left -> predicate.test(left) ? Optional.of(this.either) : Optional.empty(), right -> Optional.empty());
        }

        public Either<L, R> peek(Consumer<? super L> consumer) {
            this.forEach(consumer);
            return this.either;
        }

        public void forEach(Consumer<? super L> consumer) {
            this.toOptional().ifPresent(consumer);
        }

        public Optional<L> toOptional() {
            return this.either.fold(Optional::ofNullable, right -> Optional.empty());
        }

        public L orElse(L other) {
            return (L)this.either.fold(Function.identity(), right -> other);
        }

        public L orElseGet(Supplier<L> supplier) {
            return (L)this.either.fold(Function.identity(), right -> supplier.get());
        }

        public <X extends Throwable> L orElseThrow(Function<R, X> exceptionMapper) throws X {
            return this.either.left().toOptional().orElseThrow(() -> (Throwable)exceptionMapper.apply(this.either.right().toOptional().get()));
        }
    }
}

