/*
 * Decompiled with CFR 0.152.
 */
package no.finntech.lambdacompanion;

import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import no.finntech.lambdacompanion.Either;

public final class Pair<L, R> {
    private final L left;
    private final R right;

    public Pair(L left, R right) {
        this.left = left;
        this.right = right;
    }

    public L getLeft() {
        return this.left;
    }

    public R getRight() {
        return this.right;
    }

    public Map.Entry<L, R> toMapEntry() {
        return new AbstractMap.SimpleEntry<L, R>(this.left, this.right);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pair pair = (Pair)o;
        if (this.left != null ? !this.left.equals(pair.left) : pair.left != null) {
            return false;
        }
        return !(this.right != null ? !this.right.equals(pair.right) : pair.right != null);
    }

    public int hashCode() {
        int result = this.left != null ? this.left.hashCode() : 0;
        result = 31 * result + (this.right != null ? this.right.hashCode() : 0);
        return result;
    }

    public static <L, R> Pair<List<L>, List<R>> of(List<Either<L, R>> collection) {
        return new Pair<List<L>, List<R>>(collection.stream().flatMap(cat -> cat.left().map(Stream::of).left().orElseGet(Stream::empty)).collect(Collectors.toList()), collection.stream().flatMap(cat -> cat.right().map(Stream::of).right().orElseGet(Stream::empty)).collect(Collectors.toList()));
    }

    public static <K, U> Collector<Pair<K, U>, ?, Map<K, U>> toMap() {
        return Collectors.toMap(Pair::getLeft, Pair::getRight);
    }
}

