/*
 * Decompiled with CFR 0.152.
 */
package no.finntech.lambdacompanion;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class StreamableOptional<T> {
    private static final StreamableOptional<?> EMPTY = new StreamableOptional(Optional.empty());
    private final Optional<T> optional;

    private StreamableOptional(Optional<T> optional) {
        this.optional = optional;
    }

    public void ifPresent(Consumer<? super T> consumer) {
        this.optional.ifPresent(consumer);
    }

    public StreamableOptional<T> filter(Predicate<? super T> predicate) {
        return this.optional.filter(predicate).map(present -> this).orElse(StreamableOptional.empty());
    }

    public <U> StreamableOptional<U> map(Function<? super T, ? extends U> mapper) {
        return this.optional.map(mapper).map(StreamableOptional::of).orElse(StreamableOptional.empty());
    }

    public <U> StreamableOptional<U> flatMap(Function<? super T, StreamableOptional<U>> mapper) {
        return this.optional.map(present -> (StreamableOptional)Objects.requireNonNull(mapper.apply(present))).orElse(StreamableOptional.empty());
    }

    public T orElse(T other) {
        return this.optional.orElse(other);
    }

    public T orElseGet(Supplier<? extends T> other) {
        return this.optional.orElseGet(other);
    }

    public <X extends Throwable> T orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
        return this.optional.orElseThrow(exceptionSupplier);
    }

    public Stream<T> stream() {
        return this.optional.map(Stream::of).orElseGet(Stream::empty);
    }

    public Optional<T> toOptional() {
        return this.optional;
    }

    public static <T> StreamableOptional<T> of(T value) {
        return StreamableOptional.ofOptional(Optional.of(value));
    }

    public static <T> StreamableOptional<T> ofNullable(T value) {
        return StreamableOptional.ofOptional(Optional.ofNullable(value));
    }

    public static <T> StreamableOptional<T> ofOptional(Optional<T> optional) {
        Objects.requireNonNull(optional);
        if (!optional.isPresent()) {
            return StreamableOptional.empty();
        }
        return new StreamableOptional<T>(optional);
    }

    public static <T> StreamableOptional<T> empty() {
        return EMPTY;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StreamableOptional that = (StreamableOptional)o;
        return this.optional.equals(that.optional);
    }

    public int hashCode() {
        return this.optional.hashCode();
    }
}

