/*
 * Decompiled with CFR 0.152.
 */
package no.finntech.lambdacompanion;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import no.finntech.lambdacompanion.Either;
import no.finntech.lambdacompanion.Failure;
import no.finntech.lambdacompanion.Success;
import no.finntech.lambdacompanion.ThrowingBiFunction;
import no.finntech.lambdacompanion.ThrowingConsumer;
import no.finntech.lambdacompanion.ThrowingFunction;
import no.finntech.lambdacompanion.ThrowingSupplier;

public abstract class Try<T> {
    public abstract <U> Try<U> map(ThrowingFunction<? super T, ? extends U, ? extends Throwable> var1);

    public abstract <U> Try<U> flatMap(ThrowingFunction<? super T, ? extends Try<U>, ? extends Throwable> var1);

    public abstract void forEach(ThrowingConsumer<? super T, ? extends Throwable> var1);

    public abstract Try<T> peek(ThrowingConsumer<? super T, ? extends Throwable> var1);

    public abstract Try<T> peekFailure(Consumer<Failure<T>> var1);

    public abstract T orElse(T var1);

    public abstract T orElseGet(Supplier<? extends T> var1);

    public abstract <U> U recover(Function<? super T, ? extends U> var1, Function<Throwable, ? extends U> var2);

    public abstract Optional<T> toOptional();

    public abstract <X extends Throwable> Either<X, T> toEither();

    public abstract <X extends Throwable, Y extends Throwable> T orElseThrow(Function<X, Y> var1) throws Y;

    public abstract <E extends Throwable> T orElseRethrow() throws E;

    public static <U, V> Try<U> of(ThrowingFunction<V, ? extends U, ? extends Throwable> func, V v) {
        try {
            return new Success<U>(func.apply(v));
        }
        catch (Throwable e) {
            return new Failure(e);
        }
    }

    public static <U, V, W> Try<U> of(ThrowingBiFunction<V, W, ? extends U, ? extends Throwable> func, V v, W w) {
        try {
            return new Success<U>(func.apply(v, w));
        }
        catch (Throwable e) {
            return new Failure(e);
        }
    }

    public static <U> Try<U> of(ThrowingSupplier<U, ? extends Throwable> supplier) {
        try {
            return new Success<U>(supplier.get());
        }
        catch (Throwable e) {
            return new Failure(e);
        }
    }

    public static <U> Try<U> failure(Throwable throwable) {
        return new Failure(throwable);
    }
}

