/*
 * Decompiled with CFR 0.152.
 */
package no.finn.lambdacompanion;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import no.finn.lambdacompanion.Either;
import no.finn.lambdacompanion.Failure;
import no.finn.lambdacompanion.ThrowingConsumer;
import no.finn.lambdacompanion.ThrowingFunction;
import no.finn.lambdacompanion.Try;

public class Success<T>
extends Try<T> {
    private T t;

    public Success(T t) {
        this.t = t;
    }

    @Override
    public <U> Try<U> map(ThrowingFunction<? super T, ? extends U, ? extends Exception> mapper) {
        try {
            return new Success<U>(mapper.apply(this.t));
        }
        catch (Exception e) {
            return new Failure(e);
        }
    }

    @Override
    public <U> Try<U> flatMap(ThrowingFunction<? super T, ? extends Try<U>, ? extends Exception> mapper) {
        try {
            return mapper.apply(this.t);
        }
        catch (Exception e) {
            return new Failure(e);
        }
    }

    @Override
    public Optional<Try<T>> filter(Predicate<T> predicate) {
        Objects.requireNonNull(predicate);
        if (predicate.test(this.t)) {
            return Optional.of(this);
        }
        return Optional.empty();
    }

    @Override
    public void forEach(ThrowingConsumer<? super T, ? extends Exception> consumer) {
        try {
            consumer.accept(this.t);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Try<T> peek(ThrowingConsumer<? super T, ? extends Exception> consumer) {
        this.forEach(consumer);
        return this;
    }

    @Override
    public Try<T> peekFailure(Consumer<Failure<T>> consumer) {
        return this;
    }

    @Override
    public T orElse(T defaultValue) {
        return this.t;
    }

    @Override
    public T orElseGet(Supplier<? extends T> defaultValue) {
        return this.t;
    }

    @Override
    public Optional<T> toOptional() {
        return Optional.ofNullable(this.t);
    }

    @Override
    public <U> U recover(Function<? super T, ? extends U> successFunc, Function<Exception, ? extends U> failureFunc) {
        return successFunc.apply(this.t);
    }

    @Override
    public Either<? extends Exception, T> toEither() {
        return Either.right(this.t);
    }

    @Override
    public <X extends Exception, Y extends Exception> T orElseThrow(Function<X, Y> ExceptionMapper) throws Y {
        return this.t;
    }

    @Override
    public <E extends Exception> T orElseRethrow() throws E {
        return this.t;
    }

    public String toString() {
        return "Success{t=" + this.t + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Success success = (Success)o;
        return !(this.t == null ? success.t != null : !this.t.equals(success.t));
    }

    public int hashCode() {
        return this.t != null ? this.t.hashCode() : 0;
    }
}

