/*
 * Decompiled with CFR 0.152.
 */
package no.finn.lambdacompanion;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import no.finn.lambdacompanion.Either;
import no.finn.lambdacompanion.Failure;
import no.finn.lambdacompanion.Functions;
import no.finn.lambdacompanion.Success;
import no.finn.lambdacompanion.ThrowingBiFunction;
import no.finn.lambdacompanion.ThrowingConsumer;
import no.finn.lambdacompanion.ThrowingFunction;
import no.finn.lambdacompanion.ThrowingSupplier;
import no.finn.lambdacompanion.ThrowingVoidSupplier;

public abstract class Try<T> {
    public abstract <U> Try<U> map(ThrowingFunction<? super T, ? extends U, ? extends Exception> var1);

    public abstract <U> Try<U> flatMap(ThrowingFunction<? super T, ? extends Try<U>, ? extends Exception> var1);

    public abstract Optional<Try<T>> filter(Predicate<T> var1);

    public abstract void forEach(ThrowingConsumer<? super T, ? extends Exception> var1);

    public abstract Try<T> peek(ThrowingConsumer<? super T, ? extends Exception> var1);

    public abstract Try<T> peekFailure(Consumer<Failure<T>> var1);

    public abstract T orElse(T var1);

    public abstract T orElseGet(Supplier<? extends T> var1);

    public abstract <U> U recover(Function<? super T, ? extends U> var1, Function<Exception, ? extends U> var2);

    public abstract Optional<T> toOptional();

    public abstract <X extends Exception> Either<X, T> toEither();

    public abstract <X extends Exception, Y extends Exception> T orElseThrow(Function<X, Y> var1) throws Y;

    public abstract <E extends Exception> T orElseRethrow() throws E;

    public static <U, V> Try<U> of(ThrowingFunction<V, ? extends U, ? extends Exception> func, V v) {
        try {
            return new Success<U>(func.apply(v));
        }
        catch (Exception e) {
            return new Failure(e);
        }
    }

    public static <U, V, W> Try<U> of(ThrowingBiFunction<V, W, ? extends U, ? extends Exception> func, V v, W w) {
        try {
            return new Success<U>(func.apply(v, w));
        }
        catch (Exception e) {
            return new Failure(e);
        }
    }

    public static <U> Try<U> of(ThrowingSupplier<U, ? extends Exception> supplier) {
        try {
            return new Success<U>(supplier.get());
        }
        catch (Exception e) {
            return new Failure(e);
        }
    }

    public static Try<Void> of(ThrowingVoidSupplier<? extends Exception> supplier) {
        try {
            supplier.get();
            return new Success<Object>(null);
        }
        catch (Exception e) {
            return new Failure<Void>(e);
        }
    }

    public static <U> Try<U> failure(Exception Exception2) {
        return new Failure(Exception2);
    }

    public static <T> Try<T> success(T value) {
        return new Success<T>(value);
    }

    public static <T> Try<List<T>> sequence(List<Try<T>> tries) {
        if (tries.size() == 0) {
            return Try.failure(new IllegalArgumentException("Cannot sequence an empty list"));
        }
        Try<List<List>> head = Functions.head(tries).map(Collections::singletonList);
        if (tries.size() == 1 || !head.toOptional().isPresent()) {
            return head;
        }
        return Try.concat(head, head.flatMap(t -> Try.sequence(Functions.tail(tries))));
    }

    private static <T> Try<List<T>> concat(Try<List<T>> head, Try<List<T>> tail) {
        return head.flatMap(l -> tail.map(k -> Try.concat(l, k)));
    }

    private static <T> List<T> concat(List<T> l, List<T> k) {
        ArrayList<T> retVal = new ArrayList<T>(l);
        retVal.addAll(k);
        return retVal;
    }
}

