/*
 * Decompiled with CFR 0.152.
 */
package com.tresata.akka.http.spnego;

import akka.event.LoggingAdapter;
import akka.http.scaladsl.server.ConjunctionMagnet$;
import akka.http.scaladsl.server.Directive;
import akka.http.scaladsl.server.Directive$;
import akka.http.scaladsl.server.Rejection;
import akka.http.scaladsl.server.RequestContext;
import akka.http.scaladsl.server.StandardRoute$;
import akka.http.scaladsl.server.directives.BasicDirectives$;
import akka.http.scaladsl.server.directives.FutureDirectives$;
import akka.http.scaladsl.server.directives.OnSuccessMagnet$;
import akka.http.scaladsl.server.directives.RouteDirectives$;
import akka.http.scaladsl.server.util.Tuple$;
import akka.http.scaladsl.server.util.TupleOps;
import akka.http.scaladsl.server.util.Tupler$;
import com.tresata.akka.http.spnego.SpnegoAuthenticator;
import com.tresata.akka.http.spnego.Token;
import com.tresata.akka.http.spnego.Tokens;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple1;
import scala.collection.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future$;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class SpnegoAuthenticator$ {
    public static SpnegoAuthenticator$ MODULE$;
    private final String com$tresata$akka$http$spnego$SpnegoAuthenticator$$cookieName;
    private final String com$tresata$akka$http$spnego$SpnegoAuthenticator$$Authorization;
    private final String com$tresata$akka$http$spnego$SpnegoAuthenticator$$negotiate;
    private final String com$tresata$akka$http$spnego$SpnegoAuthenticator$$wwwAuthenticate;

    static {
        new SpnegoAuthenticator$();
    }

    public String com$tresata$akka$http$spnego$SpnegoAuthenticator$$cookieName() {
        return this.com$tresata$akka$http$spnego$SpnegoAuthenticator$$cookieName;
    }

    public String com$tresata$akka$http$spnego$SpnegoAuthenticator$$Authorization() {
        return this.com$tresata$akka$http$spnego$SpnegoAuthenticator$$Authorization;
    }

    public String com$tresata$akka$http$spnego$SpnegoAuthenticator$$negotiate() {
        return this.com$tresata$akka$http$spnego$SpnegoAuthenticator$$negotiate;
    }

    public String com$tresata$akka$http$spnego$SpnegoAuthenticator$$wwwAuthenticate() {
        return this.com$tresata$akka$http$spnego$SpnegoAuthenticator$$wwwAuthenticate;
    }

    public SpnegoAuthenticator apply(Config config, ExecutionContext ec, LoggingAdapter log) {
        String principal = config.getString("tresata.akka.http.spnego.kerberos.principal");
        String keytab = config.getString("tresata.akka.http.spnego.kerberos.keytab");
        boolean debug = config.getBoolean("tresata.akka.http.spnego.kerberos.debug");
        Option domain = new Some((Object)config.getString("tresata.akka.http.spnego.cookie.domain")).flatMap((Function1 & Serializable & scala.Serializable)x -> {
            String string = x;
            String string2 = "";
            return !(string != null ? !string.equals(string2) : string2 != null) ? None$.MODULE$ : new Some(x);
        });
        Option path = new Some((Object)config.getString("tresata.akka.http.spnego.cookie.path")).flatMap((Function1 & Serializable & scala.Serializable)x -> {
            String string = x;
            String string2 = "";
            return !(string != null ? !string.equals(string2) : string2 != null) ? None$.MODULE$ : new Some(x);
        });
        Duration tokenValidity = config.getDuration("tresata.akka.http.spnego.token.validity");
        String signatureSecret = config.getString("tresata.akka.http.spnego.signature.secret");
        log.info("principal {}", (Object)principal);
        log.info("keytab {}", (Object)keytab);
        log.info("debug {}", (Object)BoxesRunTime.boxToBoolean((boolean)debug));
        log.info("domain {}", (Object)domain);
        log.info("path {}", (Object)path);
        log.info("token validity {}", (Object)tokenValidity);
        Tokens tokens = new Tokens(tokenValidity.toMillis(), signatureSecret.getBytes(StandardCharsets.UTF_8));
        return new SpnegoAuthenticator(principal, keytab, debug, (Option<String>)domain, (Option<String>)path, tokens, log);
    }

    public Config apply$default$1() {
        return ConfigFactory.load();
    }

    public Directive<Tuple1<Token>> spnegoAuthenticate(Config config) {
        return Directive$.MODULE$.SingleValueModifiers(BasicDirectives$.MODULE$.extractExecutionContext()).flatMap((Function1 & Serializable & scala.Serializable)ec -> Directive$.MODULE$.SingleValueModifiers(BasicDirectives$.MODULE$.extractLog()).flatMap((Function1 & Serializable & scala.Serializable)log -> {
            log.debug("creating spnego authenticator");
            SpnegoAuthenticator spnego = MODULE$.apply(config, (ExecutionContext)ec, (LoggingAdapter)log);
            return Directive$.MODULE$.SingleValueModifiers(Directive$.MODULE$.SingleValueModifiers(BasicDirectives$.MODULE$.extract((Function1 & Serializable & scala.Serializable)ctx -> Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> spnego.apply((RequestContext)ctx), (ExecutionContext)ec))).flatMap((Function1 & Serializable & scala.Serializable)x$1 -> FutureDirectives$.MODULE$.onSuccess(OnSuccessMagnet$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> x$1, Tupler$.MODULE$.forAnyRef())), Tuple$.MODULE$.forTuple1())).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Directive directive;
                Either either = x0$1;
                if (either instanceof Left) {
                    Left left = (Left)either;
                    Rejection rejection = (Rejection)left.value();
                    directive = StandardRoute$.MODULE$.toDirective(RouteDirectives$.MODULE$.reject((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Rejection[]{rejection})), Tuple$.MODULE$.forTuple1());
                } else if (either instanceof Right) {
                    Right right = (Right)either;
                    Token token = (Token)right.value();
                    directive = (Directive)BasicDirectives$.MODULE$.provide((Object)token).$amp(ConjunctionMagnet$.MODULE$.fromDirective(spnego.setSpnegoCookie(token), TupleOps.Join$.MODULE$.join(TupleOps.FoldLeft$.MODULE$.t0())));
                } else {
                    throw new MatchError((Object)either);
                }
                return directive;
            }, Tuple$.MODULE$.forTuple1());
        }, Tuple$.MODULE$.forTuple1()), Tuple$.MODULE$.forTuple1());
    }

    public Config spnegoAuthenticate$default$1() {
        return ConfigFactory.load();
    }

    private SpnegoAuthenticator$() {
        MODULE$ = this;
        this.com$tresata$akka$http$spnego$SpnegoAuthenticator$$cookieName = "akka.http.spnego";
        this.com$tresata$akka$http$spnego$SpnegoAuthenticator$$Authorization = "authorization";
        this.com$tresata$akka$http$spnego$SpnegoAuthenticator$$negotiate = "Negotiate";
        this.com$tresata$akka$http$spnego$SpnegoAuthenticator$$wwwAuthenticate = "WWW-Authenticate";
    }
}

