/*
 * Decompiled with CFR 0.152.
 */
package com.tresata.akka.http.spnego;

import com.tresata.akka.http.spnego.Token;
import com.tresata.akka.http.spnego.Token$;
import com.tresata.akka.http.spnego.TokenParseException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import org.apache.commons.codec.binary.Base64;
import scala.Array$;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u000113A!\u0001\u0002\u0001\u001b\t1Ak\\6f]NT!a\u0001\u0003\u0002\rM\u0004h.Z4p\u0015\t)a!\u0001\u0003iiR\u0004(BA\u0004\t\u0003\u0011\t7n[1\u000b\u0005%Q\u0011a\u0002;sKN\fG/\u0019\u0006\u0002\u0017\u0005\u00191m\\7\u0004\u0001M\u0011\u0001A\u0004\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0002#\u0005)1oY1mC&\u00111\u0003\u0005\u0002\u0007\u0003:L(+\u001a4\t\u0011U\u0001!\u0011!Q\u0001\nY\tQ\u0002^8lK:4\u0016\r\\5eSRL\bCA\b\u0018\u0013\tA\u0002C\u0001\u0003M_:<\u0007\u0002\u0003\u000e\u0001\u0005\u0003\u0005\u000b\u0011B\u000e\u0002\u001fMLwM\\1ukJ,7+Z2sKR\u00042a\u0004\u000f\u001f\u0013\ti\u0002CA\u0003BeJ\f\u0017\u0010\u0005\u0002\u0010?%\u0011\u0001\u0005\u0005\u0002\u0005\u0005f$X\rC\u0003#\u0001\u0011\u00051%\u0001\u0004=S:LGO\u0010\u000b\u0004I\u0019:\u0003CA\u0013\u0001\u001b\u0005\u0011\u0001\"B\u000b\"\u0001\u00041\u0002\"\u0002\u000e\"\u0001\u0004Y\u0002\"B\u0015\u0001\t\u0013Q\u0013!\u00048fo\u0016C\b/\u001b:bi&|g.F\u0001\u0017\u0011\u0019a\u0003\u0001\"\u0001\u0003[\u0005!1/[4o)\tq\u0013\b\u0005\u00020m9\u0011\u0001\u0007\u000e\t\u0003cAi\u0011A\r\u0006\u0003g1\ta\u0001\u0010:p_Rt\u0014BA\u001b\u0011\u0003\u0019\u0001&/\u001a3fM&\u0011q\u0007\u000f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005U\u0002\u0002\"\u0002\u001e,\u0001\u0004Y\u0014!\u0002;pW\u0016t\u0007CA\u0013=\u0013\ti$AA\u0003U_.,g\u000eC\u0003@\u0001\u0011\u0005\u0001)\u0001\u0004de\u0016\fG/\u001a\u000b\u0003w\u0005CQA\u0011 A\u00029\n\u0011\u0002\u001d:j]\u000eL\u0007/\u00197\t\u000b\u0011\u0003A\u0011A#\u0002\u000bA\f'o]3\u0015\u0005m2\u0005\"B$D\u0001\u0004q\u0013a\u0003;pW\u0016t7\u000b\u001e:j]\u001eDQ!\u0013\u0001\u0005\u0002)\u000b\u0011b]3sS\u0006d\u0017N_3\u0015\u00059Z\u0005\"\u0002\u001eI\u0001\u0004Y\u0004")
public class Tokens {
    private final long tokenValidity;
    private final byte[] signatureSecret;

    private long newExpiration() {
        return System.currentTimeMillis() + this.tokenValidity;
    }

    public String sign(Token token) {
        MessageDigest md = MessageDigest.getInstance("SHA");
        md.update(token.principal().getBytes(StandardCharsets.UTF_8));
        ByteBuffer bb = ByteBuffer.allocate(8);
        bb.putLong(token.expiration());
        md.update(bb.array());
        md.update(this.signatureSecret);
        return new Base64(0).encodeToString(md.digest());
    }

    public Token create(String principal) {
        return Token$.MODULE$.apply(principal, this.newExpiration());
    }

    public Token parse(String tokenString) {
        Token token;
        String[] stringArray = tokenString.split("&");
        Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
        if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(3) == 0) {
            Token token2;
            String principal = (String)((SeqLike)option.get()).apply(0);
            String expirationString = (String)((SeqLike)option.get()).apply(1);
            String signature = (String)((SeqLike)option.get()).apply(2);
            Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(expirationString)).toLong());
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                long expiration = BoxesRunTime.unboxToLong((Object)success.value());
                token2 = Token$.MODULE$.apply(principal, expiration);
                String string = this.sign(token2);
                String string2 = signature;
                if (string == null ? string2 != null : !string.equals(string2)) {
                    throw new TokenParseException("incorrect signature");
                }
            } else {
                throw new TokenParseException("expiration not a long");
            }
            token = token2;
        } else {
            throw new TokenParseException("incorrect number of fields");
        }
        Token token3 = token;
        return token3;
    }

    public String serialize(Token token) {
        return List$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{token.principal(), BoxesRunTime.boxToLong((long)token.expiration()), this.sign(token)})).mkString("&");
    }

    public Tokens(long tokenValidity, byte[] signatureSecret) {
        this.tokenValidity = tokenValidity;
        this.signatureSecret = signatureSecret;
    }
}

