/*
 * Decompiled with CFR 0.152.
 */
package no.ks.kes.demoapp;

import com.eventstore.dbclient.ConnectionSettingsBuilder;
import com.eventstore.dbclient.Endpoint;
import com.eventstore.dbclient.EventStoreDBClient;
import com.eventstore.dbclient.EventStoreDBClientSettings;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import javax.sql.DataSource;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import no.ks.kes.demoapp.Application;
import no.ks.kes.demoapp.Basket;
import no.ks.kes.demoapp.BasketCmds;
import no.ks.kes.demoapp.PaymentProcessor;
import no.ks.kes.demoapp.Shipment;
import no.ks.kes.demoapp.ShipmentCmds;
import no.ks.kes.demoapp.ShipmentSaga;
import no.ks.kes.demoapp.Shipments;
import no.ks.kes.demoapp.WarehouseManager;
import no.ks.kes.grpc.GrpcAggregateRepository;
import no.ks.kes.grpc.GrpcEventSubscriberFactory;
import no.ks.kes.grpc.GrpcEventUtil;
import no.ks.kes.jdbc.projection.SqlServerProjectionRepository;
import no.ks.kes.jdbc.saga.SqlServerCommandQueue;
import no.ks.kes.jdbc.saga.SqlServerSagaRepository;
import no.ks.kes.lib.AggregateRepository;
import no.ks.kes.lib.CmdHandler;
import no.ks.kes.lib.CmdSerdes;
import no.ks.kes.lib.CommandQueue;
import no.ks.kes.lib.EventSerdes;
import no.ks.kes.lib.EventSubscriberFactory;
import no.ks.kes.lib.ProjectionRepository;
import no.ks.kes.lib.Projections;
import no.ks.kes.lib.SagaRepository;
import no.ks.kes.lib.SagaStateSerdes;
import no.ks.kes.lib.Sagas;
import no.ks.kes.serdes.jackson.JacksonCmdSerdes;
import no.ks.kes.serdes.jackson.JacksonEventSerdes;
import no.ks.kes.serdes.jackson.JacksonSagaStateSerdes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Component;

@Configuration
@SpringBootApplication
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001:\u0002\u001a\u001bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0017J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004H\u0017J\u001c\u0010\f\u001a\u00020\r2\b\b\u0001\u0010\u000e\u001a\u00020\u000f2\b\b\u0001\u0010\u0010\u001a\u00020\u000fH\u0017J\b\u0010\u0007\u001a\u00020\bH\u0017J\u001c\u0010\u0011\u001a\u00020\u00062\b\b\u0001\u0010\u000e\u001a\u00020\u000f2\b\b\u0001\u0010\u0010\u001a\u00020\u000fH\u0017J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0015H\u0017J\b\u0010\u0016\u001a\u00020\u0017H\u0017J\u001c\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u00192\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0017J\b\u0010\u0014\u001a\u00020\u0015H\u0017\u00a8\u0006\u001c"}, d2={"Lno/ks/kes/demoapp/Application;", "", "()V", "aggregateRepo", "Lno/ks/kes/lib/AggregateRepository;", "eventStoreDBClient", "Lcom/eventstore/dbclient/EventStoreDBClient;", "eventSerdes", "Lno/ks/kes/lib/EventSerdes;", "basketCmd", "Lno/ks/kes/demoapp/BasketCmds;", "aggregateRepository", "datasource", "Ljavax/sql/DataSource;", "host", "", "port", "eventStore", "shipmentCmd", "Lno/ks/kes/demoapp/ShipmentCmds;", "warehouseManager", "Lno/ks/kes/demoapp/WarehouseManager;", "shippedBaskets", "Lno/ks/kes/demoapp/Shipments;", "subscriber", "Lno/ks/kes/lib/EventSubscriberFactory;", "MyInitializer", "MyWarehouseManager", "k-es-demo-app-grpc-jackson"})
public class Application {
    @Bean
    @NotNull
    public DataSource datasource(@Value(value="${mssql.host}") @NotNull String host, @Value(value="${mssql.port}") @NotNull String port) {
        DataSourceBuilder dataSourceBuilder;
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)port, (String)"port");
        DataSourceBuilder $this$datasource_u24lambda_u240 = dataSourceBuilder = DataSourceBuilder.create();
        boolean bl = false;
        $this$datasource_u24lambda_u240.driverClassName("com.microsoft.sqlserver.jdbc.SQLServerDriver");
        $this$datasource_u24lambda_u240.url("jdbc:sqlserver://" + host + ":" + port + ";databaseName=kesdemo;encrypt=false");
        $this$datasource_u24lambda_u240.username("SA");
        $this$datasource_u24lambda_u240.password("Test1234!");
        DataSource dataSource = dataSourceBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)dataSource, (String)"create().apply {\n       \u2026!\")\n            }.build()");
        return dataSource;
    }

    @Bean
    @NotNull
    public EventStoreDBClient eventStore(@Value(value="${eventstore.host}") @NotNull String host, @Value(value="${eventstore.port}") @NotNull String port) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)port, (String)"port");
        EventStoreDBClient eventStoreDBClient = EventStoreDBClient.create((EventStoreDBClientSettings)new ConnectionSettingsBuilder().addHost(new Endpoint(host, Integer.parseInt(port))).defaultCredentials("admin", "changeit").tls(false).buildConnectionSettings());
        Intrinsics.checkNotNullExpressionValue((Object)eventStoreDBClient, (String)"create(\n        Connecti\u2026uildConnectionSettings())");
        return eventStoreDBClient;
    }

    @Bean
    @NotNull
    public EventSerdes eventSerdes() {
        Object[] objectArray = new KClass[]{Reflection.getOrCreateKotlinClass(Basket.Created.class), Reflection.getOrCreateKotlinClass(Basket.ItemAdded.class), Reflection.getOrCreateKotlinClass(Basket.CheckedOut.class), Reflection.getOrCreateKotlinClass(Shipment.Prepared.class), Reflection.getOrCreateKotlinClass(Shipment.Failed.class), Reflection.getOrCreateKotlinClass(Shipment.WarehouseNotifiedOfMissingShipment.class)};
        return (EventSerdes)new JacksonEventSerdes(SetsKt.setOf((Object[])objectArray), null, 2, null);
    }

    @Bean
    @NotNull
    public Shipments shippedBaskets() {
        return new Shipments();
    }

    @Bean
    @DependsOn(value={"flyway", "flywayInitializer"})
    @NotNull
    public AggregateRepository aggregateRepo(@NotNull EventStoreDBClient eventStoreDBClient, @NotNull EventSerdes eventSerdes) {
        Intrinsics.checkNotNullParameter((Object)eventStoreDBClient, (String)"eventStoreDBClient");
        Intrinsics.checkNotNullParameter((Object)eventSerdes, (String)"eventSerdes");
        return (AggregateRepository)new GrpcAggregateRepository(eventStoreDBClient, eventSerdes, GrpcEventUtil.INSTANCE.defaultStreamName("no.ks.kes.demoapp"), null, 8, null);
    }

    @Bean
    @NotNull
    public BasketCmds basketCmd(@NotNull AggregateRepository aggregateRepository) {
        Intrinsics.checkNotNullParameter((Object)aggregateRepository, (String)"aggregateRepository");
        return new BasketCmds(aggregateRepository, new PaymentProcessor(){

            public void process(@NotNull UUID orderId) {
                Intrinsics.checkNotNullParameter((Object)orderId, (String)"orderId");
            }
        });
    }

    @Bean
    @NotNull
    public WarehouseManager warehouseManager() {
        return new MyWarehouseManager();
    }

    @Bean
    @NotNull
    public ShipmentCmds shipmentCmd(@NotNull AggregateRepository aggregateRepository, @NotNull WarehouseManager warehouseManager) {
        Intrinsics.checkNotNullParameter((Object)aggregateRepository, (String)"aggregateRepository");
        Intrinsics.checkNotNullParameter((Object)warehouseManager, (String)"warehouseManager");
        return new ShipmentCmds(aggregateRepository, warehouseManager);
    }

    @Bean
    @NotNull
    public EventSubscriberFactory<?> subscriber(@NotNull EventStoreDBClient eventStoreDBClient, @NotNull EventSerdes eventSerdes) {
        Intrinsics.checkNotNullParameter((Object)eventStoreDBClient, (String)"eventStoreDBClient");
        Intrinsics.checkNotNullParameter((Object)eventSerdes, (String)"eventSerdes");
        return (EventSubscriberFactory)new GrpcEventSubscriberFactory(eventStoreDBClient, eventSerdes, "no.ks.kes.demoapp", null, 8, null);
    }

    @Component
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B1\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0002H\u0016R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0018\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001b"}, d2={"Lno/ks/kes/demoapp/Application$MyInitializer;", "Lorg/springframework/context/ApplicationListener;", "Lorg/springframework/boot/context/event/ApplicationReadyEvent;", "shipments", "Lno/ks/kes/demoapp/Shipments;", "eventSubscriberFactory", "Lno/ks/kes/lib/EventSubscriberFactory;", "dataSource", "Ljavax/sql/DataSource;", "basketCmds", "Lno/ks/kes/demoapp/BasketCmds;", "shipmentCmds", "Lno/ks/kes/demoapp/ShipmentCmds;", "(Lno/ks/kes/demoapp/Shipments;Lno/ks/kes/lib/EventSubscriberFactory;Ljavax/sql/DataSource;Lno/ks/kes/demoapp/BasketCmds;Lno/ks/kes/demoapp/ShipmentCmds;)V", "getBasketCmds", "()Lno/ks/kes/demoapp/BasketCmds;", "getDataSource", "()Ljavax/sql/DataSource;", "getEventSubscriberFactory", "()Lno/ks/kes/lib/EventSubscriberFactory;", "getShipmentCmds", "()Lno/ks/kes/demoapp/ShipmentCmds;", "getShipments", "()Lno/ks/kes/demoapp/Shipments;", "onApplicationEvent", "", "applicationReadyEvent", "k-es-demo-app-grpc-jackson"})
    public static class MyInitializer
    implements ApplicationListener<ApplicationReadyEvent> {
        @NotNull
        private final Shipments shipments;
        @NotNull
        private final EventSubscriberFactory<?> eventSubscriberFactory;
        @NotNull
        private final DataSource dataSource;
        @NotNull
        private final BasketCmds basketCmds;
        @NotNull
        private final ShipmentCmds shipmentCmds;

        public MyInitializer(@NotNull Shipments shipments, @NotNull EventSubscriberFactory<?> eventSubscriberFactory, @NotNull DataSource dataSource, @NotNull BasketCmds basketCmds, @NotNull ShipmentCmds shipmentCmds) {
            Intrinsics.checkNotNullParameter((Object)((Object)shipments), (String)"shipments");
            Intrinsics.checkNotNullParameter(eventSubscriberFactory, (String)"eventSubscriberFactory");
            Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
            Intrinsics.checkNotNullParameter((Object)((Object)basketCmds), (String)"basketCmds");
            Intrinsics.checkNotNullParameter((Object)((Object)shipmentCmds), (String)"shipmentCmds");
            this.shipments = shipments;
            this.eventSubscriberFactory = eventSubscriberFactory;
            this.dataSource = dataSource;
            this.basketCmds = basketCmds;
            this.shipmentCmds = shipmentCmds;
        }

        @NotNull
        public Shipments getShipments() {
            return this.shipments;
        }

        @NotNull
        public EventSubscriberFactory<?> getEventSubscriberFactory() {
            return this.eventSubscriberFactory;
        }

        @NotNull
        public DataSource getDataSource() {
            return this.dataSource;
        }

        @NotNull
        public BasketCmds getBasketCmds() {
            return this.basketCmds;
        }

        @NotNull
        public ShipmentCmds getShipmentCmds() {
            return this.shipmentCmds;
        }

        public void onApplicationEvent(@NotNull ApplicationReadyEvent applicationReadyEvent) {
            Intrinsics.checkNotNullParameter((Object)applicationReadyEvent, (String)"applicationReadyEvent");
            Object[] objectArray = new KClass[]{Reflection.getOrCreateKotlinClass(BasketCmds.Create.class), Reflection.getOrCreateKotlinClass(BasketCmds.AddItem.class), Reflection.getOrCreateKotlinClass(BasketCmds.CheckOut.class), Reflection.getOrCreateKotlinClass(ShipmentCmds.Request.class), Reflection.getOrCreateKotlinClass(ShipmentCmds.SendMissingShipmentAlert.class)};
            JacksonCmdSerdes cmdSerdes = new JacksonCmdSerdes(SetsKt.setOf((Object[])objectArray), null, 2, null);
            Projections.INSTANCE.initialize(this.getEventSubscriberFactory(), SetsKt.setOf((Object)((Object)this.getShipments())), (ProjectionRepository)new SqlServerProjectionRepository(this.getDataSource(), 0L, null, 6, null), "ProjectionManager", (Function1)onApplicationEvent.1.INSTANCE);
            objectArray = new CmdHandler[]{this.getBasketCmds(), this.getShipmentCmds()};
            Sagas.INSTANCE.initialize(this.getEventSubscriberFactory(), (SagaRepository)new SqlServerSagaRepository(this.getDataSource(), (SagaStateSerdes)new JacksonSagaStateSerdes(null, 1, null), (CmdSerdes)cmdSerdes, 0L, null, 24, null), SetsKt.setOf((Object)((Object)ShipmentSaga.INSTANCE)), (CommandQueue)new SqlServerCommandQueue(this.getDataSource(), (CmdSerdes)cmdSerdes, SetsKt.setOf((Object[])objectArray), null, 8, null), 500L, (Function1)onApplicationEvent.2.INSTANCE);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u000e\u0010\t\u001a\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u0006H\u0016J\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u001c\u0010\u0003\u001a\u0010\u0012\f\u0012\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u00060\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lno/ks/kes/demoapp/Application$MyWarehouseManager;", "Lno/ks/kes/demoapp/WarehouseManager;", "()V", "fail", "Ljava/util/concurrent/atomic/AtomicReference;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "failOnce", "", "e", "investigateMissingShipment", "orderId", "Ljava/util/UUID;", "shipOrder", "k-es-demo-app-grpc-jackson"})
    public static final class MyWarehouseManager
    implements WarehouseManager {
        @NotNull
        private AtomicReference<Exception> fail = new AtomicReference<Object>(null);

        @Override
        public void failOnce(@Nullable Exception e) {
            this.fail.set(e);
        }

        @Override
        public void investigateMissingShipment(@NotNull UUID orderId) {
            Intrinsics.checkNotNullParameter((Object)orderId, (String)"orderId");
        }

        @Override
        public void shipOrder(@NotNull UUID orderId) {
            Intrinsics.checkNotNullParameter((Object)orderId, (String)"orderId");
            Exception exception = this.fail.getAndSet(null);
            if (exception != null) {
                Exception it = exception;
                boolean bl = false;
                throw it;
            }
        }
    }
}

