/*
 * Decompiled with CFR 0.152.
 */
package no.ks.kes.demoapp;

import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Lambda;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import no.ks.kes.demoapp.ItemNoLongerCarried;
import no.ks.kes.demoapp.Shipment;
import no.ks.kes.demoapp.ShipmentAggregate;
import no.ks.kes.demoapp.ShipmentCmds;
import no.ks.kes.demoapp.WarehouseManager;
import no.ks.kes.demoapp.WarehouseSystemFailure;
import no.ks.kes.lib.AggregateConfiguration;
import no.ks.kes.lib.AggregateRepository;
import no.ks.kes.lib.Cmd;
import no.ks.kes.lib.CmdHandler;
import no.ks.kes.lib.Event;
import no.ks.kes.lib.EventData;
import no.ks.kes.lib.SerializationId;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\b\tB\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\n"}, d2={"Lno/ks/kes/demoapp/ShipmentCmds;", "Lno/ks/kes/lib/CmdHandler;", "Lno/ks/kes/demoapp/ShipmentAggregate;", "repo", "Lno/ks/kes/lib/AggregateRepository;", "warehouseManager", "Lno/ks/kes/demoapp/WarehouseManager;", "(Lno/ks/kes/lib/AggregateRepository;Lno/ks/kes/demoapp/WarehouseManager;)V", "Request", "SendMissingShipmentAlert", "k-es-demo-app-grpc-jackson"})
public final class ShipmentCmds
extends CmdHandler<ShipmentAggregate> {
    public ShipmentCmds(@NotNull AggregateRepository repo, @NotNull WarehouseManager warehouseManager) {
        Intrinsics.checkNotNullParameter((Object)repo, (String)"repo");
        Intrinsics.checkNotNullParameter((Object)warehouseManager, (String)"warehouseManager");
        super(repo, (AggregateConfiguration)Shipment.INSTANCE);
        CmdHandler this_$iv = this;
        boolean $i$f$init = false;
        if (!(!CmdHandler.access$getInitializers((CmdHandler)this_$iv).containsKey(Reflection.getOrCreateKotlinClass(Request.class)))) {
            boolean $i$a$-check-CmdHandler$init$1$iv22 = false;
            String $i$a$-check-CmdHandler$init$1$iv22 = "There are multiple \"init\" configurations for the command " + Reflection.getOrCreateKotlinClass(Request.class).getSimpleName() + " in the command handler " + Reflection.getOrCreateKotlinClass(this_$iv.getClass()).getSimpleName() + ", only a single \"init\" handler is allowed for each command";
            throw new IllegalStateException($i$a$-check-CmdHandler$init$1$iv22.toString());
        }
        Map map = CmdHandler.access$getInitializers((CmdHandler)this_$iv);
        KClass $i$a$-check-CmdHandler$init$1$iv22 = Reflection.getOrCreateKotlinClass(Request.class);
        Lambda lambda = new Function1<Cmd<A>, CmdHandler.Result<A>>(warehouseManager){
            final /* synthetic */ WarehouseManager $warehouseManager$inlined;
            {
                this.$warehouseManager$inlined = warehouseManager;
                super(1);
            }

            @NotNull
            public final CmdHandler.Result<A> invoke(@NotNull Cmd<A> c) {
                Shipment.Prepared prepared;
                Intrinsics.checkNotNullParameter(c, (String)"c");
                Request it = (Request)((Cmd)((Request)c));
                boolean bl = false;
                try {
                    this.$warehouseManager$inlined.shipOrder(it.getAggregateId());
                    prepared = new Shipment.Prepared(it.getAggregateId(), it.getBasketId(), it.getItems());
                    UUID uUID = it.getAggregateId();
                    prepared = (CmdHandler.Result)new CmdHandler.Result.Succeed(new Event(uUID, (EventData)prepared, null, 4, null));
                }
                catch (ItemNoLongerCarried e) {
                    Shipment.Failed failed = new Shipment.Failed(it.getAggregateId(), "Item no longer carried!", it.getBasketId());
                    UUID uUID = it.getAggregateId();
                    prepared = (CmdHandler.Result)new CmdHandler.Result.Fail(new Event(uUID, (EventData)failed, null, 4, null), (Exception)e);
                }
                catch (WarehouseSystemFailure e) {
                    Shipment.Failed failed = new Shipment.Failed(it.getAggregateId(), "System problem!", it.getBasketId());
                    UUID uUID = it.getAggregateId();
                    prepared = (CmdHandler.Result)new CmdHandler.Result.RetryOrFail(new Event(uUID, (EventData)failed, null, 4, null), (Exception)e, (Function1)1.1.INSTANCE);
                }
                return prepared;
            }
        };
        map.put($i$a$-check-CmdHandler$init$1$iv22, lambda);
        this_$iv = this;
        boolean $i$f$apply = false;
        if (!(!CmdHandler.access$getApplicators((CmdHandler)this_$iv).containsKey(Reflection.getOrCreateKotlinClass(SendMissingShipmentAlert.class)))) {
            boolean bl = false;
            String string = "There are multiple \"apply\" configurations for the command " + Reflection.getOrCreateKotlinClass(SendMissingShipmentAlert.class).getSimpleName() + " in the command handler " + Reflection.getOrCreateKotlinClass(this_$iv.getClass()).getSimpleName() + ", only a single \"apply\" handler is allowed for each command";
            throw new IllegalStateException(string.toString());
        }
        map = CmdHandler.access$getApplicators((CmdHandler)this_$iv);
        KClass kClass = Reflection.getOrCreateKotlinClass(SendMissingShipmentAlert.class);
        lambda = new Function2<A, Cmd<A>, CmdHandler.Result<A>>(warehouseManager){
            final /* synthetic */ WarehouseManager $warehouseManager$inlined;
            {
                this.$warehouseManager$inlined = warehouseManager;
                super(2);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final CmdHandler.Result<A> invoke(@NotNull A a, @NotNull Cmd<A> c) {
                void it;
                Intrinsics.checkNotNullParameter(a, (String)"a");
                Intrinsics.checkNotNullParameter(c, (String)"c");
                SendMissingShipmentAlert sendMissingShipmentAlert = (SendMissingShipmentAlert)((Cmd)((SendMissingShipmentAlert)c));
                ShipmentAggregate $this$_init__u24lambda_u241 = (ShipmentAggregate)a;
                boolean bl = false;
                this.$warehouseManager$inlined.investigateMissingShipment(it.getAggregateId());
                Shipment.WarehouseNotifiedOfMissingShipment warehouseNotifiedOfMissingShipment = new Shipment.WarehouseNotifiedOfMissingShipment(it.getAggregateId(), it.getBasketId());
                UUID uUID = it.getAggregateId();
                return (CmdHandler.Result)new CmdHandler.Result.Succeed(new Event(uUID, (EventData)warehouseNotifiedOfMissingShipment, null, 4, null));
            }
        };
        map.put(kClass, lambda);
    }

    @SerializationId(value="ShipmentRequest")
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B)\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\tJ\t\u0010\u000f\u001a\u00020\u0004H\u00c6\u0003J\u0015\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0004H\u00c6\u0003J3\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u00062\b\b\u0002\u0010\b\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0007H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lno/ks/kes/demoapp/ShipmentCmds$Request;", "Lno/ks/kes/lib/Cmd;", "Lno/ks/kes/demoapp/ShipmentAggregate;", "aggregateId", "Ljava/util/UUID;", "items", "", "", "basketId", "(Ljava/util/UUID;Ljava/util/Map;Ljava/util/UUID;)V", "getAggregateId", "()Ljava/util/UUID;", "getBasketId", "getItems", "()Ljava/util/Map;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "toString", "", "k-es-demo-app-grpc-jackson"})
    public static final class Request
    implements Cmd<ShipmentAggregate> {
        @NotNull
        private final UUID aggregateId;
        @NotNull
        private final Map<UUID, Integer> items;
        @NotNull
        private final UUID basketId;

        public Request(@NotNull UUID aggregateId, @NotNull Map<UUID, Integer> items, @NotNull UUID basketId) {
            Intrinsics.checkNotNullParameter((Object)aggregateId, (String)"aggregateId");
            Intrinsics.checkNotNullParameter(items, (String)"items");
            Intrinsics.checkNotNullParameter((Object)basketId, (String)"basketId");
            this.aggregateId = aggregateId;
            this.items = items;
            this.basketId = basketId;
        }

        @NotNull
        public UUID getAggregateId() {
            return this.aggregateId;
        }

        @NotNull
        public final Map<UUID, Integer> getItems() {
            return this.items;
        }

        @NotNull
        public final UUID getBasketId() {
            return this.basketId;
        }

        public boolean useOptimisticLocking() {
            return Cmd.DefaultImpls.useOptimisticLocking((Cmd)this);
        }

        @NotNull
        public final UUID component1() {
            return this.getAggregateId();
        }

        @NotNull
        public final Map<UUID, Integer> component2() {
            return this.items;
        }

        @NotNull
        public final UUID component3() {
            return this.basketId;
        }

        @NotNull
        public final Request copy(@NotNull UUID aggregateId, @NotNull Map<UUID, Integer> items, @NotNull UUID basketId) {
            Intrinsics.checkNotNullParameter((Object)aggregateId, (String)"aggregateId");
            Intrinsics.checkNotNullParameter(items, (String)"items");
            Intrinsics.checkNotNullParameter((Object)basketId, (String)"basketId");
            return new Request(aggregateId, items, basketId);
        }

        public static /* synthetic */ Request copy$default(Request request, UUID uUID, Map map, UUID uUID2, int n, Object object) {
            if ((n & 1) != 0) {
                uUID = request.getAggregateId();
            }
            if ((n & 2) != 0) {
                map = request.items;
            }
            if ((n & 4) != 0) {
                uUID2 = request.basketId;
            }
            return request.copy(uUID, map, uUID2);
        }

        @NotNull
        public String toString() {
            return "Request(aggregateId=" + this.getAggregateId() + ", items=" + this.items + ", basketId=" + this.basketId + ")";
        }

        public int hashCode() {
            int result = this.getAggregateId().hashCode();
            result = result * 31 + ((Object)this.items).hashCode();
            result = result * 31 + this.basketId.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Request)) {
                return false;
            }
            Request request = (Request)other;
            if (!Intrinsics.areEqual((Object)this.getAggregateId(), (Object)request.getAggregateId())) {
                return false;
            }
            if (!Intrinsics.areEqual(this.items, request.items)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.basketId, (Object)request.basketId);
        }
    }

    @SerializationId(value="SendMissingShipmentAlert")
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\t\u0010\n\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0004H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0015"}, d2={"Lno/ks/kes/demoapp/ShipmentCmds$SendMissingShipmentAlert;", "Lno/ks/kes/lib/Cmd;", "Lno/ks/kes/demoapp/ShipmentAggregate;", "aggregateId", "Ljava/util/UUID;", "basketId", "(Ljava/util/UUID;Ljava/util/UUID;)V", "getAggregateId", "()Ljava/util/UUID;", "getBasketId", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "k-es-demo-app-grpc-jackson"})
    public static final class SendMissingShipmentAlert
    implements Cmd<ShipmentAggregate> {
        @NotNull
        private final UUID aggregateId;
        @NotNull
        private final UUID basketId;

        public SendMissingShipmentAlert(@NotNull UUID aggregateId, @NotNull UUID basketId) {
            Intrinsics.checkNotNullParameter((Object)aggregateId, (String)"aggregateId");
            Intrinsics.checkNotNullParameter((Object)basketId, (String)"basketId");
            this.aggregateId = aggregateId;
            this.basketId = basketId;
        }

        @NotNull
        public UUID getAggregateId() {
            return this.aggregateId;
        }

        @NotNull
        public final UUID getBasketId() {
            return this.basketId;
        }

        public boolean useOptimisticLocking() {
            return Cmd.DefaultImpls.useOptimisticLocking((Cmd)this);
        }

        @NotNull
        public final UUID component1() {
            return this.getAggregateId();
        }

        @NotNull
        public final UUID component2() {
            return this.basketId;
        }

        @NotNull
        public final SendMissingShipmentAlert copy(@NotNull UUID aggregateId, @NotNull UUID basketId) {
            Intrinsics.checkNotNullParameter((Object)aggregateId, (String)"aggregateId");
            Intrinsics.checkNotNullParameter((Object)basketId, (String)"basketId");
            return new SendMissingShipmentAlert(aggregateId, basketId);
        }

        public static /* synthetic */ SendMissingShipmentAlert copy$default(SendMissingShipmentAlert sendMissingShipmentAlert, UUID uUID, UUID uUID2, int n, Object object) {
            if ((n & 1) != 0) {
                uUID = sendMissingShipmentAlert.getAggregateId();
            }
            if ((n & 2) != 0) {
                uUID2 = sendMissingShipmentAlert.basketId;
            }
            return sendMissingShipmentAlert.copy(uUID, uUID2);
        }

        @NotNull
        public String toString() {
            return "SendMissingShipmentAlert(aggregateId=" + this.getAggregateId() + ", basketId=" + this.basketId + ")";
        }

        public int hashCode() {
            int result = this.getAggregateId().hashCode();
            result = result * 31 + this.basketId.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SendMissingShipmentAlert)) {
                return false;
            }
            SendMissingShipmentAlert sendMissingShipmentAlert = (SendMissingShipmentAlert)other;
            if (!Intrinsics.areEqual((Object)this.getAggregateId(), (Object)sendMissingShipmentAlert.getAggregateId())) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.basketId, (Object)sendMissingShipmentAlert.basketId);
        }
    }
}

