/*
 * Decompiled with CFR 0.152.
 */
package no.ks.kes.esjc;

import com.github.msemys.esjc.EventData;
import com.github.msemys.esjc.EventStore;
import com.github.msemys.esjc.ResolvedEvent;
import com.github.msemys.esjc.WriteResult;
import com.github.msemys.esjc.operation.StreamNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.stream.Stream;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.streams.jdk8.StreamsKt;
import no.ks.kes.esjc.EsjcAggregateRepositoryKt;
import no.ks.kes.esjc.EsjcEventUtil;
import no.ks.kes.lib.Aggregate;
import no.ks.kes.lib.AggregateReadResult;
import no.ks.kes.lib.AggregateRepository;
import no.ks.kes.lib.Event;
import no.ks.kes.lib.EventMetadataSerdes;
import no.ks.kes.lib.EventSerdes;
import no.ks.kes.lib.EventUpgrader;
import no.ks.kes.lib.EventWrapper;
import no.ks.kes.lib.ExpectedEventNumber;
import no.ks.kes.lib.Metadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@kotlin.Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\u0018\u00002\u00020\u0001Ba\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00126\u0010\u0006\u001a2\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0012\b\u0002\u0010\u000e\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0010\u0018\u00010\u000f\u00a2\u0006\u0002\u0010\u0011J2\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0010\u0010\u0016\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00180\u0017H\u0016J\u001a\u0010\u0019\u001a\u00020\b2\u0010\u0010\u001a\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001c0\u001bH\u0016Jb\u0010\u001d\u001a\u00020\u001e\"\b\b\u0000\u0010\u001f*\u00020 2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\b2>\u0010!\u001a:\u0012\u0015\u0012\u0013\u0018\u0001H\u001f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\"\u0012\u0017\u0012\u0015\u0012\u0002\b\u00030#\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b($\u0012\u0006\u0012\u0004\u0018\u0001H\u001f0\u0007H\u0014J\u0010\u0010%\u001a\u00020&2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000e\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0010\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R>\u0010\u0006\u001a2\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lno/ks/kes/esjc/EsjcAggregateRepository;", "Lno/ks/kes/lib/AggregateRepository;", "eventStore", "Lcom/github/msemys/esjc/EventStore;", "serdes", "Lno/ks/kes/lib/EventSerdes;", "streamIdGenerator", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "aggregateType", "Ljava/util/UUID;", "aggregateId", "metadataSerdes", "Lno/ks/kes/lib/EventMetadataSerdes;", "Lno/ks/kes/lib/Metadata;", "(Lcom/github/msemys/esjc/EventStore;Lno/ks/kes/lib/EventSerdes;Lkotlin/jvm/functions/Function2;Lno/ks/kes/lib/EventMetadataSerdes;)V", "append", "", "expectedEventNumber", "Lno/ks/kes/lib/ExpectedEventNumber;", "eventWrappers", "", "Lno/ks/kes/lib/Event;", "getSerializationId", "eventDataClass", "Lkotlin/reflect/KClass;", "Lno/ks/kes/lib/EventData;", "read", "Lno/ks/kes/lib/AggregateReadResult;", "A", "Lno/ks/kes/lib/Aggregate;", "applicator", "state", "Lno/ks/kes/lib/EventWrapper;", "event", "resolveExpectedEventNumber", "", "k-es-esjc"})
public final class EsjcAggregateRepository
extends AggregateRepository {
    @NotNull
    private final EventStore eventStore;
    @NotNull
    private final EventSerdes serdes;
    @NotNull
    private final Function2<String, UUID, String> streamIdGenerator;
    @Nullable
    private final EventMetadataSerdes<? extends Metadata> metadataSerdes;

    public EsjcAggregateRepository(@NotNull EventStore eventStore, @NotNull EventSerdes serdes, @NotNull Function2<? super String, ? super UUID, String> streamIdGenerator, @Nullable EventMetadataSerdes<? extends Metadata> metadataSerdes) {
        Intrinsics.checkNotNullParameter((Object)eventStore, (String)"eventStore");
        Intrinsics.checkNotNullParameter((Object)serdes, (String)"serdes");
        Intrinsics.checkNotNullParameter(streamIdGenerator, (String)"streamIdGenerator");
        this.eventStore = eventStore;
        this.serdes = serdes;
        this.streamIdGenerator = streamIdGenerator;
        this.metadataSerdes = metadataSerdes;
    }

    public /* synthetic */ EsjcAggregateRepository(EventStore eventStore, EventSerdes eventSerdes, Function2 function2, EventMetadataSerdes eventMetadataSerdes, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            eventMetadataSerdes = null;
        }
        this(eventStore, eventSerdes, (Function2<? super String, ? super UUID, String>)function2, (EventMetadataSerdes<? extends Metadata>)eventMetadataSerdes);
    }

    /*
     * WARNING - void declaration
     */
    public void append(@NotNull String aggregateType, @NotNull UUID aggregateId, @NotNull ExpectedEventNumber expectedEventNumber, @NotNull List<? extends Event<?>> eventWrappers) {
        Intrinsics.checkNotNullParameter((Object)aggregateType, (String)"aggregateType");
        Intrinsics.checkNotNullParameter((Object)aggregateId, (String)"aggregateId");
        Intrinsics.checkNotNullParameter((Object)expectedEventNumber, (String)"expectedEventNumber");
        Intrinsics.checkNotNullParameter(eventWrappers, (String)"eventWrappers");
        String streamId = (String)this.streamIdGenerator.invoke((Object)aggregateType, (Object)aggregateId);
        try {
            Collection<EventData> collection;
            void $this$mapTo$iv$iv;
            Object $this$map$iv;
            Iterable iterable = eventWrappers;
            long l = this.resolveExpectedEventNumber(expectedEventNumber);
            String string = streamId;
            EventStore eventStore = this.eventStore;
            boolean $i$f$map = false;
            void var8_13 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Event event = (Event)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                EventData.Builder newBuilder = EventData.newBuilder();
                if (this.serdes.isJson()) {
                    newBuilder.jsonData(this.serdes.serialize(it.getEventData()));
                } else {
                    newBuilder.data(this.serdes.serialize(it.getEventData()));
                }
                if (this.metadataSerdes != null && it.getMetadata() != null) {
                    Metadata metadata = it.getMetadata();
                    Intrinsics.checkNotNull((Object)metadata);
                    newBuilder.jsonMetadata(this.metadataSerdes.serialize(metadata));
                }
                collection.add(newBuilder.type(this.serdes.getSerializationId(Reflection.getOrCreateKotlinClass(it.getEventData().getClass()))).build());
            }
            collection = (List)destination$iv$iv;
            $this$map$iv = eventStore.appendToStream(string, l, (Iterable)collection).get();
            WriteResult it = (WriteResult)$this$map$iv;
            boolean bl = false;
            EsjcAggregateRepositoryKt.access$getLog$p().info("wrote " + eventWrappers.size() + " events to stream " + streamId + ", next expected version for this stream is " + it.nextExpectedVersion);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while appending events to stream " + streamId, e);
        }
    }

    @NotNull
    public String getSerializationId(@NotNull KClass<no.ks.kes.lib.EventData<?>> eventDataClass) {
        Intrinsics.checkNotNullParameter(eventDataClass, (String)"eventDataClass");
        return this.serdes.getSerializationId(eventDataClass);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected <A extends Aggregate> AggregateReadResult read(@NotNull UUID aggregateId, @NotNull String aggregateType, @NotNull Function2<? super A, ? super EventWrapper<?>, ? extends A> applicator) {
        AggregateReadResult aggregateReadResult;
        Intrinsics.checkNotNullParameter((Object)aggregateId, (String)"aggregateId");
        Intrinsics.checkNotNullParameter((Object)aggregateType, (String)"aggregateType");
        Intrinsics.checkNotNullParameter(applicator, (String)"applicator");
        try {
            AggregateReadResult aggregateReadResult2;
            void $this$fold$iv;
            String streamId = (String)this.streamIdGenerator.invoke((Object)aggregateType, (Object)aggregateId);
            Stream stream = this.eventStore.streamEventsForward(streamId, 0L, 100, false);
            Intrinsics.checkNotNullExpressionValue((Object)stream, (String)"eventStore.streamEventsF\u2026  false\n                )");
            Sequence sequence = StreamsKt.asSequence((Stream)stream);
            Pair initial$iv = TuplesKt.to((Object)null, (Object)null);
            boolean $i$f$fold = false;
            Pair accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                Pair pair;
                void e;
                ResolvedEvent resolvedEvent = (ResolvedEvent)element$iv;
                Pair a = accumulator$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)e, (String)"e");
                if (EsjcEventUtil.INSTANCE.isIgnorableEvent$k_es_esjc((ResolvedEvent)e)) {
                    pair = TuplesKt.to((Object)a.getFirst(), (Object)e.event.eventNumber);
                } else {
                    Metadata metadata;
                    Intrinsics.checkNotNullExpressionValue((Object)e.event.metadata, (String)"e.event.metadata");
                    if (!(e.event.metadata.length == 0) && this.metadataSerdes != null) {
                        Intrinsics.checkNotNullExpressionValue((Object)e.event.metadata, (String)"e.event.metadata");
                        metadata = this.metadataSerdes.deserialize(e.event.metadata);
                    } else {
                        metadata = null;
                    }
                    Metadata eventMeta = metadata;
                    Intrinsics.checkNotNullExpressionValue((Object)e.event.data, (String)"e.event.data");
                    String string = e.event.eventType;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"e.event.eventType");
                    no.ks.kes.lib.EventData event = this.serdes.deserialize(e.event.data, string);
                    no.ks.kes.lib.EventData deserialized = EventUpgrader.INSTANCE.upgrade(event);
                    pair = TuplesKt.to((Object)applicator.invoke(a.getFirst(), (Object)new EventWrapper(new Event(aggregateId, deserialized, eventMeta), e.event.eventNumber, this.serdes.getSerializationId(Reflection.getOrCreateKotlinClass(deserialized.getClass())))), (Object)e.event.eventNumber);
                }
                accumulator$iv = pair;
            }
            Pair it = accumulator$iv;
            boolean bl = false;
            if (it.getFirst() == null && it.getSecond() != null) {
                Object object = it.getSecond();
                Intrinsics.checkNotNull((Object)object);
                aggregateReadResult2 = (AggregateReadResult)new AggregateReadResult.UninitializedAggregate(((Number)object).longValue());
            } else if (it.getFirst() != null && it.getSecond() != null) {
                Object object = it.getFirst();
                Intrinsics.checkNotNull((Object)object);
                Aggregate aggregate = (Aggregate)object;
                Object object2 = it.getSecond();
                Intrinsics.checkNotNull((Object)object2);
                aggregateReadResult2 = (AggregateReadResult)new AggregateReadResult.InitializedAggregate(aggregate, ((Number)object2).longValue());
            } else {
                throw new IllegalStateException(("Error reading " + streamId + ", the stream exists but does not contain any events").toString());
            }
            aggregateReadResult = aggregateReadResult2;
        }
        catch (StreamNotFoundException e) {
            aggregateReadResult = (AggregateReadResult)AggregateReadResult.NonExistingAggregate.INSTANCE;
        }
        return aggregateReadResult;
    }

    private final long resolveExpectedEventNumber(ExpectedEventNumber expectedEventNumber) {
        long l;
        ExpectedEventNumber expectedEventNumber2 = expectedEventNumber;
        if (expectedEventNumber2 instanceof ExpectedEventNumber.AggregateDoesNotExist) {
            l = -1L;
        } else if (expectedEventNumber2 instanceof ExpectedEventNumber.AggregateExists) {
            l = -4L;
        } else if (expectedEventNumber2 instanceof ExpectedEventNumber.Any) {
            l = -2L;
        } else if (expectedEventNumber2 instanceof ExpectedEventNumber.Exact) {
            l = ((ExpectedEventNumber.Exact)expectedEventNumber).getEventNumber();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return l;
    }
}

