/*
 * Decompiled with CFR 0.152.
 */
package no.ks.kes.jdbc.saga;

import java.sql.ResultSet;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.sql.DataSource;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.Charsets;
import no.ks.kes.jdbc.CmdTable;
import no.ks.kes.jdbc.SagaTable;
import no.ks.kes.jdbc.TimeoutTable;
import no.ks.kes.jdbc.hwm.SqlServerHwmTrackerRepository;
import no.ks.kes.jdbc.saga.SqlServerSagaRepositoryKt;
import no.ks.kes.lib.Cmd;
import no.ks.kes.lib.CmdSerdes;
import no.ks.kes.lib.Saga;
import no.ks.kes.lib.SagaRepository;
import no.ks.kes.lib.SagaStateSerdes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionTemplate;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\n\u0010\u0019\u001a\u0004\u0018\u00010\u0018H\u0016J7\u0010\u001a\u001a\u0004\u0018\u0001H\u001b\"\b\b\u0000\u0010\u001b*\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u000b2\f\u0010 \u001a\b\u0012\u0004\u0012\u0002H\u001b0!H\u0016\u00a2\u0006\u0002\u0010\"J\u0016\u0010#\u001a\u00020\u00162\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00160%H\u0016J\u0016\u0010&\u001a\u00020\u00162\f\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lno/ks/kes/jdbc/saga/SqlServerSagaRepository;", "Lno/ks/kes/lib/SagaRepository;", "dataSource", "Ljavax/sql/DataSource;", "sagaStateSerdes", "Lno/ks/kes/lib/SagaStateSerdes;", "cmdSerdes", "Lno/ks/kes/lib/CmdSerdes;", "initialHwm", "", "schema", "", "(Ljavax/sql/DataSource;Lno/ks/kes/lib/SagaStateSerdes;Lno/ks/kes/lib/CmdSerdes;JLjava/lang/String;)V", "hwmTracker", "Lno/ks/kes/jdbc/hwm/SqlServerHwmTrackerRepository;", "getHwmTracker", "()Lno/ks/kes/jdbc/hwm/SqlServerHwmTrackerRepository;", "template", "Lorg/springframework/jdbc/core/namedparam/NamedParameterJdbcTemplate;", "transactionManager", "Lorg/springframework/jdbc/datasource/DataSourceTransactionManager;", "deleteTimeout", "", "timeout", "Lno/ks/kes/lib/SagaRepository$Timeout;", "getReadyTimeouts", "getSagaState", "T", "", "correlationId", "Ljava/util/UUID;", "serializationId", "sagaStateClass", "Lkotlin/reflect/KClass;", "(Ljava/util/UUID;Ljava/lang/String;Lkotlin/reflect/KClass;)Ljava/lang/Object;", "transactionally", "runnable", "Lkotlin/Function0;", "update", "states", "", "Lno/ks/kes/lib/SagaRepository$Operation;", "k-es-jdbc"})
@SourceDebugExtension(value={"SMAP\nSqlServerSagaRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlServerSagaRepository.kt\nno/ks/kes/jdbc/saga/SqlServerSagaRepository\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,158:1\n800#2,11:159\n1549#2:170\n1620#2,3:171\n800#2,11:176\n1360#2:187\n1446#2,2:188\n1549#2:190\n1620#2,3:191\n1448#2,3:194\n800#2,11:199\n766#2:210\n857#2,2:211\n1549#2:213\n1620#2,3:214\n1360#2:219\n1446#2,5:220\n1549#2:225\n1620#2,3:226\n37#3,2:174\n37#3,2:197\n37#3,2:217\n37#3,2:229\n*S KotlinDebug\n*F\n+ 1 SqlServerSagaRepository.kt\nno/ks/kes/jdbc/saga/SqlServerSagaRepository\n*L\n105#1:159,11\n106#1:170\n106#1:171,3\n117#1:176,11\n118#1:187\n118#1:188,2\n119#1:190\n119#1:191,3\n118#1:194,3\n133#1:199,11\n134#1:210\n134#1:211,2\n135#1:213\n135#1:214,3\n149#1:219\n149#1:220,5\n149#1:225\n149#1:226,3\n112#1:174,2\n128#1:197,2\n141#1:217,2\n156#1:229,2\n*E\n"})
public final class SqlServerSagaRepository
implements SagaRepository {
    @NotNull
    private final SagaStateSerdes sagaStateSerdes;
    @NotNull
    private final CmdSerdes cmdSerdes;
    @Nullable
    private final String schema;
    @NotNull
    private final NamedParameterJdbcTemplate template;
    @NotNull
    private final DataSourceTransactionManager transactionManager;
    @NotNull
    private final SqlServerHwmTrackerRepository hwmTracker;

    public SqlServerSagaRepository(@NotNull DataSource dataSource, @NotNull SagaStateSerdes sagaStateSerdes, @NotNull CmdSerdes cmdSerdes, long initialHwm, @Nullable String schema) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)sagaStateSerdes, (String)"sagaStateSerdes");
        Intrinsics.checkNotNullParameter((Object)cmdSerdes, (String)"cmdSerdes");
        this.sagaStateSerdes = sagaStateSerdes;
        this.cmdSerdes = cmdSerdes;
        this.schema = schema;
        this.template = new NamedParameterJdbcTemplate(dataSource);
        this.transactionManager = new DataSourceTransactionManager(dataSource);
        this.hwmTracker = new SqlServerHwmTrackerRepository(this.template, this.schema, initialHwm);
    }

    public /* synthetic */ SqlServerSagaRepository(DataSource dataSource, SagaStateSerdes sagaStateSerdes, CmdSerdes cmdSerdes, long l, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            l = -1L;
        }
        if ((n & 0x10) != 0) {
            string = null;
        }
        this(dataSource, sagaStateSerdes, cmdSerdes, l, string);
    }

    @NotNull
    public SqlServerHwmTrackerRepository getHwmTracker() {
        return this.hwmTracker;
    }

    public void transactionally(@NotNull Function0<Unit> runnable) {
        Intrinsics.checkNotNullParameter(runnable, (String)"runnable");
        new TransactionTemplate((PlatformTransactionManager)this.transactionManager).execute(arg_0 -> SqlServerSagaRepository.transactionally$lambda$0(runnable, arg_0));
    }

    @Nullable
    public SagaRepository.Timeout getReadyTimeouts() {
        List list = this.template.query("\n            SELECT TOP 1 sagaSerializationId, sagaCorrelationId, timeoutId             \n            FROM " + TimeoutTable.INSTANCE.qualifiedName(this.schema) + " \n            WITH (XLOCK)\n            WHERE error = 0\n            AND timeout  < CURRENT_TIMESTAMP \n        ", SqlServerSagaRepository::getReadyTimeouts$lambda$1);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"template.query(\"\"\"\n     \u2026)\n            )\n        }");
        return (SagaRepository.Timeout)CollectionsKt.singleOrNull((List)list);
    }

    public void deleteTimeout(@NotNull SagaRepository.Timeout timeout) {
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"sagaSerializationId", (Object)timeout.getSagaSerializationId()), TuplesKt.to((Object)"sagaCorrelationId", (Object)timeout.getSagaCorrelationId()), TuplesKt.to((Object)"timeoutId", (Object)timeout.getTimeoutId())};
        this.template.update("DELETE FROM " + TimeoutTable.INSTANCE.qualifiedName(this.schema) + "  \n                   WHERE sagaCorrelationId = :sagaCorrelationId\n                   AND sagaSerializationId = :sagaSerializationId\n                   AND timeoutId = :timeoutId\n                ", MapsKt.mutableMapOf((Pair[])pairArray));
    }

    @Nullable
    public <T> T getSagaState(@NotNull UUID correlationId, @NotNull String serializationId, @NotNull KClass<T> sagaStateClass) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)correlationId, (String)"correlationId");
        Intrinsics.checkNotNullParameter((Object)serializationId, (String)"serializationId");
        Intrinsics.checkNotNullParameter(sagaStateClass, (String)"sagaStateClass");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"correlationId", (Object)correlationId), TuplesKt.to((Object)"serializationId", (Object)serializationId)};
        List list = this.template.query("\n                    SELECT data                                                            \n                    FROM " + SagaTable.INSTANCE.qualifiedName(this.schema) + "\n                    WITH (XLOCK)\n                    WHERE correlationId = :correlationId \n                    AND serializationId = :serializationId", MapsKt.mutableMapOf((Pair[])pairArray), SqlServerSagaRepository::getSagaState$lambda$2);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"template.query(\n        \u2026tString(SagaTable.data) }");
        String string = (String)CollectionsKt.singleOrNull((List)list);
        if (string != null) {
            String it = string;
            boolean bl = false;
            byte[] byArray = it.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            object = this.sagaStateSerdes.deserialize(byArray, sagaStateClass);
        } else {
            object = null;
        }
        return (T)object;
    }

    /*
     * WARNING - void declaration
     */
    public void update(@NotNull Set<? extends SagaRepository.Operation> states) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Iterable list$iv$iv;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        Pair[] pairArray;
        SagaRepository.Operation.SagaUpdate it;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv;
        Intrinsics.checkNotNullParameter(states, (String)"states");
        SqlServerSagaRepositoryKt.access$getLog$p().info((Function0)new Function0<Object>(states){
            final /* synthetic */ Set<SagaRepository.Operation> $states;
            {
                this.$states = $states;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "updating sagas: " + this.$states;
            }
        });
        Iterable iterable = states;
        String string = "INSERT INTO " + SagaTable.INSTANCE.qualifiedName(this.schema) + " (correlationId, serializationId, data) VALUES (:correlationId, :serializationId, :data)";
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = this.template;
        boolean $i$f$filterIsInstance = false;
        void var4_6 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof SagaRepository.Operation.Insert)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Collection<Map> collection = (List)destination$iv$iv;
        $this$filterIsInstance$iv = collection;
        boolean $i$f$map = false;
        $this$filterIsInstanceTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            SagaRepository.Operation.Insert insert = (SagaRepository.Operation.Insert)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            pairArray = new Pair[]{TuplesKt.to((Object)"correlationId", (Object)it.getCorrelationId()), TuplesKt.to((Object)"serializationId", (Object)it.getSerializationId()), TuplesKt.to((Object)"data", (Object)new String(this.sagaStateSerdes.serialize(it.getNewState()), Charsets.UTF_8))};
            collection.add(MapsKt.mutableMapOf((Pair[])pairArray));
        }
        collection = (List)destination$iv$iv;
        Iterable $this$toTypedArray$iv = collection;
        boolean $i$f$toTypedArray = false;
        Iterable thisCollection$iv = $this$toTypedArray$iv;
        namedParameterJdbcTemplate.batchUpdate(string, thisCollection$iv.toArray(new Map[0]));
        $this$toTypedArray$iv = states;
        string = "INSERT INTO " + TimeoutTable.INSTANCE.qualifiedName(this.schema) + " (sagaCorrelationId, sagaSerializationId, timeoutId, timeout, error) VALUES (:sagaCorrelationId, :sagaSerializationId, :timeoutId, :timeout, 0)";
        namedParameterJdbcTemplate = this.template;
        $i$f$filterIsInstance = false;
        thisCollection$iv = $this$filterIsInstance$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof SagaRepository.Operation.SagaUpdate)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        collection = (List)destination$iv$iv;
        $this$filterIsInstance$iv = collection;
        boolean $i$f$flatMap = false;
        $this$filterIsInstanceTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            SagaRepository.Operation.SagaUpdate saga = (SagaRepository.Operation.SagaUpdate)element$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv2 = saga.getTimeouts();
            boolean $i$f$map2 = false;
            Iterable iterable2 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it2;
                Saga.Timeout timeout = (Saga.Timeout)item$iv$iv;
                Collection collection2 = destination$iv$iv2;
                boolean bl2 = false;
                Pair[] pairArray2 = new Pair[]{TuplesKt.to((Object)"sagaCorrelationId", (Object)saga.getCorrelationId()), TuplesKt.to((Object)"sagaSerializationId", (Object)saga.getSerializationId()), TuplesKt.to((Object)"timeoutId", (Object)it2.getTimeoutId()), TuplesKt.to((Object)"timeout", (Object)OffsetDateTime.ofInstant(it2.getTriggerAt(), ZoneOffset.UTC))};
                collection2.add(MapsKt.mutableMapOf((Pair[])pairArray2));
            }
            list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$toTypedArray$iv = collection = (List)destination$iv$iv;
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        namedParameterJdbcTemplate.batchUpdate(string, thisCollection$iv.toArray(new Map[0]));
        $this$toTypedArray$iv = states;
        string = "UPDATE " + SagaTable.INSTANCE.qualifiedName(this.schema) + " SET data = :data WHERE correlationId = :correlationId AND serializationId = :serializationId";
        namedParameterJdbcTemplate = this.template;
        $i$f$filterIsInstance = false;
        thisCollection$iv = $this$filterIsInstance$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof SagaRepository.Operation.SagaUpdate)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        collection = (List)destination$iv$iv;
        $this$filterIsInstance$iv = collection;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (SagaRepository.Operation.SagaUpdate)element$iv$iv;
            boolean bl = false;
            if (!(it.getNewState() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        collection = (List)destination$iv$iv;
        $this$filter$iv = collection;
        $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (SagaRepository.Operation.SagaUpdate)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            pairArray = new Pair[3];
            pairArray[0] = TuplesKt.to((Object)"correlationId", (Object)it.getCorrelationId());
            pairArray[1] = TuplesKt.to((Object)"serializationId", (Object)it.getSerializationId());
            Object object = it.getNewState();
            Intrinsics.checkNotNull((Object)object);
            pairArray[2] = TuplesKt.to((Object)"data", (Object)new String(this.sagaStateSerdes.serialize(object), Charsets.UTF_8));
            collection.add(MapsKt.mutableMapOf((Pair[])pairArray));
        }
        $this$toTypedArray$iv = collection = (List)destination$iv$iv;
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        namedParameterJdbcTemplate.batchUpdate(string, thisCollection$iv.toArray(new Map[0]));
        $this$toTypedArray$iv = states;
        string = " \n                        INSERT INTO " + CmdTable.INSTANCE.qualifiedName(this.schema) + " (serializationId, aggregateId, retries, nextExecution, error, data) \n                        VALUES (:serializationId, :aggregateId, 0, :nextExecution, 0, :data)                        \n                        ";
        namedParameterJdbcTemplate = this.template;
        $i$f$flatMap = false;
        thisCollection$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (SagaRepository.Operation)element$iv$iv;
            boolean bl = false;
            list$iv$iv = it.getCommands();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        collection = (List)destination$iv$iv;
        $this$flatMap$iv = collection;
        $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            list$iv$iv = (Cmd)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            pairArray = new Pair[]{TuplesKt.to((Object)"serializationId", (Object)this.cmdSerdes.getSerializationId(Reflection.getOrCreateKotlinClass(it.getClass()))), TuplesKt.to((Object)"aggregateId", (Object)it.getAggregateId()), TuplesKt.to((Object)"nextExecution", (Object)OffsetDateTime.now(ZoneOffset.UTC)), TuplesKt.to((Object)"data", (Object)new String(this.cmdSerdes.serialize((Cmd)it), Charsets.UTF_8))};
            collection.add(MapsKt.mutableMapOf((Pair[])pairArray));
        }
        $this$toTypedArray$iv = collection = (List)destination$iv$iv;
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        namedParameterJdbcTemplate.batchUpdate(string, thisCollection$iv.toArray((Map[])new Map[0]));
    }

    private static final Unit transactionally$lambda$0(Function0 $runnable, TransactionStatus it) {
        Intrinsics.checkNotNullParameter((Object)$runnable, (String)"$runnable");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        try {
            $runnable.invoke();
        }
        catch (Exception e) {
            SqlServerSagaRepositoryKt.access$getLog$p().error("An error was encountered while retrieving and executing saga-timeouts, transaction will be rolled back", (Throwable)e);
            throw e;
        }
        return Unit.INSTANCE;
    }

    private static final SagaRepository.Timeout getReadyTimeouts$lambda$1(ResultSet r, int n) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        String string = r.getString("sagaSerializationId");
        UUID uUID = UUID.fromString(r.getString("sagaCorrelationId"));
        String string2 = r.getString("timeoutId");
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"fromString(r.getString(T\u2026Table.sagaCorrelationId))");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(TimeoutTable.sagaSerializationId)");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(TimeoutTable.timeoutId)");
        return new SagaRepository.Timeout(uUID, string, string2);
    }

    private static final String getSagaState$lambda$2(ResultSet r, int n) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        return r.getString("data");
    }
}

